/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.admin.AdminCompositeKey;
import uk.co.real_logic.artio.admin.FixAdminSession;
import uk.co.real_logic.artio.messages.AllFixSessionsReplyDecoder;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.SlowStatus;

class AdminEndPointHandler {
    private long expectedCorrelationId;
    private boolean hasReceivedReply;
    private List<FixAdminSession> allFixSessions;
    private GatewayError errorType;
    private String errorMessage;

    AdminEndPointHandler() {
    }

    public boolean hasReceivedReply() {
        return this.hasReceivedReply;
    }

    public List<FixAdminSession> allFixSessions() {
        return this.allFixSessions;
    }

    public void onAllFixSessionsReply(long correlationId, AllFixSessionsReplyDecoder.SessionsDecoder sessions) {
        if (correlationId == this.expectedCorrelationId) {
            this.allFixSessions = new ArrayList<FixAdminSession>();
            while (sessions.hasNext()) {
                sessions.next();
                this.allFixSessions.add(new FixAdminSession(sessions.sessionId(), sessions.connectionId(), sessions.lastReceivedSequenceNumber(), sessions.lastSentSequenceNumber(), sessions.lastLogonTime(), sessions.sequenceIndex(), sessions.slowStatus() == SlowStatus.SLOW, sessions.address(), new AdminCompositeKey(sessions.localCompId(), sessions.localSubId(), sessions.localLocationId(), sessions.remoteCompId(), sessions.remoteSubId(), sessions.remoteLocationId())));
            }
            this.hasReceivedReply = true;
        }
    }

    public void expectedCorrelationId(long correlationId) {
        this.expectedCorrelationId = correlationId;
        this.hasReceivedReply = false;
    }

    public <T> T checkError() {
        if (this.errorType != null) {
            try {
                throw new FixGatewayException(this.errorMessage);
            }
            catch (Throwable throwable) {
                this.errorType = null;
                this.errorMessage = null;
                throw throwable;
            }
        }
        return null;
    }

    public void onGenericAdminReply(long correlationId, GatewayError errorType, String message) {
        if (correlationId == this.expectedCorrelationId) {
            if (errorType != null && errorType != GatewayError.NULL_VAL) {
                this.errorType = errorType;
                this.errorMessage = message;
            }
            this.hasReceivedReply = true;
        }
    }
}

