/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import io.aeron.Counter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;

public class FixCounters
implements AutoCloseable {
    private static final int MINIMUM_ARTIO_TYPE_ID = 10000;
    private final List<Counter> counters = new CopyOnWriteArrayList<Counter>();
    private final AtomicCounter failedInboundPublications;
    private final AtomicCounter failedOutboundPublications;
    private final AtomicCounter failedReplayPublications;
    private final AtomicCounter failedAdminReplyPublications;
    private final AtomicCounter currentReplayCount;
    private final AtomicCounter negativeTimestamps;
    private final Aeron aeron;

    public static IntHashSet lookupCounterIds(FixCountersId counterTypeId, CountersReader countersReader) {
        return FixCounters.lookupCounterIds(counterTypeId, countersReader, label -> true);
    }

    public static IntHashSet lookupCounterIds(FixCountersId counterTypeId, CountersReader countersReader, Predicate<String> labelCheck) {
        int requiredTypeId = counterTypeId.id();
        IntHashSet counterIds = new IntHashSet();
        countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId == requiredTypeId && labelCheck.test(label)) {
                counterIds.add(counterId);
            }
        });
        return counterIds;
    }

    FixCounters(Aeron aeron, boolean isEngine, int libraryId) {
        this.aeron = aeron;
        aeron.addUnavailableCounterHandler((countersReader, registrationId, counterId) -> this.counters.removeIf(counter -> counter.id() == counterId));
        this.failedInboundPublications = this.newCounter(FixCountersId.FAILED_INBOUND_TYPE_ID.id(), "Failed offer to inbound publication " + libraryId);
        this.failedOutboundPublications = this.newCounter(FixCountersId.FAILED_OUTBOUND_TYPE_ID.id(), "Failed offer to outbound publication " + libraryId);
        this.failedReplayPublications = this.newCounter(FixCountersId.FAILED_REPLAY_TYPE_ID.id(), "Failed offer to replay publication " + libraryId);
        this.failedAdminReplyPublications = this.newCounter(FixCountersId.FAILED_ADMIN_REPLY_TYPE_ID.id(), "Failed offer to admin reply publication " + libraryId);
        this.negativeTimestamps = this.newCounter(FixCountersId.NEGATIVE_TIMESTAMP_TYPE_ID.id(), "negative timestamps " + libraryId);
        this.currentReplayCount = isEngine ? this.newCounter(FixCountersId.CURRENT_REPLAY_COUNT_TYPE_ID.id(), "Current Replay Count") : null;
    }

    public AtomicCounter failedInboundPublications() {
        return this.failedInboundPublications;
    }

    public AtomicCounter failedOutboundPublications() {
        return this.failedOutboundPublications;
    }

    public AtomicCounter failedReplayPublications() {
        return this.failedReplayPublications;
    }

    public AtomicCounter failedAdminReplyPublications() {
        return this.failedAdminReplyPublications;
    }

    public AtomicCounter currentReplayCount() {
        return this.currentReplayCount;
    }

    public AtomicCounter negativeTimestamps() {
        return this.negativeTimestamps;
    }

    public AtomicCounter messagesRead(long connectionId, String address) {
        return this.newCounter(FixCountersId.MESSAGES_READ_TYPE_ID.id(), "Messages Read from " + address + " id = " + connectionId);
    }

    public AtomicCounter bytesInBuffer(long connectionId, String address) {
        return this.newCounter(FixCountersId.BYTES_IN_BUFFER_TYPE_ID.id(), "Quarantined bytes for " + address + " id = " + connectionId);
    }

    public AtomicCounter invalidLibraryAttempts(long connectionId, String address) {
        return this.newCounter(FixCountersId.INVALID_LIBRARY_ATTEMPTS_TYPE_ID.id(), "Invalid Library Attempts for " + address + " id = " + connectionId);
    }

    public AtomicCounter sentMsgSeqNo(long connectionId, long sessionId) {
        return this.newCounter(FixCountersId.SENT_MSG_SEQ_NO_TYPE_ID.id(), this.msgSeqNoLabel("Sent", connectionId, sessionId));
    }

    public AtomicCounter receivedMsgSeqNo(long connectionId, long sessionId) {
        return this.newCounter(FixCountersId.RECV_MSG_SEQ_NO_TYPE_ID.id(), this.msgSeqNoLabel("Received", connectionId, sessionId));
    }

    private String msgSeqNoLabel(String type, long connectionId, long sessionId) {
        boolean hasConnectionId;
        StringBuilder sb = new StringBuilder();
        sb.append("Last ");
        sb.append(type);
        sb.append(" MsgSeqNo ");
        boolean bl = hasConnectionId = connectionId != -1L;
        if (hasConnectionId) {
            sb.append("connId=");
            sb.append(connectionId);
        }
        if (sessionId != -1L) {
            if (hasConnectionId) {
                sb.append(",");
            }
            sb.append("sessId=");
            sb.append(sessionId);
        }
        return sb.toString();
    }

    private AtomicCounter newCounter(int typeId, String label) {
        Counter counter = this.aeron.addCounter(typeId, label);
        this.counters.add(counter);
        return counter;
    }

    @Override
    public void close() {
        Exceptions.closeAll(this.counters);
    }

    public static enum FixCountersId {
        FAILED_INBOUND_TYPE_ID(10000),
        FAILED_OUTBOUND_TYPE_ID(10001),
        FAILED_REPLAY_TYPE_ID(10002),
        MESSAGES_READ_TYPE_ID(10003),
        BYTES_IN_BUFFER_TYPE_ID(10004),
        INVALID_LIBRARY_ATTEMPTS_TYPE_ID(10005),
        SENT_MSG_SEQ_NO_TYPE_ID(10006),
        RECV_MSG_SEQ_NO_TYPE_ID(10007),
        CURRENT_REPLAY_COUNT_TYPE_ID(10008),
        NEGATIVE_TIMESTAMP_TYPE_ID(10009),
        FAILED_ADMIN_TYPE_ID(10010),
        FAILED_ADMIN_REPLY_TYPE_ID(10011);

        final int id;

        private FixCountersId(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

