/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import uk.co.real_logic.artio.MonitoringAgent;
import uk.co.real_logic.artio.MonitoringFile;
import uk.co.real_logic.artio.engine.EngineConfiguration;

public class ErrorPrinter
implements MonitoringAgent {
    static final ErrorConsumer PRINTING_ERROR_CONSUMER = (observationCount, firstObservationTimestampInMs, lastObservationTimestampInMs, encodedException) -> {
        System.err.println(encodedException);
        System.err.printf("count=%d,firstTime=%d,lastTime=%d%n%n", observationCount, firstObservationTimestampInMs, lastObservationTimestampInMs);
    };
    private volatile boolean archiverStopped = false;
    private final ErrorConsumer errorConsumer;
    private final EpochClock clock;
    private final AtomicBuffer errorBuffer;
    private final String agentNamePrefix;
    private final AeronArchive aeronArchive;
    private long lastPollTimeInMs;

    public static void main(String[] args) {
        EngineConfiguration configuration = new EngineConfiguration();
        configuration.libraryAeronChannel("").conclude();
        MonitoringFile monitoringFile = new MonitoringFile(false, configuration);
        ErrorPrinter printer = new ErrorPrinter(monitoringFile.errorBuffer(), "", 0L, null, null, (EpochClock)new SystemEpochClock());
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(1L, 1L, 1000L, 1000000L);
        AgentRunner runner = new AgentRunner((IdleStrategy)idleStrategy, Throwable::printStackTrace, null, (Agent)printer);
        runner.run();
    }

    ErrorPrinter(AtomicBuffer errorBuffer, String agentNamePrefix, long startTimeInMs, AeronArchive aeronArchive, ErrorConsumer customErrorConsumer, EpochClock clock) {
        this.errorBuffer = errorBuffer;
        this.agentNamePrefix = agentNamePrefix;
        this.lastPollTimeInMs = startTimeInMs;
        this.aeronArchive = aeronArchive;
        this.errorConsumer = customErrorConsumer == null ? PRINTING_ERROR_CONSUMER : customErrorConsumer;
        this.clock = clock;
    }

    public int doWork() {
        long lastPolledTimeInMs;
        long timeInMs;
        int work = 0;
        if (this.aeronArchive != null && !this.archiverStopped) {
            String errorResponse;
            try {
                errorResponse = this.aeronArchive.pollForErrorResponse();
            }
            catch (ArchiveException e) {
                errorResponse = e.getMessage();
            }
            if (errorResponse != null && !this.archiverStopped) {
                System.err.println(errorResponse);
                ++work;
            }
        }
        if ((timeInMs = this.clock.time()) > (lastPolledTimeInMs = this.lastPollTimeInMs)) {
            this.lastPollTimeInMs = timeInMs;
            int errors = ErrorLogReader.read((AtomicBuffer)this.errorBuffer, (ErrorConsumer)this.errorConsumer, (long)(lastPolledTimeInMs + 1L));
            work += errors;
        }
        return work;
    }

    public String roleName() {
        return this.agentNamePrefix + "Error Printer";
    }

    @Override
    public void archiverStopped() {
        this.archiverStopped = true;
    }
}

