/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.agrona.DirectBuffer;
import org.agrona.Verify;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.SessionConstants;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.CancelOnDisconnect;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.ThrottleConfigurationStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.FixSessionOwner;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.ResendRequestController;
import uk.co.real_logic.artio.session.ResendRequestResponse;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.EpochFractionClock;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class Session {
    public static final int UNKNOWN = -1;
    public static final long UNKNOWN_TIME = -1L;
    static final short ACTIVE_VALUE = 3;
    static final short LOGGING_OUT_VALUE = 5;
    static final short LOGGING_OUT_AND_DISCONNECTING_VALUE = 6;
    static final short AWAITING_LOGOUT_VALUE = 7;
    static final short DISCONNECTING_VALUE = 8;
    static final short DISCONNECTED_VALUE = 9;
    static final short DISABLED_VALUE = 10;
    static final short AWAITING_ASYNC_PROXY_LOGOUT_VALUE = 11;
    private static final long NO_OPERATION = Integer.MIN_VALUE;
    static final long LIBRARY_DISCONNECTED = -2147483647L;
    private static final int INITIAL_SEQUENCE_NUMBER = 1;
    public static final long NO_REPLAY_CORRELATION_ID = 0L;
    private static final double HEARTBEAT_PAUSE_FACTOR = 0.8;
    static final String TEST_REQ_ID = "TEST";
    private static final char[] TEST_REQ_ID_CHARS = "TEST".toCharArray();
    private static final int NO_LOGOUT_REJECT_REASON = -1;
    private final UtcTimestampEncoder timestampEncoder;
    protected final SessionIdStrategy sessionIdStrategy;
    protected final GatewayPublication outboundPublication;
    protected final MutableAsciiBuffer asciiBuffer;
    protected final int libraryId;
    protected final SessionProxy proxy;
    private final EpochFractionClock epochFractionClock;
    private final EpochNanoClock clock;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInNs;
    private final GatewayPublication inboundPublication;
    private final SessionCustomisationStrategy customisationStrategy;
    private final OnMessageInfo messageInfo;
    private final CancelOnDisconnect cancelOnDisconnect;
    private boolean backpressuredResendRequestResponse = false;
    private boolean backpressuredOutboundValidResendRequest = false;
    private final ResendRequestResponse resendRequestResponse = new ResendRequestResponse();
    private final ResendRequestController resendRequestController;
    private final int forcedHeartbeatIntervalInS;
    private int configuredHeartbeatIntervalInS;
    private final boolean disableHeartbeatRepliesToTestRequests;
    private boolean disconnectOnFirstMessageNotLogon;
    private final BooleanSupplier saveSeqIndexSyncFunc = this::saveSeqIndexSync;
    private final InternalSession.Formatters formatters;
    private boolean initiatorResetSeqNum;
    private CompositeKey sessionKey;
    private SessionState state;
    private String beginString;
    private AtomicCounter receivedMsgSeqNo;
    private AtomicCounter sentMsgSeqNo;
    private boolean awaitingResend = false;
    private int lastResentMsgSeqNo = 0;
    private int lastResendChunkMsgSeqNum = 0;
    private int endOfResendRequestRange = 0;
    private boolean awaitingLogonReply = false;
    private boolean awaitingHeartbeat = false;
    private boolean enableLastMsgSeqNumProcessed;
    protected long connectionId;
    private long id = -1L;
    private int lastReceivedMsgSeqNum;
    private int lastMsgSeqNumProcessed;
    private int lastSentMsgSeqNum;
    private int sequenceIndex;
    private long nextReplayCorrelationId = ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE);
    private long heartbeatIntervalInNs;
    private long nextRequiredInboundMessageTimeInNs;
    private long sendingHeartbeatIntervalInNs;
    private long nextRequiredHeartbeatTimeInNs;
    private long awaitingLogoutTimeoutInNs;
    private String username;
    private String password;
    private String connectedHost;
    private int connectedPort;
    private long lastLogonTimeInNs = -1L;
    private long lastSequenceResetTimeInNs = -1L;
    private boolean closedResendInterval;
    private int resendRequestChunkSize;
    private boolean sendRedundantResendRequests;
    private boolean incorrectBeginString = false;
    private FixSessionOwner fixSessionOwner;
    private int logoutRejectReason = -1;
    private FixDictionary fixDictionary;
    private long cancelOnDisconnectTimeoutWindowInNs = Long.MIN_VALUE;
    private boolean isSlowConsumer;
    CancelOnDisconnectOption cancelOnDisconnectOption;
    private int replaysInFlight = 0;
    protected ConnectionType connectionType;
    private DisconnectReason pendingDisconnectReason;

    Session(int heartbeatIntervalInS, long connectionId, EpochNanoClock clock, SessionState state, boolean initiatorResetSeqNum, SessionProxy proxy, GatewayPublication inboundPublication, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, long sendingTimeWindowInMs, AtomicCounter receivedMsgSeqNo, AtomicCounter sentMsgSeqNo, int libraryId, int initialSentSequenceNumber, int sequenceIndex, long reasonableTransmissionTimeInMs, MutableAsciiBuffer asciiBuffer, boolean enableLastMsgSeqNumProcessed, SessionCustomisationStrategy customisationStrategy, OnMessageInfo messageInfo, EpochFractionClock epochFractionClock, ConnectionType connectionType, ResendRequestController resendRequestController, int forcedHeartbeatIntervalInS, boolean disableHeartbeatRepliesToTestRequests, boolean disconnectOnFirstMessageNotLogon, InternalSession.Formatters formatters) {
        Verify.notNull((Object)state, (String)"session state");
        Verify.notNull((Object)proxy, (String)"session proxy");
        Verify.notNull((Object)outboundPublication, (String)"outboundPublication");
        Verify.notNull((Object)receivedMsgSeqNo, (String)"received MsgSeqNo counter");
        Verify.notNull((Object)sentMsgSeqNo, (String)"sent MsgSeqNo counter");
        Verify.notNull((Object)messageInfo, (String)"messageInfo");
        Verify.notNull((Object)epochFractionClock, (String)"epochFractionClock");
        Verify.notNull((Object)connectionType, (String)"connectionType");
        Verify.notNull((Object)formatters, (String)"formatters");
        this.initiatorResetSeqNum = initiatorResetSeqNum;
        this.resendRequestController = resendRequestController;
        this.forcedHeartbeatIntervalInS = forcedHeartbeatIntervalInS;
        this.disableHeartbeatRepliesToTestRequests = disableHeartbeatRepliesToTestRequests;
        this.messageInfo = messageInfo;
        this.proxy = proxy;
        this.outboundPublication = outboundPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        this.receivedMsgSeqNo = receivedMsgSeqNo;
        this.sentMsgSeqNo = sentMsgSeqNo;
        this.libraryId = libraryId;
        this.lastSentMsgSeqNum = initialSentSequenceNumber - 1;
        this.reasonableTransmissionTimeInNs = TimeUnit.MILLISECONDS.toNanos(reasonableTransmissionTimeInMs);
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        this.asciiBuffer = asciiBuffer;
        this.clock = clock;
        this.inboundPublication = inboundPublication;
        this.customisationStrategy = customisationStrategy;
        this.connectionType = connectionType;
        this.disconnectOnFirstMessageNotLogon = disconnectOnFirstMessageNotLogon;
        this.formatters = formatters;
        this.connectionId(connectionId);
        if (state == SessionState.DISCONNECTED && sequenceIndex == -1) {
            this.sequenceIndex(0);
        } else {
            this.sequenceIndex(sequenceIndex);
        }
        this.state(state);
        this.heartbeatIntervalInS(heartbeatIntervalInS);
        this.lastMsgSeqNumProcessed = this.enableLastMsgSeqNumProcessed ? 0 : -1;
        this.timestampEncoder = new UtcTimestampEncoder(epochFractionClock.epochFractionPrecision());
        this.epochFractionClock = epochFractionClock;
        this.cancelOnDisconnect = new CancelOnDisconnect(clock, connectionType == ConnectionType.ACCEPTOR, deadlineInNs -> !Pressure.isBackPressured(proxy.sendCancelOnDisconnectTrigger(this.id(), deadlineInNs)));
    }

    public boolean isConnected() {
        SessionState state = this.state();
        return state != SessionState.CONNECTING && state != SessionState.DISCONNECTED && state != SessionState.DISABLED;
    }

    public SessionState state() {
        return this.state;
    }

    public boolean awaitingResend() {
        return this.awaitingResend;
    }

    public boolean awaitingHeartbeat() {
        return this.awaitingHeartbeat;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int lastSentMsgSeqNum() {
        return this.lastSentMsgSeqNum;
    }

    public int lastReceivedMsgSeqNum() {
        return this.lastReceivedMsgSeqNum;
    }

    public long heartbeatIntervalInMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.heartbeatIntervalInNs);
    }

    public String connectedHost() {
        return this.connectedHost;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public long id() {
        return this.id;
    }

    public CompositeKey compositeKey() {
        return this.sessionKey;
    }

    public int connectedPort() {
        return this.connectedPort;
    }

    public CancelOnDisconnectOption cancelOnDisconnectOption() {
        return this.cancelOnDisconnectOption;
    }

    public long cancelOnDisconnectTimeoutWindowInNs() {
        return this.cancelOnDisconnectTimeoutWindowInNs;
    }

    public boolean isSlowConsumer() {
        return this.isSlowConsumer;
    }

    public long startLogout() {
        long position = this.trySendLogout();
        if (position < 0L) {
            this.state(SessionState.LOGGING_OUT);
        } else if (!this.proxy.isAsync()) {
            this.onStartLogout();
        }
        return position;
    }

    void onStartLogout() {
        this.awaitingLogoutTimeoutInNs = this.timeInNs() + this.heartbeatIntervalInNs;
        this.state(SessionState.AWAITING_LOGOUT);
    }

    void onSessionWriterLogout() {
        if (this.state() == SessionState.AWAITING_ASYNC_PROXY_LOGOUT) {
            DisconnectReason reason = DisconnectReason.LOGOUT;
            if (this.pendingDisconnectReason != null) {
                reason = this.pendingDisconnectReason;
                this.pendingDisconnectReason = null;
            }
            this.requestDisconnect(reason);
        } else {
            this.onStartLogout();
        }
    }

    public long requestDisconnect() {
        return this.requestDisconnect(DisconnectReason.APPLICATION_DISCONNECT);
    }

    long requestDisconnect(DisconnectReason reason) {
        long position = Integer.MIN_VALUE;
        if (this.state() != SessionState.DISCONNECTED) {
            position = this.proxy.sendRequestDisconnect(this.connectionId, reason);
            this.state(position < 0L ? SessionState.DISCONNECTING : SessionState.DISCONNECTED);
        }
        return position;
    }

    public Reply<ThrottleConfigurationStatus> throttleMessagesAt(int throttleWindowInMs, int throttleLimitOfMessages) {
        EngineConfiguration.validateMessageThrottleOptions(throttleWindowInMs, throttleLimitOfMessages);
        return this.fixSessionOwner.messageThrottle(this.id, throttleWindowInMs, throttleLimitOfMessages);
    }

    public long logoutAndDisconnect() {
        return this.logoutAndDisconnect(DisconnectReason.APPLICATION_DISCONNECT);
    }

    long logoutAndDisconnect(DisconnectReason reason) {
        long position = Integer.MIN_VALUE;
        if (this.state() != SessionState.DISCONNECTED) {
            position = this.trySendLogout();
            if (position < 0L) {
                this.state(SessionState.LOGGING_OUT_AND_DISCONNECTING);
            } else if (this.proxy.isAsync()) {
                this.disconnectAfterAsyncLogout(reason);
            } else {
                position = this.requestDisconnect(reason);
            }
        }
        return position;
    }

    public int prepare(SessionHeaderEncoder header) {
        int sentSeqNum = this.newSentSeqNum();
        header.msgSeqNum(sentSeqNum).sendingTime(this.timestampEncoder.buffer(), this.timestampEncoder.encode(this.epochFractionClock.epochFractionTime()));
        if (this.enableLastMsgSeqNumProcessed) {
            header.lastMsgSeqNumProcessed(this.lastMsgSeqNumProcessed);
        }
        if (!header.hasSenderCompID()) {
            this.sessionIdStrategy.setupSession(this.sessionKey, header);
        }
        this.customisationStrategy.configureHeader(header, this.id);
        return sentSeqNum;
    }

    public long trySend(Encoder encoder) {
        return this.trySend(encoder, null, 0);
    }

    public long trySend(Encoder encoder, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        int sentSeqNum = this.prepare(encoder.header());
        long result = encoder.encode(this.asciiBuffer, 0);
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        long type = encoder.messageType();
        return this.trySend((DirectBuffer)this.asciiBuffer, offset, length, sentSeqNum, type, metaDataBuffer, metaDataUpdateOffset);
    }

    public long trySend(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType) {
        return this.trySend(messageBuffer, offset, length, seqNum, messageType, null, 0);
    }

    public long trySend(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        long connectionId = this.state == SessionState.ACTIVE ? this.connectionId : -1L;
        long position = this.outboundPublication.saveMessage(messageBuffer, offset, length, this.libraryId, messageType, this.id(), this.sequenceIndex(), connectionId, MessageStatus.OK, seqNum, metaDataBuffer, metaDataUpdateOffset);
        if (position > 0L) {
            this.lastSentMsgSeqNum(seqNum, position);
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Sent ", messageBuffer, offset, length);
        }
        return position;
    }

    @Deprecated
    public boolean canSendMessage() {
        return true;
    }

    public long trySendSequenceReset(int nextSentMessageSequenceNumber) {
        boolean resetsSequenceNumbers = this.resetsSentSequenceNumbers(nextSentMessageSequenceNumber);
        int newSequenceIndex = this.sequenceIndex() + (resetsSequenceNumbers ? 1 : 0);
        long position = this.proxy.sendSequenceReset(this.lastSentMsgSeqNum, nextSentMessageSequenceNumber, newSequenceIndex, this.lastMsgSeqNumProcessed);
        if (resetsSequenceNumbers) {
            this.nextSequenceIndex(this.clock.nanoTime(), position);
        }
        this.lastSentMsgSeqNum(nextSentMessageSequenceNumber - 1, position);
        return position;
    }

    private boolean resetsSentSequenceNumbers(int nextSentMessageSequenceNumber) {
        return nextSentMessageSequenceNumber <= this.lastSentMsgSeqNum + 1;
    }

    @Deprecated
    public long sendSequenceReset(int nextSentMessageSequenceNumber) {
        return this.trySendSequenceReset(nextSentMessageSequenceNumber);
    }

    public long trySendSequenceReset(int nextSentMessageSequenceNumber, int nextReceivedMessageSequenceNumber) {
        boolean resetReceivedSequenceNumbers;
        boolean resetsSentSequenceNumbers = this.resetsSentSequenceNumbers(nextSentMessageSequenceNumber);
        boolean bl = resetReceivedSequenceNumbers = nextReceivedMessageSequenceNumber <= this.lastReceivedMsgSeqNum + 1;
        if (resetsSentSequenceNumbers != resetReceivedSequenceNumbers) {
            throw new IllegalArgumentException("Cannot reset received but not sent sequence numbers");
        }
        long position = this.trySendSequenceReset(nextSentMessageSequenceNumber);
        if (position >= 0L) {
            int newLastReceivedMessageSequenceNumber = nextReceivedMessageSequenceNumber - 1;
            this.lastReceivedMsgSeqNumOnly(newLastReceivedMessageSequenceNumber);
            long redactPositon = this.fixSessionOwner.inboundMessagePosition();
            if (this.redact(redactPositon)) {
                this.fixSessionOwner.enqueueTask(() -> this.redact(redactPositon));
            }
        }
        return position;
    }

    public long tryUpdateLastReceivedSequenceNumber(int lastReceivedMsgSeqNum) {
        long position = this.saveRedact(-1000L, lastReceivedMsgSeqNum);
        if (position > 0L) {
            if (this.lastReceivedMsgSeqNum > lastReceivedMsgSeqNum && !this.saveSeqIndexSync()) {
                this.fixSessionOwner.enqueueTask(this.saveSeqIndexSyncFunc);
            }
            this.lastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
        }
        return position;
    }

    private boolean saveSeqIndexSync() {
        return this.outboundPublication.saveSeqIndexSync(this.libraryId, this.id, this.sequenceIndex + 1) > 0L;
    }

    @Deprecated
    public long sendSequenceReset(int nextSentMessageSequenceNumber, int nextReceivedMessageSequenceNumber) {
        return this.trySendSequenceReset(nextSentMessageSequenceNumber, nextReceivedMessageSequenceNumber);
    }

    private void nextSequenceIndex(long messageTimeInNs, long position) {
        if (position >= 0L) {
            this.nextSequenceIndex(messageTimeInNs);
        }
    }

    private void nextSequenceIndex(long messageTimeInNs) {
        ++this.sequenceIndex;
        this.lastSequenceResetTimeInNs(messageTimeInNs);
    }

    public long tryResetSequenceNumbers() {
        if (this.state == SessionState.DISCONNECTED) {
            return this.trySendSequenceReset(1, 1);
        }
        boolean sentSeqNum = true;
        long position = this.proxy.sendLogon(1, this.configuredHeartbeatIntervalInS, this.username(), this.password(), true, this.sequenceIndex() + 1, this.lastMsgSeqNumProcessed, this.cancelOnDisconnectOption, this.getCancelOnDisconnectTimeoutWindowInMs());
        this.nextSequenceIndex(this.clock.nanoTime(), position);
        this.lastSentMsgSeqNum(1, position);
        if (position >= 0L) {
            this.awaitingLogonReply(true);
        }
        return position;
    }

    @Deprecated
    public long resetSequenceNumbers() {
        return this.tryResetSequenceNumbers();
    }

    public boolean isActive() {
        return this.state == SessionState.ACTIVE;
    }

    public boolean isAcceptor() {
        return this.connectionType == ConnectionType.ACCEPTOR;
    }

    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    public void onDisconnect() {
        this.logoutRejectReason = -1;
        this.state(SessionState.DISCONNECTED);
        this.address("", -1);
        this.connectionId(-1L);
        this.replaysInFlight = 0;
        this.cancelOnDisconnect.checkCancelOnDisconnectDisconnect();
    }

    public Session lastReceivedMsgSeqNum(int lastReceivedMsgSeqNum) {
        if (this.lastReceivedMsgSeqNum > lastReceivedMsgSeqNum) {
            this.nextSequenceIndex(this.clock.nanoTime());
        }
        this.lastReceivedMsgSeqNumOnly(lastReceivedMsgSeqNum);
        return this;
    }

    public long lastLogonTimeInNs() {
        return this.lastLogonTimeInNs;
    }

    public long lastSequenceResetTimeInNs() {
        return this.lastSequenceResetTimeInNs;
    }

    public int lastSentMsgSeqNum(int lastSentMsgSeqNum) {
        this.lastSentMsgSeqNum = lastSentMsgSeqNum;
        this.sentMsgSeqNo.setOrdered((long)lastSentMsgSeqNum);
        this.incNextHeartbeatTime();
        return lastSentMsgSeqNum;
    }

    public boolean isReplaying() {
        return this.replaysInFlight > 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{connectionId=" + this.connectionId + ", sessionId=" + this.id + ", state=" + this.state + ", sequenceIndex=" + this.sequenceIndex + ", lastReceivedMsgSeqNum=" + this.lastReceivedMsgSeqNum + ", lastSentMsgSeqNum=" + this.lastSentMsgSeqNum + '}';
    }

    public String beginString() {
        return this.beginString;
    }

    public FixDictionary fixDictionary() {
        return this.fixDictionary;
    }

    public Reply<ReplayMessagesStatus> replayReceivedMessages(int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long timeout) {
        return this.fixSessionOwner.replayReceivedMessages(this.id, replayFromSequenceNumber, replayFromSequenceIndex, replayToSequenceNumber, replayToSequenceIndex, timeout);
    }

    ControlledFragmentHandler.Action onInvalidFixDisconnect() {
        return Pressure.apply(this.requestDisconnect(DisconnectReason.INVALID_FIX_MESSAGE));
    }

    private void lastSentMsgSeqNum(int sentSeqNum, long position) {
        if (position >= 0L) {
            this.lastSentMsgSeqNum(sentSeqNum);
        }
    }

    ControlledFragmentHandler.Action onMessage(int msgSeqNo, char[] msgType, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        return this.onMessage(msgSeqNo, msgType, msgType.length, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onMessage(int msgSeqNo, char[] msgType, int msgTypeLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        long timeInNs = this.timeInNs();
        ControlledFragmentHandler.Action action = this.checkStateAndValidateMessage(msgSeqNo, timeInNs, msgType, msgTypeLength, sendingTime, origSendingTime, possDup, position);
        if (action != null) {
            return action;
        }
        return this.checkSeqNoChange(msgSeqNo, timeInNs, isPossDupOrResend, position);
    }

    ControlledFragmentHandler.Action checkStateAndValidateMessage(int msgSeqNo, long timeInNs, char[] msgType, int msgTypeLength, long sendingTime, long origSendingTime, boolean possDup, long position) {
        SessionState state = this.state();
        if (state == SessionState.CONNECTED || this.disconnectOnFirstMessageNotLogon && state == SessionState.SENT_LOGON) {
            return Pressure.apply(this.requestDisconnect(DisconnectReason.FIRST_MESSAGE_NOT_LOGON));
        }
        if (state == SessionState.DISCONNECTED || state == SessionState.DISABLED) {
            this.messageInfo.isValid(false);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return this.validateRequiredFieldsAndCodec(msgSeqNo, timeInNs, msgType, msgTypeLength, sendingTime, origSendingTime, possDup, position);
    }

    private ControlledFragmentHandler.Action validateRequiredFieldsAndCodec(int msgSeqNo, long timeInNs, char[] msgType, int msgTypeLength, long sendingTimeInMs, long origSendingTimeInMs, boolean possDup, long position) {
        ControlledFragmentHandler.Action validationResult;
        if (msgSeqNo == Integer.MIN_VALUE) {
            int sentSeqNum = this.newSentSeqNum();
            return this.checkPositionAndDisconnect(this.proxy.sendReceivedMessageWithoutSequenceNumber(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.MSG_SEQ_NO_MISSING);
        }
        if (Validation.CODEC_VALIDATION_ENABLED && (validationResult = this.validateCodec(timeInNs, msgSeqNo, msgType, msgTypeLength, sendingTimeInMs, origSendingTimeInMs, possDup, position)) != null) {
            return validationResult;
        }
        return null;
    }

    private ControlledFragmentHandler.Action validateCodec(long timeInNs, int msgSeqNum, char[] msgType, int msgTypeLength, long sendingTimeInMs, long origSendingTimeInMs, boolean possDup, long position) {
        long timeInMs;
        if (possDup) {
            if (origSendingTimeInMs == -1L) {
                return this.onInvalidMessage(msgSeqNum, 122, msgType, msgTypeLength, RejectReason.REQUIRED_TAG_MISSING.representation(), position);
            }
            if (origSendingTimeInMs > sendingTimeInMs) {
                return this.rejectDueToSendingTime(msgSeqNum, msgType, msgTypeLength, position);
            }
        }
        if (sendingTimeInMs < (timeInMs = timeInNs / 1000000L) - this.sendingTimeWindowInMs || sendingTimeInMs > timeInMs + this.sendingTimeWindowInMs) {
            ControlledFragmentHandler.Action action = this.rejectDueToSendingTime(msgSeqNum, msgType, msgTypeLength, position);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.logoutRejectReason(RejectReason.SENDINGTIME_ACCURACY_PROBLEM.representation());
                this.logoutAndDisconnect(DisconnectReason.INVALID_SENDING_TIME);
            }
            return action;
        }
        return null;
    }

    ControlledFragmentHandler.Action checkSeqNoChange(int msgSeqNum, long timeInNs, boolean isPossDupOrResend, long position) {
        if (this.awaitingResend) {
            this.incNextReceivedInboundMessageTime(timeInNs);
            if (msgSeqNum == this.endOfResendMsgSeqNum()) {
                this.awaitingResend = false;
                this.lastResendChunkMsgSeqNum = 0;
                this.lastResentMsgSeqNo = 0;
                this.endOfResendRequestRange = 0;
            } else {
                if (msgSeqNum == this.lastResendChunkMsgSeqNum) {
                    ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(msgSeqNum + 1, this.endOfResendMsgSeqNum()));
                    if (action == ControlledFragmentHandler.Action.CONTINUE) {
                        this.lastResentMsgSeqNo = msgSeqNum;
                    }
                    return action;
                }
                if (msgSeqNum > this.endOfResendRequestRange) {
                    this.messageInfo.isValid(false);
                    if (this.sendRedundantResendRequests) {
                        return Pressure.apply(this.trySendResendRequest(this.endOfResendRequestRange + 1, msgSeqNum));
                    }
                    if (this.closedResendInterval) {
                        this.lastResendChunkMsgSeqNum = this.endOfResendRequestRange;
                        this.endOfResendRequestRange = msgSeqNum;
                    }
                    return this.checkNormalSeqNoChange(msgSeqNum, timeInNs, isPossDupOrResend, position);
                }
                this.lastResentMsgSeqNo = msgSeqNum;
            }
        } else {
            return this.checkNormalSeqNoChange(msgSeqNum, timeInNs, isPossDupOrResend, position);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action checkNormalSeqNoChange(int msgSeqNum, long time, boolean isPossDupOrResend, long position) {
        int expectedSeqNo = this.expectedReceivedSeqNum();
        if (expectedSeqNo == msgSeqNum) {
            this.incNextReceivedInboundMessageTime(time);
            this.lastReceivedMsgSeqNum(msgSeqNum);
        } else {
            if (expectedSeqNo < msgSeqNum) {
                return this.requestResend(expectedSeqNo, msgSeqNum);
            }
            if (!isPossDupOrResend) {
                return this.msgSeqNumTooLow(msgSeqNum, expectedSeqNo, position);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private int endOfResendMsgSeqNum() {
        return this.endOfResendRequestRange;
    }

    private ControlledFragmentHandler.Action requestResend(int expectedSeqNo, int receivedMsgSeqNo) {
        long position = this.trySendResendRequest(expectedSeqNo, receivedMsgSeqNo);
        if (position >= 0L) {
            this.messageInfo.isValid(false);
            this.awaitingResend = true;
            this.lastResentMsgSeqNo = expectedSeqNo - 1;
            this.lastReceivedMsgSeqNum = receivedMsgSeqNo;
            this.endOfResendRequestRange = receivedMsgSeqNo;
        }
        return this.checkPosition(position);
    }

    private long trySendResendRequest(int expectedSeqNo, int receivedMsgSeqNo) {
        int cappedEndSeqNo;
        boolean chunkedResend = this.resendRequestChunkSize != 0;
        int n = cappedEndSeqNo = chunkedResend ? expectedSeqNo + this.resendRequestChunkSize - 1 : receivedMsgSeqNo;
        int endSeqNo = cappedEndSeqNo < receivedMsgSeqNo ? cappedEndSeqNo : (this.closedResendInterval ? receivedMsgSeqNo : 0);
        long position = this.proxy.sendResendRequest(this.newSentSeqNum(), expectedSeqNo, endSeqNo, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
        if (position > 0L && chunkedResend) {
            this.lastResendChunkMsgSeqNum = cappedEndSeqNo;
        }
        return position;
    }

    private ControlledFragmentHandler.Action msgSeqNumTooLow(int msgSeqNo, int expectedSeqNo, long position) {
        if (this.redact(position)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        return this.checkPositionAndDisconnect(this.proxy.sendLowSequenceNumberLogout(this.newSentSeqNum(), expectedSeqNo, msgSeqNo, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.MSG_SEQ_NO_TOO_LOW);
    }

    private boolean redact(long position) {
        this.messageInfo.isValid(false);
        return this.saveRedact(position, this.lastReceivedMsgSeqNum) < 0L;
    }

    private long saveRedact(long position, int lastReceivedMsgSeqNum) {
        return this.inboundPublication.saveRedactSequenceUpdate(this.id, lastReceivedMsgSeqNum, position);
    }

    private ControlledFragmentHandler.Action checkPosition(long position) {
        if (position < 0L) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.lastSentMsgSeqNum(this.newSentSeqNum());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action rejectDueToSendingTime(int msgSeqNo, char[] msgType, int msgTypeLength, long position) {
        return this.onInvalidMessage(msgSeqNo, 52, msgType, msgTypeLength, RejectReason.SENDINGTIME_ACCURACY_PROBLEM.representation(), position);
    }

    void incNextReceivedInboundMessageTime(long timeInNs) {
        this.nextRequiredInboundMessageTimeInNs = timeInNs + this.heartbeatIntervalInNs + this.reasonableTransmissionTimeInNs;
    }

    ControlledFragmentHandler.Action onLogon(int heartbeatIntervalInS, int msgSeqNum, long sendingTimeInMs, long origSendingTimeInMs, String username, String password, boolean isPossDupOrResend, boolean resetSeqNumFlag, boolean possDup, long position, CancelOnDisconnectOption cancelOnDisconnectOption, int cancelOnDisconnectTimeoutWindowInMs) {
        ControlledFragmentHandler.Action action = this.validateOrRejectHeartbeat(heartbeatIntervalInS);
        if (action != null) {
            return action;
        }
        action = this.validateOrRejectSendingTime(sendingTimeInMs);
        if (action != null) {
            return action;
        }
        long logonTimeInNs = this.clock.nanoTime();
        this.cancelOnDisconnectOption(cancelOnDisconnectOption);
        this.cancelOnDisconnectTimeoutWindowInNs(TimeUnit.MILLISECONDS.toNanos(cancelOnDisconnectTimeoutWindowInMs));
        if (resetSeqNumFlag) {
            return this.onResetSeqNumLogon(heartbeatIntervalInS, username, password, logonTimeInNs, msgSeqNum);
        }
        if (this.state() == this.initialState()) {
            int expectedMsgSeqNo = this.expectedReceivedSeqNum();
            if (expectedMsgSeqNo == msgSeqNum) {
                action = this.respondToLogon(heartbeatIntervalInS);
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    return ControlledFragmentHandler.Action.ABORT;
                }
                if (this.proxy.seqNumResetRequested()) {
                    this.lastReceivedMsgSeqNum = 0;
                    this.nextSequenceIndex(logonTimeInNs);
                }
                this.setupCompleteLogonState(logonTimeInNs, heartbeatIntervalInS, username, password, this.timeInNs());
                if (this.lastReceivedMsgSeqNum == 0) {
                    this.lastSequenceResetTimeInNs(logonTimeInNs);
                }
                this.lastReceivedMsgSeqNum(msgSeqNum);
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            if (expectedMsgSeqNo < msgSeqNum) {
                action = this.respondToLogon(heartbeatIntervalInS);
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    return ControlledFragmentHandler.Action.ABORT;
                }
                boolean requestSeqNumReset = this.proxy.seqNumResetRequested();
                if (requestSeqNumReset) {
                    this.lastReceivedMsgSeqNum = 0;
                    this.setupCompleteLogonStateReset(logonTimeInNs, heartbeatIntervalInS, username, password, this.timeInNs());
                    this.nextSequenceIndex(logonTimeInNs);
                    return ControlledFragmentHandler.Action.CONTINUE;
                }
                this.setupCompleteLogonState(logonTimeInNs, heartbeatIntervalInS, username, password, this.timeInNs());
                action = this.requestResend(expectedMsgSeqNo, msgSeqNum);
                return action;
            }
            return this.msgSeqNumTooLow(msgSeqNum, expectedMsgSeqNo, position);
        }
        return this.onMessage(msgSeqNum, SessionConstants.LOGON_MESSAGE_TYPE_CHARS, sendingTimeInMs, origSendingTimeInMs, isPossDupOrResend, possDup, position);
    }

    void cancelOnDisconnectOption(CancelOnDisconnectOption cancelOnDisconnectOption) {
        this.cancelOnDisconnectOption = cancelOnDisconnectOption;
        this.cancelOnDisconnect.cancelOnDisconnectOption(cancelOnDisconnectOption);
    }

    protected ControlledFragmentHandler.Action respondToLogon(int heartbeatInterval) {
        if (this.connectionType == ConnectionType.ACCEPTOR) {
            return this.replyToLogon(heartbeatInterval);
        }
        return null;
    }

    protected SessionState initialState() {
        return this.connectionType == ConnectionType.ACCEPTOR ? SessionState.CONNECTED : SessionState.SENT_LOGON;
    }

    private ControlledFragmentHandler.Action onResetSeqNumLogon(int heartbeatInterval, String username, String password, long logonTimeInNs, int msgSeqNo) {
        if (this.awaitingLogonReply || this.lastSentMsgSeqNum == 1) {
            this.lastReceivedMsgSeqNumOnly(msgSeqNo);
            this.awaitingLogonReply(false);
        } else {
            int logonSequenceIndex = this.isInitialRequest() ? this.sequenceIndex() : this.sequenceIndex() + 1;
            long position = this.proxy.sendLogon(1, heartbeatInterval, null, null, true, logonSequenceIndex, this.lastMsgSeqNumProcessed, this.cancelOnDisconnectOption, this.getCancelOnDisconnectTimeoutWindowInMs());
            if (position < 0L) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            this.lastSentMsgSeqNum(1);
            this.lastReceivedMsgSeqNum(msgSeqNo);
            this.lastLogonTimeInNs(logonTimeInNs);
            this.lastSequenceResetTimeInNs(logonTimeInNs);
        }
        this.setupCompleteLogonStateReset(logonTimeInNs, heartbeatInterval, username, password, this.timeInNs());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void setupCompleteLogonStateReset(long logonTime, int heartbeatInterval, String username, String password, long timeInNs) {
        this.setupCompleteLogonState(logonTime, heartbeatInterval, username, password, timeInNs);
        this.lastSequenceResetTimeInNs(logonTime);
    }

    private void setupCompleteLogonState(long logonTimeInNs, int heartbeatIntervalInS, String username, String password, long timeInNs) {
        this.lastLogonTimeInNs(logonTimeInNs);
        this.setupLogonState(heartbeatIntervalInS, username, password, timeInNs);
    }

    private void setupLogonState(int heartbeatIntervalInS, String username, String password, long timeInNs) {
        this.incNextReceivedInboundMessageTime(timeInNs);
        this.heartbeatIntervalInS(heartbeatIntervalInS);
        this.state(SessionState.ACTIVE);
        this.username(username);
        this.password(password);
        if (this.fixSessionOwner != null) {
            this.fixSessionOwner.onLogon(this);
        }
    }

    void setupSession(long sessionId, CompositeKey sessionKey, WeakReference<SessionWriter> sessionWriterRef) {
        SessionWriter sessionWriter;
        this.id(sessionId);
        this.sessionKey = sessionKey;
        this.proxy.setupSession(sessionId, sessionKey);
        if (sessionWriterRef != null && (sessionWriter = (SessionWriter)sessionWriterRef.get()) != null) {
            sessionWriter.linkTo((InternalSession)this);
        }
    }

    private ControlledFragmentHandler.Action replyToLogon(int heartbeatInterval) {
        return this.checkPosition(this.proxy.sendLogon(this.newSentSeqNum(), heartbeatInterval, null, null, false, this.sequenceIndex(), this.lastMsgSeqNumProcessed, this.cancelOnDisconnectOption, this.getCancelOnDisconnectTimeoutWindowInMs()));
    }

    int getCancelOnDisconnectTimeoutWindowInMs() {
        if (this.cancelOnDisconnectTimeoutWindowInNs == Long.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)TimeUnit.NANOSECONDS.toMillis(this.cancelOnDisconnectTimeoutWindowInNs);
    }

    private ControlledFragmentHandler.Action validateOrRejectSendingTime(long sendingTimeInMs) {
        if (Validation.CODEC_VALIDATION_DISABLED && sendingTimeInMs == Long.MIN_VALUE) {
            return null;
        }
        long timeInMs = this.timeInNs() / 1000000L;
        if (sendingTimeInMs < timeInMs + this.sendingTimeWindowInMs && sendingTimeInMs > timeInMs - this.sendingTimeWindowInMs) {
            return null;
        }
        return this.checkPositionAndDisconnect(this.proxy.sendRejectWhilstNotLoggedOn(this.newSentSeqNum(), RejectReason.SENDINGTIME_ACCURACY_PROBLEM, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.INVALID_SENDING_TIME);
    }

    private ControlledFragmentHandler.Action validateOrRejectHeartbeat(int heartbeatIntervalInS) {
        if (heartbeatIntervalInS < 0) {
            this.messageInfo.isValid(false);
            return this.checkPositionAndDisconnect(this.proxy.sendNegativeHeartbeatLogout(this.newSentSeqNum(), this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.NEGATIVE_HEARTBEAT_INTERVAL);
        }
        return null;
    }

    private ControlledFragmentHandler.Action checkPositionAndDisconnect(long position, DisconnectReason reason) {
        ControlledFragmentHandler.Action action = this.checkPosition(position);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            if (this.proxy.isAsync()) {
                this.disconnectAfterAsyncLogout(reason);
            } else {
                this.requestDisconnect(reason);
            }
        }
        return action;
    }

    private void disconnectAfterAsyncLogout(DisconnectReason reason) {
        this.state(SessionState.AWAITING_ASYNC_PROXY_LOGOUT);
        this.pendingDisconnectReason = reason;
    }

    private boolean isInitialRequest() {
        return 0 == this.lastReceivedMsgSeqNum();
    }

    ControlledFragmentHandler.Action onLogout(int msgSeqNo, long sendingTimeInMs, long origSendingTimeInMs, boolean possDup, long position) {
        long timeInNs = this.timeInNs();
        ControlledFragmentHandler.Action action = this.validateRequiredFieldsAndCodec(msgSeqNo, timeInNs, SessionConstants.LOGON_MESSAGE_TYPE_CHARS, SessionConstants.LOGON_MESSAGE_TYPE_CHARS.length, sendingTimeInMs, origSendingTimeInMs, possDup, position);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.lastReceivedMsgSeqNum(msgSeqNo);
        this.cancelOnDisconnect.checkCancelOnDisconnectLogout(timeInNs);
        if (this.state() == SessionState.AWAITING_LOGOUT) {
            this.requestDisconnect(DisconnectReason.LOGOUT);
        } else {
            this.logoutAndDisconnect(DisconnectReason.LOGOUT);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onTestRequest(int msgSeqNo, char[] testReqId, int testReqIdLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        SessionState state = this.state;
        if (msgSeqNo == this.expectedReceivedSeqNum() && state != SessionState.DISCONNECTED && state != SessionState.DISABLED && !this.disableHeartbeatRepliesToTestRequests) {
            int sentSeqNum = this.newSentSeqNum();
            long sentPosition = this.proxy.sendHeartbeat(sentSeqNum, testReqId, testReqIdLength, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
            if (sentPosition < 0L) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            this.lastSentMsgSeqNum(sentSeqNum);
        }
        return this.onMessage(msgSeqNo, SessionConstants.TEST_REQUEST_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onSequenceReset(int msgSeqNo, int newSeqNo, boolean gapFillFlag, boolean possDupFlag, long position) {
        if (!gapFillFlag) {
            return this.applySequenceReset(msgSeqNo, newSeqNo, position);
        }
        if (newSeqNo >= msgSeqNo) {
            return this.onGapFill(msgSeqNo, newSeqNo, possDupFlag, position);
        }
        return this.applySequenceReset(msgSeqNo, newSeqNo, position);
    }

    private ControlledFragmentHandler.Action applySequenceReset(int receivedMsgSeqNo, int newSeqNo, long position) {
        int expectedMsgSeqNo = this.expectedReceivedSeqNum();
        if (newSeqNo > expectedMsgSeqNo) {
            this.lastReceivedMsgSeqNum(newSeqNo - 1);
        } else if (newSeqNo < expectedMsgSeqNo) {
            if (this.redact(position)) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            return this.checkPosition(this.proxy.sendReject(this.newSentSeqNum(), receivedMsgSeqNo, 36, SessionConstants.SEQUENCE_RESET_MESSAGE_TYPE_CHARS, SessionConstants.SEQUENCE_RESET_MESSAGE_TYPE_CHARS.length, RejectReason.VALUE_IS_INCORRECT.representation(), this.sequenceIndex(), this.lastMsgSeqNumProcessed));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onGapFill(int receivedMsgSeqNo, int newSeqNo, boolean possDupFlag, long position) {
        int expectedMsgSeqNo;
        int impliedSeqNoFromNewSeqNo = newSeqNo - 1;
        int n = expectedMsgSeqNo = this.awaitingResend ? this.lastResentMsgSeqNo + 1 : this.expectedReceivedSeqNum();
        if (receivedMsgSeqNo > expectedMsgSeqNo) {
            ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(expectedMsgSeqNo, receivedMsgSeqNo - 1));
            if (action != ControlledFragmentHandler.Action.ABORT) {
                if (this.awaitingResend) {
                    this.lastResentMsgSeqNo = impliedSeqNoFromNewSeqNo;
                } else {
                    this.lastReceivedMsgSeqNum(impliedSeqNoFromNewSeqNo);
                }
            }
            return action;
        }
        if (receivedMsgSeqNo < expectedMsgSeqNo) {
            if (!possDupFlag) {
                return this.msgSeqNumTooLow(receivedMsgSeqNo, expectedMsgSeqNo, position);
            }
        } else if (this.awaitingResend) {
            if (impliedSeqNoFromNewSeqNo == this.lastResendChunkMsgSeqNum) {
                ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(newSeqNo, this.endOfResendMsgSeqNum()));
                if (action == ControlledFragmentHandler.Action.CONTINUE) {
                    this.lastResentMsgSeqNo = impliedSeqNoFromNewSeqNo;
                }
                return action;
            }
            if (this.lastReceivedMsgSeqNum <= impliedSeqNoFromNewSeqNo) {
                this.awaitingResend = false;
                this.lastResentMsgSeqNo = 0;
                this.lastResendChunkMsgSeqNum = 0;
                this.endOfResendRequestRange = 0;
                if (this.lastReceivedMsgSeqNum < impliedSeqNoFromNewSeqNo) {
                    this.lastReceivedMsgSeqNum(impliedSeqNoFromNewSeqNo);
                }
            } else {
                this.lastResentMsgSeqNo = impliedSeqNoFromNewSeqNo;
            }
        } else {
            this.lastReceivedMsgSeqNum(impliedSeqNoFromNewSeqNo);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onResendRequest(int msgSeqNum, int beginSeqNum, int endSeqNum, boolean isPossDupOrResend, boolean possDup, long sendingTime, long origSendingTime, long position, AsciiBuffer messageBuffer, int messageOffset, int messageLength, AbstractResendRequestDecoder resendRequest) {
        boolean replayUpToMostRecent;
        long timeInNs = this.timeInNs();
        ControlledFragmentHandler.Action action = this.checkStateAndValidateMessage(msgSeqNum, timeInNs, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS.length, sendingTime, origSendingTime, possDup, position);
        if (action != null || !this.messageInfo.isValid()) {
            return action;
        }
        int oldLastReceivedMsgSeqNum = this.lastReceivedMsgSeqNum;
        ControlledFragmentHandler.Action checkSeqAction = this.checkNormalSeqNoChange(msgSeqNum, timeInNs, isPossDupOrResend, position);
        if (checkSeqAction == ControlledFragmentHandler.Action.ABORT) {
            this.lastReceivedMsgSeqNum(oldLastReceivedMsgSeqNum);
            return checkSeqAction;
        }
        boolean bl = replayUpToMostRecent = endSeqNum == 0;
        if (!replayUpToMostRecent) {
            if (endSeqNum < beginSeqNum) {
                return this.sendReject(msgSeqNum, 16, RejectReason.VALUE_IS_INCORRECT, oldLastReceivedMsgSeqNum);
            }
            if (beginSeqNum > this.lastSentMsgSeqNum) {
                return this.sendReject(msgSeqNum, 7, RejectReason.VALUE_IS_INCORRECT, oldLastReceivedMsgSeqNum);
            }
        }
        int correctedEndSeqNo = replayUpToMostRecent ? this.lastSentMsgSeqNum : Math.min(this.lastSentMsgSeqNum, endSeqNum);
        ResendRequestResponse resendRequestResponse = this.resendRequestResponse;
        if (!this.backpressuredResendRequestResponse) {
            this.resendRequestController.onResend(this, resendRequest, correctedEndSeqNo, resendRequestResponse);
        }
        if (resendRequestResponse.result()) {
            long correlationId = this.generateReplayCorrelationId();
            if (!this.backpressuredResendRequestResponse || this.backpressuredOutboundValidResendRequest) {
                if (this.saveValidResendRequest(beginSeqNum, messageBuffer, messageOffset, messageLength, correctedEndSeqNo, correlationId, this.outboundPublication)) {
                    this.lastReceivedMsgSeqNum(oldLastReceivedMsgSeqNum);
                    this.backpressuredResendRequestResponse = true;
                    this.backpressuredOutboundValidResendRequest = true;
                    return ControlledFragmentHandler.Action.ABORT;
                }
                this.backpressuredOutboundValidResendRequest = false;
            }
            if (this.saveValidResendRequest(beginSeqNum, messageBuffer, messageOffset, messageLength, correctedEndSeqNo, correlationId, this.inboundPublication)) {
                this.lastReceivedMsgSeqNum(oldLastReceivedMsgSeqNum);
                this.backpressuredResendRequestResponse = true;
                return ControlledFragmentHandler.Action.ABORT;
            }
            this.backpressuredResendRequestResponse = false;
            ++this.replaysInFlight;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        AbstractRejectEncoder rejectEncoder = resendRequestResponse.rejectEncoder();
        if (rejectEncoder != null) {
            return this.sendCustomReject(oldLastReceivedMsgSeqNum, rejectEncoder);
        }
        return this.sendReject(msgSeqNum, resendRequestResponse.refTagId(), RejectReason.OTHER, oldLastReceivedMsgSeqNum);
    }

    private ControlledFragmentHandler.Action sendCustomReject(int oldLastReceivedMsgSeqNum, AbstractRejectEncoder rejectEncoder) {
        long rejectPosition = this.trySend((Encoder)rejectEncoder);
        this.backpressuredResendRequestResponse = Pressure.isBackPressured(rejectPosition);
        if (this.backpressuredResendRequestResponse) {
            this.lastReceivedMsgSeqNum(oldLastReceivedMsgSeqNum);
            return ControlledFragmentHandler.Action.ABORT;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean saveValidResendRequest(int beginSeqNum, AsciiBuffer messageBuffer, int messageOffset, int messageLength, int correctedEndSeqNo, long correlationId, GatewayPublication publication) {
        return Pressure.isBackPressured(publication.saveValidResendRequest(this.id, this.connectionId, beginSeqNum, correctedEndSeqNo, this.sequenceIndex, correlationId, (DirectBuffer)messageBuffer, messageOffset, messageLength));
    }

    private long generateReplayCorrelationId() {
        long replayCorrelationId = this.nextReplayCorrelationId++;
        if (this.nextReplayCorrelationId == 0L) {
            ++this.nextReplayCorrelationId;
        }
        return replayCorrelationId;
    }

    private ControlledFragmentHandler.Action sendReject(int msgSeqNum, int endSeqNo, RejectReason valueIsIncorrect, int oldLastReceivedMsgSeqNum) {
        if (this.proxy.sendReject(this.newSentSeqNum(), msgSeqNum, endSeqNo, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS.length, valueIsIncorrect.representation(), this.sequenceIndex(), this.lastMsgSeqNumProcessed) < 0L) {
            this.backpressuredResendRequestResponse = true;
            this.lastReceivedMsgSeqNum(oldLastReceivedMsgSeqNum);
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.backpressuredResendRequestResponse = false;
        this.lastSentMsgSeqNum(this.newSentSeqNum());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onReject(int msgSeqNo, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        return this.onMessage(msgSeqNo, SessionConstants.REJECT_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    boolean onBeginString(char[] value, int length, boolean isLogon) {
        boolean isValid = CodecUtil.equals((char[])value, (String)this.beginString, (int)length);
        if (!isValid) {
            if (!isLogon) {
                int sentMsgSeqNum = this.newSentSeqNum();
                long position = this.proxy.sendIncorrectBeginStringLogout(sentMsgSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
                if (position < 0L) {
                    this.incorrectBeginString = true;
                    this.state(SessionState.DISCONNECTING);
                    return false;
                }
                this.lastSentMsgSeqNum(sentMsgSeqNum);
            }
            this.requestDisconnect(DisconnectReason.INCORRECT_BEGIN_STRING);
        }
        return isValid;
    }

    private void incNextHeartbeatTime() {
        this.nextRequiredHeartbeatTimeInNs = this.timeInNs() + this.sendingHeartbeatIntervalInNs;
    }

    private long trySendLogout() {
        long position;
        int sentSeqNum = this.newSentSeqNum();
        long l = position = this.logoutRejectReason == -1 ? this.proxy.sendLogout(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed) : this.proxy.sendLogout(sentSeqNum, this.sequenceIndex(), this.logoutRejectReason, this.lastMsgSeqNumProcessed);
        if (position >= 0L) {
            this.lastSentMsgSeqNum(sentSeqNum);
        }
        return position;
    }

    void heartbeatIntervalInS(int heartbeatIntervalInS) {
        this.configuredHeartbeatIntervalInS = heartbeatIntervalInS;
        this.heartbeatIntervalInNs = TimeUnit.SECONDS.toNanos(this.forcedHeartbeatIntervalInS != -1 ? (long)this.forcedHeartbeatIntervalInS : (long)heartbeatIntervalInS);
        long timeInNs = this.timeInNs();
        this.incNextReceivedInboundMessageTime(timeInNs);
        this.sendingHeartbeatIntervalInNs = (long)((double)this.heartbeatIntervalInNs * 0.8);
        this.nextRequiredHeartbeatTimeInNs = timeInNs + this.sendingHeartbeatIntervalInNs;
    }

    protected Session state(SessionState state) {
        this.state = state;
        return this;
    }

    void id(long id) {
        this.id = id;
    }

    protected long timeInNs() {
        return this.clock.nanoTime();
    }

    void lastReceivedMsgSeqNumOnly(int value) {
        this.lastReceivedMsgSeqNum = value;
        this.receivedMsgSeqNo.setOrdered((long)value);
    }

    int expectedReceivedSeqNum() {
        return this.lastReceivedMsgSeqNum + 1;
    }

    int newSentSeqNum() {
        return this.lastSentMsgSeqNum + 1;
    }

    private void incReceivedSeqNum() {
        ++this.lastReceivedMsgSeqNum;
        this.receivedMsgSeqNo.increment();
    }

    void lastSequenceResetTimeInNs(long lastSequenceResetTimeInNs) {
        this.lastSequenceResetTimeInNs = lastSequenceResetTimeInNs;
    }

    ControlledFragmentHandler.Action onInvalidMessage(int refSeqNum, int refTagId, char[] refMsgType, int refMsgTypeLength, int rejectReason, long position) {
        this.messageInfo.isValid(false);
        ControlledFragmentHandler.Action action = this.checkPosition(this.proxy.sendReject(this.newSentSeqNum(), refSeqNum, refTagId, refMsgType, refMsgTypeLength, rejectReason, this.sequenceIndex(), this.lastMsgSeqNumProcessed));
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.incReceivedSeqNum();
        }
        return action;
    }

    ControlledFragmentHandler.Action onHeartbeat(int msgSeqNum, char[] testReqID, int testReqIDLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        if (this.awaitingHeartbeat && CodecUtil.equals((char[])testReqID, (char[])TEST_REQ_ID_CHARS, (int)testReqIDLength)) {
            this.awaitingHeartbeat = false;
        }
        return this.onMessage(msgSeqNum, SessionConstants.HEARTBEAT_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onInvalidMessageType(int msgSeqNum, char[] msgType, int msgTypeLength, long position) {
        return this.onInvalidMessage(msgSeqNum, Integer.MIN_VALUE, msgType, msgTypeLength, RejectReason.INVALID_MSGTYPE.representation(), position);
    }

    void disable() {
        this.state(SessionState.DISABLED);
        this.close();
    }

    int poll(long timeInNs) {
        int sentSeqNum;
        boolean isActive;
        short state = this.state().value();
        ConnectionType connectionType = this.connectionType;
        int actions = connectionType == ConnectionType.INITIATOR ? this.initiatorPoll() : 0;
        switch (state) {
            case 8: {
                return actions + this.onDisconnecting();
            }
            case 5: {
                this.startLogout();
                return actions + 1;
            }
            case 6: {
                this.logoutAndDisconnect(DisconnectReason.APPLICATION_DISCONNECT);
                return actions + 1;
            }
            case 7: {
                if (timeInNs > this.awaitingLogoutTimeoutInNs && !Pressure.isBackPressured(this.requestDisconnect())) {
                    this.state(SessionState.DISCONNECTING);
                }
                return actions + 1;
            }
            case 9: 
            case 10: 
            case 11: {
                return actions;
            }
        }
        boolean bl = isActive = state == 3;
        if (isActive && timeInNs >= this.nextRequiredHeartbeatTimeInNs) {
            sentSeqNum = this.newSentSeqNum();
            long position = this.proxy.sendHeartbeat(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
            this.lastSentMsgSeqNum(sentSeqNum, position);
            ++actions;
        }
        if (timeInNs >= this.nextRequiredInboundMessageTimeInNs) {
            if (this.awaitingHeartbeat) {
                this.logoutAndDisconnect(DisconnectReason.FIX_HEARTBEAT_TIMEOUT);
                ++actions;
            } else if (isActive && this.proxy.sendTestRequest(sentSeqNum = this.newSentSeqNum(), TEST_REQ_ID, this.sequenceIndex(), this.lastMsgSeqNumProcessed) >= 0L) {
                this.lastSentMsgSeqNum(sentSeqNum);
                this.awaitingHeartbeat = true;
                this.incNextReceivedInboundMessageTime(timeInNs);
            }
            ++actions;
        }
        return actions;
    }

    private int initiatorPoll() {
        int actions = 0;
        if (this.state() == SessionState.CONNECTED && this.id() != -1L) {
            int sentSeqNum = this.initiatorResetSeqNum ? 1 : this.newSentSeqNum();
            long position = this.proxy.sendLogon(sentSeqNum, this.configuredHeartbeatIntervalInS, this.username(), this.password(), this.initiatorResetSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed(), this.cancelOnDisconnectOption, this.getCancelOnDisconnectTimeoutWindowInMs());
            if (position >= 0L) {
                this.lastSentMsgSeqNum(sentSeqNum);
                this.state(SessionState.SENT_LOGON);
            }
            ++actions;
        }
        return actions;
    }

    private int onDisconnecting() {
        if (this.incorrectBeginString) {
            int sentMsgSeqNum = this.newSentSeqNum();
            long position = this.proxy.sendIncorrectBeginStringLogout(sentMsgSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
            if (position < 0L) {
                return 1;
            }
            this.lastSentMsgSeqNum(sentMsgSeqNum);
            this.requestDisconnect(DisconnectReason.INCORRECT_BEGIN_STRING);
        } else {
            this.requestDisconnect();
        }
        return 1;
    }

    void libraryConnected(boolean libraryConnected) {
        this.proxy.libraryConnected(libraryConnected);
    }

    protected long sendingTime(long sendingTime, long origSendingTime) {
        return -1L == origSendingTime ? sendingTime : origSendingTime;
    }

    void sessionProcessHandler(FixSessionOwner fixSessionOwner) {
        this.fixSessionOwner = fixSessionOwner;
        this.cancelOnDisconnect.enqueueTask(fixSessionOwner::enqueueTask);
    }

    void logoutRejectReason(int logoutRejectReason) {
        this.logoutRejectReason = logoutRejectReason;
    }

    void address(String connectedHost, int connectedPort) {
        this.connectedHost = connectedHost;
        this.connectedPort = connectedPort;
    }

    void username(String username) {
        this.username = username;
    }

    void password(String password) {
        this.password = password;
    }

    void lastLogonTimeInNs(long logonTimeInNs) {
        this.lastLogonTimeInNs = logonTimeInNs;
    }

    void awaitingResend(boolean awaitingResend) {
        this.awaitingResend = awaitingResend;
    }

    void resendRequestChunkSize(int resendRequestChunkSize) {
        this.resendRequestChunkSize = resendRequestChunkSize;
    }

    void closedResendInterval(boolean closedResendInterval) {
        this.closedResendInterval = closedResendInterval;
    }

    void sendRedundantResendRequests(boolean sendRedundantResendRequests) {
        this.sendRedundantResendRequests = sendRedundantResendRequests;
    }

    void updateLastMessageProcessed() {
        if (this.enableLastMsgSeqNumProcessed) {
            this.lastMsgSeqNumProcessed = this.lastReceivedMsgSeqNum;
        }
    }

    void initialLastReceivedMsgSeqNum(int lastReceivedMsgSeqNum) {
        this.lastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
        this.updateLastMessageProcessed();
    }

    int lastMsgSeqNumProcessed() {
        return this.lastMsgSeqNumProcessed;
    }

    void lastResentMsgSeqNo(int lastResentMsgSeqNo) {
        this.lastResentMsgSeqNo = lastResentMsgSeqNo;
    }

    int lastResentMsgSeqNo() {
        return this.lastResentMsgSeqNo;
    }

    void lastResendChunkMsgSeqNum(int lastResendChunkMsgSeqNum) {
        this.lastResendChunkMsgSeqNum = lastResendChunkMsgSeqNum;
    }

    int lastResendChunkMsgSeqNum() {
        return this.lastResendChunkMsgSeqNum;
    }

    void endOfResendRequestRange(int endOfResendRequestRange) {
        this.endOfResendRequestRange = endOfResendRequestRange;
    }

    int endOfResendRequestRange() {
        return this.endOfResendRequestRange;
    }

    void awaitingHeartbeat(boolean awaitingHeartbeat) {
        this.awaitingHeartbeat = awaitingHeartbeat;
    }

    void cancelOnDisconnectTimeoutWindowInNs(long cancelOnDisconnectTimeoutWindowInNs) {
        this.cancelOnDisconnectTimeoutWindowInNs = Math.min(60000000000L, cancelOnDisconnectTimeoutWindowInNs);
        this.cancelOnDisconnect.cancelOnDisconnectTimeoutWindowInNs(cancelOnDisconnectTimeoutWindowInNs);
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
        this.proxy.fixDictionary(fixDictionary);
        this.beginString = fixDictionary.beginString();
    }

    void connectionId(long connectionId) {
        this.connectionId = connectionId;
        this.proxy.connectionId(connectionId);
    }

    void enableLastMsgSeqNumProcessed(boolean enableLastMsgSeqNumProcessed) {
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
    }

    void awaitingLogonReply(boolean awaitingLogonReply) {
        this.awaitingLogonReply = awaitingLogonReply;
    }

    OnMessageInfo messageInfo() {
        return this.messageInfo;
    }

    void refreshSequenceNumberCounters(FixCounters counters) {
        this.closeCounters();
        this.receivedMsgSeqNo = counters.receivedMsgSeqNo(this.connectionId, this.id);
        this.sentMsgSeqNo = counters.sentMsgSeqNo(this.connectionId, this.id);
    }

    void close() {
        this.closeCounters();
    }

    private void closeCounters() {
        this.sentMsgSeqNo.close();
        this.receivedMsgSeqNo.close();
    }

    boolean areCountersClosed() {
        return this.sentMsgSeqNo.isClosed() || this.receivedMsgSeqNo.isClosed();
    }

    void isSlowConsumer(boolean hasBecomeSlow) {
        this.isSlowConsumer = hasBecomeSlow;
    }

    void initiatorResetSeqNum(boolean initiatorResetSeqNum) {
        this.initiatorResetSeqNum = initiatorResetSeqNum;
    }

    void onReplayComplete(long correlationId) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.replayComplete.clear().with(this.replaysInFlight).with(this.connectionId).with(correlationId));
        }
        if (this.replaysInFlight > 0) {
            --this.replaysInFlight;
        }
        this.resendRequestController.onResendComplete(this, this.replaysInFlight);
    }

    void disconnectOnFirstMessageNotLogon(boolean disconnectOnFirstMessageNotLogon) {
        this.disconnectOnFirstMessageNotLogon = disconnectOnFirstMessageNotLogon;
    }
}

