/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.EndOfDayDecoder;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.InboundFixPConnectDecoder;
import uk.co.real_logic.artio.messages.LibraryExtendPositionDecoder;
import uk.co.real_logic.artio.messages.ManageFixPConnectionDecoder;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataReplyDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ReplayCompleteDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesReplyDecoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberDecoder;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.SlowStatusNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleConfigurationReplyDecoder;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataReplyDecoder;
import uk.co.real_logic.artio.protocol.LibraryEndPointHandler;

public final class LibraryProtocolSubscription
implements ControlledFragmentHandler {
    private static final int READ_META_DATA_META_DATA_PREFIX = 13 + ReadMetaDataReplyDecoder.metaDataHeaderLength();
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ErrorDecoder error = new ErrorDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final ReleaseSessionReplyDecoder releaseSessionReply = new ReleaseSessionReplyDecoder();
    private final RequestSessionReplyDecoder requestSessionReply = new RequestSessionReplyDecoder();
    private final WriteMetaDataReplyDecoder writeMetaDataReply = new WriteMetaDataReplyDecoder();
    private final ReadMetaDataReplyDecoder readMetaDataReply = new ReadMetaDataReplyDecoder();
    private final ControlNotificationDecoder controlNotification = new ControlNotificationDecoder();
    private final SlowStatusNotificationDecoder slowStatusNotification = new SlowStatusNotificationDecoder();
    private final ResetLibrarySequenceNumberDecoder resetLibrarySequenceNumber = new ResetLibrarySequenceNumberDecoder();
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final FollowerSessionReplyDecoder followerSessionReply = new FollowerSessionReplyDecoder();
    private final EndOfDayDecoder endOfDay = new EndOfDayDecoder();
    private final ReplayMessagesReplyDecoder replayMessagesReply = new ReplayMessagesReplyDecoder();
    private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
    private final LibraryExtendPositionDecoder libraryExtendPosition = new LibraryExtendPositionDecoder();
    private final ReplayCompleteDecoder replayComplete = new ReplayCompleteDecoder();
    private final InboundFixPConnectDecoder inboundFixPConnect = new InboundFixPConnectDecoder();
    private final ManageFixPConnectionDecoder manageFixPConnection = new ManageFixPConnectionDecoder();
    private final ThrottleNotificationDecoder throttleNotification = new ThrottleNotificationDecoder();
    private final ThrottleConfigurationReplyDecoder throttleConfigurationReply = new ThrottleConfigurationReplyDecoder();
    private final LibraryEndPointHandler handler;

    public LibraryProtocolSubscription(LibraryEndPointHandler handler) {
        this.handler = handler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 8: {
                return this.onManageSession(buffer, offset, blockLength, version);
            }
            case 13: {
                return this.onError(buffer, offset, blockLength, version);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version);
            }
            case 30: {
                return this.onReleaseSessionReply(buffer, offset, blockLength, version);
            }
            case 32: {
                return this.onRequestSessionReply(buffer, offset, blockLength, version);
            }
            case 39: {
                return this.onControlNotification(buffer, offset, blockLength, version);
            }
            case 43: {
                return this.onSlowStatusNotification(buffer, offset, blockLength, version);
            }
            case 44: {
                return this.onResetLibrarySequenceNumber(buffer, offset, blockLength, version);
            }
            case 48: {
                return this.onFollowerSessionReply(buffer, offset, blockLength, version);
            }
            case 50: {
                return this.onWriteMetaDataReply(buffer, offset, blockLength, version);
            }
            case 52: {
                return this.onReadMetaDataReply(buffer, offset, blockLength, version);
            }
            case 49: {
                return this.onEndOfDay(buffer, offset, blockLength, version);
            }
            case 54: {
                return this.onReplayMessagesReply(buffer, offset, blockLength, version);
            }
            case 57: {
                return this.onILinkConnect(buffer, offset, blockLength, version);
            }
            case 60: {
                return this.onLibraryExtendPosition(buffer, offset, blockLength, version);
            }
            case 45: {
                return this.onReplayComplete(buffer, offset, blockLength, version);
            }
            case 67: {
                return this.onInboundFixPConnect(buffer, offset, blockLength, version);
            }
            case 68: {
                return this.onManageFixPConnection(buffer, offset, blockLength, version);
            }
            case 70: {
                return this.onThrottleNotification(buffer, offset, blockLength, version, header.position());
            }
            case 73: {
                return this.onThrottleConfigurationReply(buffer, offset, blockLength, version, header.position());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onThrottleConfigurationReply(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        ThrottleConfigurationReplyDecoder throttleConfigurationReply = this.throttleConfigurationReply;
        throttleConfigurationReply.wrap(buffer, offset, blockLength, version);
        int libraryId = throttleConfigurationReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 73);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onThrottleConfigurationReply(libraryId, throttleConfigurationReply.replyToId(), throttleConfigurationReply.status());
    }

    private ControlledFragmentHandler.Action onThrottleNotification(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        ThrottleNotificationDecoder throttleNotification = this.throttleNotification;
        throttleNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = throttleNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 70);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        int businessRejectRefIDOffset = throttleNotification.limit() + ThrottleNotificationDecoder.businessRejectRefIDHeaderLength();
        return this.handler.onThrottleNotification(libraryId, throttleNotification.connection(), throttleNotification.refMsgType(), throttleNotification.refSeqNum(), buffer, businessRejectRefIDOffset, throttleNotification.businessRejectRefIDLength(), position);
    }

    private ControlledFragmentHandler.Action onLibraryExtendPosition(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.libraryExtendPosition.wrap(buffer, offset, blockLength, version);
        return this.handler.onLibraryExtendPosition(this.libraryExtendPosition.libraryId(), this.libraryExtendPosition.correlationId(), this.libraryExtendPosition.sessionId(), this.libraryExtendPosition.stopPosition(), this.libraryExtendPosition.initialTermId(), this.libraryExtendPosition.termBufferLength(), this.libraryExtendPosition.mtuLength());
    }

    private ControlledFragmentHandler.Action onControlNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        ControlNotificationDecoder controlNotification = this.controlNotification;
        controlNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = controlNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 39);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onControlNotification(libraryId, controlNotification.initialAcceptedSessionOwner(), controlNotification);
    }

    private ControlledFragmentHandler.Action onSlowStatusNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        SlowStatusNotificationDecoder slowStatusNotification = this.slowStatusNotification;
        slowStatusNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = slowStatusNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 43);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onSlowStatusNotification(libraryId, slowStatusNotification.connectionId(), slowStatusNotification.status() == SlowStatus.SLOW);
    }

    private ControlledFragmentHandler.Action onResetLibrarySequenceNumber(DirectBuffer buffer, int offset, int blockLength, int version) {
        ResetLibrarySequenceNumberDecoder resetLibrarySequenceNumber = this.resetLibrarySequenceNumber;
        resetLibrarySequenceNumber.wrap(buffer, offset, blockLength, version);
        int libraryId = resetLibrarySequenceNumber.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 44);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onResetLibrarySequenceNumber(libraryId, resetLibrarySequenceNumber.session());
    }

    private ControlledFragmentHandler.Action onFollowerSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        FollowerSessionReplyDecoder followerSessionReply = this.followerSessionReply;
        followerSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = followerSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 48);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onFollowerSessionReply(libraryId, followerSessionReply.replyToId(), followerSessionReply.session());
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version) {
        ApplicationHeartbeatDecoder applicationHeartbeat = this.applicationHeartbeat;
        applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        int libraryId = applicationHeartbeat.libraryId();
        long timestampInNs = applicationHeartbeat.timestampInNs();
        return this.handler.onApplicationHeartbeat(libraryId, 16, timestampInNs);
    }

    private ControlledFragmentHandler.Action onReleaseSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        ReleaseSessionReplyDecoder releaseSessionReply = this.releaseSessionReply;
        releaseSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = releaseSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 30);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReleaseSessionReply(libraryId, releaseSessionReply.replyToId(), releaseSessionReply.status());
    }

    private ControlledFragmentHandler.Action onRequestSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        RequestSessionReplyDecoder requestSessionReply = this.requestSessionReply;
        requestSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = requestSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 32);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onRequestSessionReply(libraryId, requestSessionReply.replyToId(), requestSessionReply.status());
    }

    private ControlledFragmentHandler.Action onWriteMetaDataReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        WriteMetaDataReplyDecoder writeMetaDataReply = this.writeMetaDataReply;
        writeMetaDataReply.wrap(buffer, offset, blockLength, version);
        int libraryId = writeMetaDataReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 50);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onWriteMetaDataReply(libraryId, writeMetaDataReply.replyToId(), writeMetaDataReply.status());
    }

    private ControlledFragmentHandler.Action onReadMetaDataReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        ReadMetaDataReplyDecoder readMetaDataReply = this.readMetaDataReply;
        readMetaDataReply.wrap(buffer, offset, blockLength, version);
        int libraryId = readMetaDataReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 52);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReadMetaDataReply(libraryId, readMetaDataReply.replyToId(), readMetaDataReply.status(), buffer, offset + READ_META_DATA_META_DATA_PREFIX, readMetaDataReply.metaDataLength());
    }

    private ControlledFragmentHandler.Action onILinkConnect(DirectBuffer buffer, int offset, int blockLength, int version) {
        ILinkConnectDecoder iLinkConnect = this.iLinkConnect;
        iLinkConnect.wrap(buffer, offset, blockLength, version);
        int libraryId = iLinkConnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 57);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onILinkConnect(libraryId, iLinkConnect.correlationId(), iLinkConnect.connection(), iLinkConnect.uuid(), iLinkConnect.lastReceivedSequenceNumber(), iLinkConnect.lastSentSequenceNumber(), iLinkConnect.newlyAllocated() == Bool.TRUE, iLinkConnect.lastUuid());
    }

    private ControlledFragmentHandler.Action onReplayMessagesReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        ReplayMessagesReplyDecoder replayMessagesReply = this.replayMessagesReply;
        replayMessagesReply.wrap(buffer, offset, blockLength, version);
        int libraryId = replayMessagesReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 54);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReplayMessagesReply(libraryId, replayMessagesReply.replyToId(), replayMessagesReply.status());
    }

    private ControlledFragmentHandler.Action onError(DirectBuffer buffer, int offset, int blockLength, int version) {
        ErrorDecoder error = this.error;
        error.wrap(buffer, offset, blockLength, version);
        int libraryId = error.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 13);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onError(libraryId, error.errorType(), error.replyToId(), error.message());
    }

    private ControlledFragmentHandler.Action onManageSession(DirectBuffer buffer, int offset, int blockLength, int version) {
        ManageSessionDecoder manageSession = this.manageSession;
        manageSession.wrap(buffer, offset, blockLength, version);
        int libraryId = manageSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 8);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onManageSession(libraryId, manageSession.connection(), manageSession.session(), manageSession.lastSentSequenceNumber(), manageSession.lastReceivedSequenceNumber(), manageSession.sessionStatus(), manageSession.slowStatus(), manageSession.connectionType(), manageSession.sessionState(), manageSession.heartbeatIntervalInS(), manageSession.closedResendInterval() == Bool.TRUE, manageSession.resendRequestChunkSize(), manageSession.sendRedundantResendRequests() == Bool.TRUE, manageSession.enableLastMsgSeqNumProcessed() == Bool.TRUE, manageSession.replyToId(), manageSession.sequenceIndex(), manageSession.awaitingResend() == AwaitingResend.YES, manageSession.lastResentMsgSeqNo(), manageSession.lastResendChunkMsgSeqNum(), manageSession.endOfResendRequestRange(), manageSession.awaitingHeartbeat() == Bool.TRUE, manageSession.logonReceivedSequenceNumber(), manageSession.logonSequenceIndex(), manageSession.lastLogonTime(), manageSession.lastSequenceResetTime(), manageSession.localCompId(), manageSession.localSubId(), manageSession.localLocationId(), manageSession.remoteCompId(), manageSession.remoteSubId(), manageSession.remoteLocationId(), manageSession.address(), manageSession.username(), manageSession.password(), FixDictionary.find((String)manageSession.fixDictionary()), manageSession.metaDataStatus(), buffer, manageSession.limit() + ManageSessionDecoder.metaDataHeaderLength(), manageSession.metaDataLength(), manageSession.cancelOnDisconnectOption(), manageSession.cancelOnDisconnectTimeoutInNs());
    }

    private ControlledFragmentHandler.Action onEndOfDay(DirectBuffer buffer, int offset, int blockLength, int version) {
        EndOfDayDecoder endOfDay = this.endOfDay;
        endOfDay.wrap(buffer, offset, blockLength, version);
        int libraryId = endOfDay.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 49);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onEngineClose(libraryId);
    }

    private ControlledFragmentHandler.Action onReplayComplete(DirectBuffer buffer, int offset, int blockLength, int version) {
        ReplayCompleteDecoder replayComplete = this.replayComplete;
        replayComplete.wrap(buffer, offset, blockLength, version);
        long connection = replayComplete.connection();
        int libraryId = replayComplete.libraryId();
        long correlationId = replayComplete.correlationId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, 45);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onReplayComplete(libraryId, connection, correlationId);
    }

    private ControlledFragmentHandler.Action onInboundFixPConnect(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.inboundFixPConnect.wrap(buffer, offset, blockLength, version);
        int limit = this.inboundFixPConnect.limit();
        return this.handler.onInboundFixPConnect(this.inboundFixPConnect.connection(), this.inboundFixPConnect.sessionId(), this.inboundFixPConnect.protocolType(), buffer, limit, this.inboundFixPConnect.messageLength());
    }

    private ControlledFragmentHandler.Action onManageFixPConnection(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.manageFixPConnection.wrap(buffer, offset, blockLength, version);
        int limit = this.manageFixPConnection.limit();
        return this.handler.onManageFixPConnection(this.manageFixPConnection.libraryId(), this.manageFixPConnection.correlationId(), this.manageFixPConnection.connection(), this.manageFixPConnection.sessionId(), this.manageFixPConnection.protocolType(), this.manageFixPConnection.lastReceivedSequenceNumber(), this.manageFixPConnection.lastSentSequenceNumber(), this.manageFixPConnection.lastConnectPayload(), this.manageFixPConnection.offline() == Bool.TRUE, buffer, limit, this.manageFixPConnection.messageLength());
    }
}

