/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.agrona.collections.IntArrayList;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.messages.SequenceNumberType;

public final class SessionConfiguration {
    public static final boolean DEFAULT_SEQUENCE_NUMBERS_PERSISTENT = false;
    public static final int AUTOMATIC_INITIAL_SEQUENCE_NUMBER = -1;
    public static final boolean DEFAULT_RESET_SEQ_NUM = false;
    public static final boolean DEFAULT_CLOSED_RESEND_INTERVAL = false;
    public static final int NO_RESEND_REQUEST_CHUNK_SIZE = 0;
    public static final boolean DEFAULT_SEND_REDUNDANT_RESEND_REQUESTS = false;
    public static final boolean DEFAULT_ENABLE_LAST_MSG_SEQ_NUM_PROCESSED = false;
    private final List<String> hosts;
    private final IntArrayList ports;
    private final String username;
    private final String password;
    private final String senderCompId;
    private final String senderSubId;
    private final String senderLocationId;
    private final String targetCompId;
    private final String targetSubId;
    private final String targetLocationId;
    private final boolean sequenceNumbersPersistent;
    private final int initialReceivedSequenceNumber;
    private final int initialSentSequenceNumber;
    private final long timeoutInMs;
    private final boolean resetSeqNum;
    private final boolean closedResendInterval;
    private final int resendRequestChunkSize;
    private final boolean sendRedundantResendRequests;
    private final boolean enableLastMsgSeqNumProcessed;
    private final boolean disconnectOnFirstMessageNotLogon;
    private final Class<? extends FixDictionary> fixDictionary;

    public static Builder builder() {
        return new Builder();
    }

    private SessionConfiguration(List<String> hosts, IntArrayList ports, String username, String password, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, boolean sequenceNumbersPersistent, int initialReceivedSequenceNumber, int initialSentSequenceNumber, long timeoutInMs, boolean resetSeqNum, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, boolean disconnectOnFirstMessageNotLogon, Class<? extends FixDictionary> fixDictionary) {
        Objects.requireNonNull(hosts, "hosts");
        Objects.requireNonNull(ports, "ports");
        Objects.requireNonNull(senderCompId, "senderCompId");
        Objects.requireNonNull(senderSubId, "senderSubId");
        Objects.requireNonNull(senderLocationId, "senderLocationId");
        Objects.requireNonNull(targetCompId, "targetCompId");
        Objects.requireNonNull(targetSubId, "targetSubId");
        Objects.requireNonNull(targetLocationId, "targetLocationId");
        Objects.requireNonNull(fixDictionary, "fixDictionary");
        this.requireNonEmpty(hosts, "hosts");
        this.requireNonEmpty((List<?>)ports, "ports");
        this.senderCompId = senderCompId;
        this.senderSubId = senderSubId;
        this.senderLocationId = senderLocationId;
        this.targetCompId = targetCompId;
        this.targetSubId = targetSubId;
        this.targetLocationId = targetLocationId;
        this.timeoutInMs = timeoutInMs;
        this.hosts = hosts;
        this.ports = ports;
        this.username = username;
        this.password = password;
        this.sequenceNumbersPersistent = sequenceNumbersPersistent;
        this.initialReceivedSequenceNumber = initialReceivedSequenceNumber;
        this.initialSentSequenceNumber = initialSentSequenceNumber;
        this.resetSeqNum = resetSeqNum;
        this.closedResendInterval = closedResendInterval;
        this.resendRequestChunkSize = resendRequestChunkSize;
        this.sendRedundantResendRequests = sendRedundantResendRequests;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        this.disconnectOnFirstMessageNotLogon = disconnectOnFirstMessageNotLogon;
        this.fixDictionary = fixDictionary;
    }

    private void requireNonEmpty(List<?> values, String name) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    public List<String> hosts() {
        return this.hosts;
    }

    public IntArrayList ports() {
        return this.ports;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String senderCompId() {
        return this.senderCompId;
    }

    public String senderSubId() {
        return this.senderSubId;
    }

    public String senderLocationId() {
        return this.senderLocationId;
    }

    public String targetCompId() {
        return this.targetCompId;
    }

    public String targetSubId() {
        return this.targetSubId;
    }

    public String targetLocationId() {
        return this.targetLocationId;
    }

    public boolean sequenceNumbersPersistent() {
        return this.sequenceNumbersPersistent;
    }

    public SequenceNumberType sequenceNumberType() {
        return this.sequenceNumbersPersistent ? SequenceNumberType.PERSISTENT : SequenceNumberType.TRANSIENT;
    }

    public int initialReceivedSequenceNumber() {
        return this.initialReceivedSequenceNumber;
    }

    public int initialSentSequenceNumber() {
        return this.initialSentSequenceNumber;
    }

    public long timeoutInMs() {
        return this.timeoutInMs;
    }

    public boolean resetSeqNum() {
        return this.resetSeqNum;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public boolean enableLastMsgSeqNumProcessed() {
        return this.enableLastMsgSeqNumProcessed;
    }

    public Class<? extends FixDictionary> fixDictionary() {
        return this.fixDictionary;
    }

    public boolean disconnectOnFirstMessageNotLogon() {
        return this.disconnectOnFirstMessageNotLogon;
    }

    public String toString() {
        return "SessionConfiguration{hosts=" + this.hosts + ", ports=" + this.ports + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", senderCompId='" + this.senderCompId + '\'' + ", senderSubId='" + this.senderSubId + '\'' + ", senderLocationId='" + this.senderLocationId + '\'' + ", targetCompId='" + this.targetCompId + '\'' + ", targetSubId='" + this.targetSubId + '\'' + ", targetLocationId='" + this.targetLocationId + '\'' + ", sequenceNumbersPersistent=" + this.sequenceNumbersPersistent + ", initialReceivedSequenceNumber=" + this.initialReceivedSequenceNumber + ", initialSentSequenceNumber=" + this.initialSentSequenceNumber + ", timeoutInMs=" + this.timeoutInMs + ", resetSeqNum=" + this.resetSeqNum + ", closedResendInterval=" + this.closedResendInterval + ", resendRequestChunkSize=" + this.resendRequestChunkSize + ", enableLastMsgSeqNumProcessed=" + this.enableLastMsgSeqNumProcessed + ", fixDictionary=" + this.fixDictionary + '}';
    }

    public static final class Builder {
        private String username;
        private String password;
        private final List<String> hosts = new ArrayList<String>();
        private final IntArrayList ports = new IntArrayList();
        private String senderCompId;
        private String senderSubId = "";
        private String senderLocationId = "";
        private String targetCompId;
        private String targetSubId = "";
        private String targetLocationId = "";
        private boolean sequenceNumbersPersistent = false;
        private int initialReceivedSequenceNumber = -1;
        private int initialSentSequenceNumber = -1;
        private long timeoutInMs = 10000L;
        private boolean resetSeqNum = false;
        private boolean closedResendInterval = false;
        private int resendRequestChunkSize = 0;
        private boolean sendRedundantResendRequests = false;
        private boolean enableLastMsgSeqNumProcessed;
        private boolean disconnectOnFirstMessageNotLogon = true;
        private Class<? extends FixDictionary> fixDictionary;

        private Builder() {
        }

        public Builder credentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder address(String host, int port) {
            this.hosts.add(host);
            this.ports.addInt(port);
            return this;
        }

        public Builder senderCompId(String senderCompId) {
            this.senderCompId = senderCompId;
            return this;
        }

        public Builder senderSubId(String senderSubId) {
            this.senderSubId = senderSubId;
            return this;
        }

        public Builder senderLocationId(String senderLocationId) {
            this.senderLocationId = senderLocationId;
            return this;
        }

        public Builder targetCompId(String targetCompId) {
            this.targetCompId = targetCompId;
            return this;
        }

        public Builder targetSubId(String targetSubId) {
            this.targetSubId = targetSubId;
            return this;
        }

        public Builder targetLocationId(String targetLocationId) {
            this.targetLocationId = targetLocationId;
            return this;
        }

        public Builder sequenceNumbersPersistent(boolean sequenceNumbersPersistent) {
            this.sequenceNumbersPersistent = sequenceNumbersPersistent;
            return this;
        }

        public Builder initialReceivedSequenceNumber(int initialReceivedSequenceNumber) {
            this.initialReceivedSequenceNumber = initialReceivedSequenceNumber;
            return this;
        }

        public Builder initialSentSequenceNumber(int initialSentSequenceNumber) {
            this.initialSentSequenceNumber = initialSentSequenceNumber;
            return this;
        }

        public Builder timeoutInMs(long timeoutInMs) {
            CommonConfiguration.validateTimeout(timeoutInMs);
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        public Builder resetSeqNum(boolean resetSeqNum) {
            this.resetSeqNum = resetSeqNum;
            return this;
        }

        public Builder closedResendInterval(boolean closedResendInterval) {
            this.closedResendInterval = closedResendInterval;
            return this;
        }

        public Builder resendRequestChunkSize(int resendRequestChunkSize) {
            this.resendRequestChunkSize = resendRequestChunkSize;
            return this;
        }

        public Builder sendRedundantResendRequests(boolean sendRedundantResendRequests) {
            this.sendRedundantResendRequests = sendRedundantResendRequests;
            return this;
        }

        public Builder enableLastMsgSeqNumProcessed(boolean enableLastMsgSeqNumProcessed) {
            this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
            return this;
        }

        public Builder disconnectOnFirstMessageNotLogon(boolean disconnectOnFirstMessageNotLogon) {
            this.disconnectOnFirstMessageNotLogon = disconnectOnFirstMessageNotLogon;
            return this;
        }

        public Builder fixDictionary(Class<? extends FixDictionary> fixDictionary) {
            this.fixDictionary = fixDictionary;
            return this;
        }

        public SessionConfiguration build() {
            if (this.fixDictionary == null) {
                this.fixDictionary = FixDictionary.findDefault();
            }
            return new SessionConfiguration(this.hosts, this.ports, this.username, this.password, this.senderCompId, this.senderSubId, this.senderLocationId, this.targetCompId, this.targetSubId, this.targetLocationId, this.sequenceNumbersPersistent, this.initialReceivedSequenceNumber, this.initialSentSequenceNumber, this.timeoutInMs, this.resetSeqNum, this.closedResendInterval, this.resendRequestChunkSize, this.sendRedundantResendRequests, this.enableLastMsgSeqNumProcessed, this.disconnectOnFirstMessageNotLogon, this.fixDictionary);
        }
    }
}

