/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import java.util.concurrent.ThreadFactory;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CompositeAgent;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryScheduler;

public class DefaultLibraryScheduler
implements LibraryScheduler {
    private AgentRunner monitoringRunner;

    @Override
    public void launch(LibraryConfiguration configuration, ErrorHandler errorHandler, Agent monitoringAgent, Agent conductorAgent) {
        if (this.monitoringRunner != null) {
            EngineScheduler.fail();
        }
        if (monitoringAgent != null) {
            this.monitoringRunner = new AgentRunner(configuration.monitoringThreadIdleStrategy(), errorHandler, null, (Agent)new CompositeAgent(new Agent[]{monitoringAgent, conductorAgent}){

                public void onStart() {
                    FixLibrary.setClientConductorThread();
                    super.onStart();
                }
            });
            AgentRunner.startOnThread((AgentRunner)this.monitoringRunner, (ThreadFactory)configuration.threadFactory());
        }
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
        aeronContext.useConductorAgentInvoker(true);
    }

    @Override
    public void close(int libraryId) {
        EngineScheduler.awaitRunnerStart(this.monitoringRunner);
        CloseHelper.close((AutoCloseable)this.monitoringRunner);
    }
}

