/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectCache;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.ExistingBufferFactory;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.PrunePosition;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayOperation;
import uk.co.real_logic.artio.engine.logger.ReplayQueryListener;
import uk.co.real_logic.artio.engine.logger.StartPositionQuery;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;
import uk.co.real_logic.artio.util.CharFormatter;

public class ReplayQuery
implements AutoCloseable {
    private final MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
    private final ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
    private final CharFormatter startQueryFormatter = new CharFormatter("ReplayQuery:query,beginSequenceNumber=%s,beginSequenceIndex=%s,endSequenceNumber=%s,endSequenceIndex=%s");
    private final CharFormatter onRowFormatter = new CharFormatter("ReplayQuery:onRow,beginPosition=%s,recordingId=%s,sequenceNumber=%s,sequenceIndex=%s");
    private final LongFunction<SessionQuery> newSessionQuery = this::newSessionQuery;
    private final Long2ObjectCache<SessionQuery> fixSessionToIndex;
    private final String logFileDir;
    private final File logFileDirFile;
    private final ExistingBufferFactory indexBufferFactory;
    private final int requiredStreamId;
    private final IdleStrategy idleStrategy;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final ReplayQueryListener replayQueryListener;
    private final int archiveReplayStream;
    private final int segmentSize;
    private final int segmentSizeBitShift;
    private final int segmentCount;
    private final long indexFileSize;
    private Subscription replaySubscription;

    public ReplayQuery(String logFileDir, int cacheNumSets, int cacheSetSize, ExistingBufferFactory indexBufferFactory, int requiredStreamId, IdleStrategy idleStrategy, AeronArchive aeronArchive, ErrorHandler errorHandler, ReplayQueryListener replayQueryListener, int archiveReplayStream, int indexFileCapacity, int indexSegmentCapacity) {
        this.logFileDir = logFileDir;
        this.indexBufferFactory = indexBufferFactory;
        this.requiredStreamId = requiredStreamId;
        this.idleStrategy = idleStrategy;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.replayQueryListener = replayQueryListener;
        this.archiveReplayStream = archiveReplayStream;
        this.indexFileSize = ReplayIndexDescriptor.capacityToBytes(indexFileCapacity);
        this.segmentSize = ReplayIndexDescriptor.capacityToBytesInt(indexSegmentCapacity);
        this.segmentSizeBitShift = Long.numberOfTrailingZeros(this.segmentSize);
        this.segmentCount = ReplayIndexDescriptor.segmentCount(indexFileCapacity, indexSegmentCapacity);
        this.logFileDirFile = new File(logFileDir);
        this.fixSessionToIndex = new Long2ObjectCache(cacheNumSets, cacheSetSize, SessionQuery::close);
    }

    public ReplayOperation query(long sessionId, int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag, MessageTracker tracker) {
        SessionQuery sessionQuery = this.lookupSessionQuery(sessionId);
        if (sessionQuery == null) {
            return null;
        }
        return sessionQuery.query(beginSequenceNumber, beginSequenceIndex, endSequenceNumber, endSequenceIndex, logTag, tracker);
    }

    public void queryStartPositions(Long2LongHashMap newStartPositions) {
        LongHashSet allSessionIds = ReplayIndexDescriptor.listReplayIndexSessionIds(this.logFileDirFile, this.requiredStreamId);
        for (SessionQuery query : this.fixSessionToIndex.values()) {
            ReplayQuery.aggregateLowerPosition(query.queryStartPositions(), newStartPositions);
            allSessionIds.remove(query.fixSessionId);
        }
        LongHashSet.LongIterator sessionIdIt = allSessionIds.iterator();
        while (sessionIdIt.hasNext()) {
            long sessionId = sessionIdIt.nextValue();
            SessionQuery query = this.lookupSessionQuery(sessionId);
            ReplayQuery.aggregateLowerPosition(query.queryStartPositions(), newStartPositions);
        }
    }

    private SessionQuery lookupSessionQuery(long sessionId) {
        return (SessionQuery)this.fixSessionToIndex.computeIfAbsent(sessionId, this.newSessionQuery);
    }

    @Override
    public void close() {
        this.fixSessionToIndex.clear();
        CloseHelper.close((AutoCloseable)this.replaySubscription);
    }

    public void onReset(long fixSessionId) {
        this.fixSessionToIndex.remove(fixSessionId);
    }

    private SessionQuery newSessionQuery(long fixSessionId) {
        try {
            return new SessionQuery(fixSessionId);
        }
        catch (IllegalStateException e) {
            this.errorHandler.onError((Throwable)new IllegalStateException("Unable to create session query for: " + fixSessionId + " probably due to this session's sequence numbers being reset or files removed ", e));
            return null;
        }
    }

    static long trueBeginPosition(long beginPosition) {
        return beginPosition - 32L;
    }

    static void aggregateLowerPosition(Long2ObjectHashMap<PrunePosition> recordingIdToStartPosition, Long2LongHashMap newStartPositions) {
        Long2ObjectHashMap.EntryIterator it = recordingIdToStartPosition.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            long recordingId = it.getLongKey();
            long position = ((PrunePosition)it.getValue()).position();
            long oldPosition = newStartPositions.get(recordingId);
            if (oldPosition != -1L && position >= oldPosition) continue;
            newStartPositions.put(recordingId, position);
        }
    }

    private final class SessionQuery
    implements AutoCloseable {
        private final long fixSessionId;
        private final File headerFile;
        private final UnsafeBuffer headerBuffer;
        private final UnsafeBuffer[] segmentBuffers;
        private final int actingBlockLength;
        private final int actingVersion;

        SessionQuery(long fixSessionId) {
            this.segmentBuffers = new UnsafeBuffer[ReplayQuery.this.segmentCount];
            this.headerFile = ReplayIndexDescriptor.replayIndexHeaderFile(ReplayQuery.this.logFileDir, fixSessionId, ReplayQuery.this.requiredStreamId);
            this.headerBuffer = new UnsafeBuffer(ReplayQuery.this.indexBufferFactory.map(this.headerFile));
            this.fixSessionId = fixSessionId;
            ReplayQuery.this.messageFrameHeader.wrap((DirectBuffer)this.headerBuffer, 0);
            this.actingBlockLength = ReplayQuery.this.messageFrameHeader.blockLength();
            this.actingVersion = ReplayQuery.this.messageFrameHeader.version();
        }

        ReplayOperation query(int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag, MessageTracker messageTracker) {
            boolean log;
            boolean bl = log = DebugLogger.IS_REPLAY_ATTEMPT_ENABLED && logTag == LogTag.REPLAY;
            if (log) {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, ReplayQuery.this.startQueryFormatter, (long)beginSequenceNumber, (long)beginSequenceIndex, (long)endSequenceNumber, (long)endSequenceIndex);
            }
            UnsafeBuffer[] segmentBuffers = this.segmentBuffers;
            int segmentSize = ReplayQuery.this.segmentSize;
            int segmentSizeBitShift = ReplayQuery.this.segmentSizeBitShift;
            ReplayIndexRecordDecoder indexRecord = ReplayQuery.this.indexRecord;
            IdleStrategy idleStrategy = ReplayQuery.this.idleStrategy;
            UnsafeBuffer headerBuffer = this.headerBuffer;
            long indexFileSize = ReplayQuery.this.indexFileSize;
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            boolean upToMostRecentMessage = endSequenceNumber == 0;
            ArrayList<RecordingRange> ranges = new ArrayList<RecordingRange>();
            RecordingRange currentRange = null;
            long iteratorPosition = this.getIteratorPosition();
            long stopIteratingPosition = iteratorPosition + indexFileSize;
            int lastSequenceNumber = -1;
            while (iteratorPosition < stopIteratingPosition) {
                int offset;
                long beginChangePosition;
                long changePosition = ReplayIndexDescriptor.endChangeVolatile((AtomicBuffer)headerBuffer);
                ReplayQuery.this.replayQueryListener.onEndChangeRead();
                if (changePosition > iteratorPosition && iteratorPosition + indexFileSize < (beginChangePosition = ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer))) {
                    iteratorPosition = beginChangePosition - indexFileSize;
                    stopIteratingPosition = beginChangePosition;
                    ReplayQuery.this.replayQueryListener.onLapped();
                }
                if ((offset = ReplayIndexDescriptor.offsetInSegment(iteratorPosition, segmentSize)) == 0 && iteratorPosition >= changePosition) break;
                UnsafeBuffer segmentBuffer = this.segmentBuffer(iteratorPosition, segmentSizeBitShift, segmentBuffers, indexFileSize);
                indexRecord.wrap((DirectBuffer)segmentBuffer, offset, actingBlockLength, actingVersion);
                long beginPosition = indexRecord.position();
                int sequenceIndex = indexRecord.sequenceIndex();
                int sequenceNumber = indexRecord.sequenceNumber();
                long recordingId = indexRecord.recordingId();
                int readLength = indexRecord.length();
                UnsafeAccess.UNSAFE.loadFence();
                if (log) {
                    DebugLogger.log(LogTag.REPLAY_ATTEMPT, ReplayQuery.this.onRowFormatter, beginPosition, recordingId, (long)sequenceNumber, (long)sequenceIndex);
                }
                if (changePosition == ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer)) {
                    boolean withinQueryRange;
                    boolean afterEnd;
                    idleStrategy.reset();
                    boolean bl2 = afterEnd = !upToMostRecentMessage && (sequenceIndex > endSequenceIndex || sequenceIndex == endSequenceIndex && sequenceNumber > endSequenceNumber);
                    if (beginPosition == 0L || afterEnd) break;
                    boolean bl3 = withinQueryRange = sequenceIndex > beginSequenceIndex || sequenceIndex == beginSequenceIndex && sequenceNumber >= beginSequenceNumber;
                    if (withinQueryRange) {
                        currentRange = this.addRange(ranges, currentRange, lastSequenceNumber, beginPosition, sequenceNumber, recordingId, readLength);
                        lastSequenceNumber = sequenceNumber;
                        iteratorPosition += 32L;
                        continue;
                    }
                    iteratorPosition = this.skipToStart(beginSequenceNumber, iteratorPosition, sequenceNumber);
                    continue;
                }
                idleStrategy.idle();
            }
            if (currentRange != null) {
                ranges.add(currentRange);
            }
            return this.newReplayOperation(ranges, logTag, messageTracker);
        }

        private UnsafeBuffer segmentBuffer(long position, int segmentSizeBitShift, UnsafeBuffer[] segmentBuffers, long indexFileSize) {
            int segmentIndex = ReplayIndexDescriptor.segmentIndex(position, segmentSizeBitShift, indexFileSize);
            UnsafeBuffer segmentBuffer = segmentBuffers[segmentIndex];
            if (segmentBuffer == null) {
                File file = ReplayIndexDescriptor.replayIndexSegmentFile(ReplayQuery.this.logFileDir, this.fixSessionId, ReplayQuery.this.requiredStreamId, segmentIndex);
                segmentBuffers[segmentIndex] = segmentBuffer = new UnsafeBuffer(ReplayQuery.this.indexBufferFactory.map(file));
            }
            return segmentBuffer;
        }

        private long skipToStart(int beginSequenceNumber, long iteratorPosition, int sequenceNumber) {
            if (sequenceNumber < beginSequenceNumber) {
                return this.jumpPosition(beginSequenceNumber, sequenceNumber, iteratorPosition);
            }
            return iteratorPosition + 32L;
        }

        private long jumpPosition(int beginSequenceNumber, int sequenceNumber, long iteratorPosition) {
            int sequenceNumberJump = beginSequenceNumber - sequenceNumber;
            int jumpInBytes = sequenceNumberJump * 32;
            return iteratorPosition + (long)jumpInBytes;
        }

        private ReplayOperation newReplayOperation(List<RecordingRange> ranges, LogTag logTag, MessageTracker messageTracker) {
            if (ReplayQuery.this.replaySubscription == null) {
                ReplayQuery.this.replaySubscription = ReplayQuery.this.aeronArchive.context().aeron().addSubscription("aeron:ipc", ReplayQuery.this.archiveReplayStream);
            }
            return new ReplayOperation(ranges, ReplayQuery.this.aeronArchive, ReplayQuery.this.errorHandler, ReplayQuery.this.replaySubscription, ReplayQuery.this.archiveReplayStream, logTag, messageTracker);
        }

        private RecordingRange addRange(List<RecordingRange> ranges, RecordingRange currentRange, int lastSequenceNumber, long beginPosition, int sequenceNumber, long recordingId, int readLength) {
            RecordingRange range = currentRange;
            if (range == null) {
                range = new RecordingRange(recordingId, this.fixSessionId);
            } else if (range.recordingId != recordingId) {
                ranges.add(range);
                range = new RecordingRange(recordingId, this.fixSessionId);
            }
            range.add(ReplayQuery.trueBeginPosition(beginPosition), readLength + 32);
            if (lastSequenceNumber != sequenceNumber) {
                ++range.count;
            }
            return range;
        }

        private long getIteratorPosition() {
            return Math.max(ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)this.headerBuffer) - ReplayQuery.this.indexFileSize, 0L);
        }

        public Long2ObjectHashMap<PrunePosition> queryStartPositions() {
            StartPositionQuery startPositionQuery = new StartPositionQuery();
            UnsafeBuffer headerBuffer = this.headerBuffer;
            long indexFileSize = ReplayQuery.this.indexFileSize;
            ReplayIndexRecordDecoder indexRecord = ReplayQuery.this.indexRecord;
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            int segmentSizeBitShift = ReplayQuery.this.segmentSizeBitShift;
            UnsafeBuffer[] segmentBuffers = this.segmentBuffers;
            int segmentSize = ReplayQuery.this.segmentSize;
            IdleStrategy idleStrategy = ReplayQuery.this.idleStrategy;
            long iteratorPosition = this.getIteratorPosition();
            long stopIteratingPosition = iteratorPosition + indexFileSize;
            while (iteratorPosition != stopIteratingPosition) {
                int offset;
                long beginChangePosition;
                long changePosition = ReplayIndexDescriptor.endChangeVolatile((AtomicBuffer)headerBuffer);
                if (changePosition > iteratorPosition && iteratorPosition + indexFileSize < (beginChangePosition = ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer))) {
                    iteratorPosition = beginChangePosition - indexFileSize;
                    stopIteratingPosition = beginChangePosition;
                }
                if ((offset = ReplayIndexDescriptor.offsetInSegment(iteratorPosition, segmentSize)) == 0 && iteratorPosition >= changePosition) break;
                UnsafeBuffer segmentBuffer = this.segmentBuffer(iteratorPosition, segmentSizeBitShift, segmentBuffers, indexFileSize);
                indexRecord.wrap((DirectBuffer)segmentBuffer, offset, actingBlockLength, actingVersion);
                long beginPosition = indexRecord.position();
                int sequenceIndex = indexRecord.sequenceIndex();
                long recordingId = indexRecord.recordingId();
                int sequenceNumber = indexRecord.sequenceNumber();
                UnsafeAccess.UNSAFE.loadFence();
                if (changePosition == ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer)) {
                    idleStrategy.reset();
                    if (beginPosition == 0L) {
                        return startPositionQuery.recordingIdToStartPosition();
                    }
                    startPositionQuery.updateStartPosition(sequenceNumber, sequenceIndex, recordingId, beginPosition);
                    iteratorPosition += 32L;
                    continue;
                }
                idleStrategy.idle();
            }
            return startPositionQuery.recordingIdToStartPosition();
        }

        @Override
        public void close() {
            IoUtil.unmap((ByteBuffer)this.headerBuffer.byteBuffer());
            for (UnsafeBuffer segmentBuffer : this.segmentBuffers) {
                if (segmentBuffer == null) continue;
                IoUtil.unmap((ByteBuffer)segmentBuffer.byteBuffer());
            }
        }
    }
}

