/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.PrunePosition;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.StartPositionQuery;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public final class ReplayIndexExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File headerFile, int indexFileCapacity, int indexSegmentCapacity, long fixSessionId, int streamId, String logFileDir, ReplayIndexHandler handler) {
        long indexFileSize = ReplayIndexDescriptor.capacityToBytes(indexFileCapacity);
        int segmentSize = ReplayIndexDescriptor.capacityToBytesInt(indexSegmentCapacity);
        int segmentCount = ReplayIndexDescriptor.segmentCount(indexFileCapacity, indexSegmentCapacity);
        UnsafeBuffer[] segmentBuffers = new UnsafeBuffer[segmentCount];
        int segmentSizeBitShift = Long.numberOfTrailingZeros(segmentSize);
        UnsafeBuffer headerBuffer = new UnsafeBuffer((ByteBuffer)LoggerUtil.mapExistingFile(headerFile));
        try {
            long iteratorPosition;
            MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
            ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
            messageFrameHeader.wrap((DirectBuffer)headerBuffer, 0);
            int actingBlockLength = messageFrameHeader.blockLength();
            int actingVersion = messageFrameHeader.version();
            long stopIteratingPosition = iteratorPosition + indexFileSize;
            for (iteratorPosition = Math.max(ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer) - indexFileSize, 0L); iteratorPosition < stopIteratingPosition; iteratorPosition += 32L) {
                int offset;
                long beginChangePosition;
                long changePosition = ReplayIndexDescriptor.endChangeVolatile((AtomicBuffer)headerBuffer);
                if (changePosition > iteratorPosition && iteratorPosition + indexFileSize < (beginChangePosition = ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)headerBuffer))) {
                    handler.onLapped();
                    iteratorPosition = beginChangePosition - indexFileSize;
                    stopIteratingPosition = beginChangePosition;
                }
                if ((offset = ReplayIndexDescriptor.offsetInSegment(iteratorPosition, segmentSize)) == 0 && iteratorPosition >= changePosition) {
                    break;
                }
                UnsafeBuffer segmentBuffer = ReplayIndexExtractor.segmentBuffer(iteratorPosition, segmentSizeBitShift, segmentBuffers, indexFileSize, fixSessionId, streamId, logFileDir);
                indexRecord.wrap((DirectBuffer)segmentBuffer, offset, actingBlockLength, actingVersion);
                long beginPosition = indexRecord.position();
                if (beginPosition == 0L) {
                    break;
                }
                handler.onEntry(indexRecord);
            }
        }
        finally {
            ReplayIndexDescriptor.unmapBuffers(headerBuffer, segmentBuffers);
        }
    }

    private static UnsafeBuffer segmentBuffer(long position, int segmentSizeBitShift, UnsafeBuffer[] segmentBuffers, long indexFileSize, long fixSessionId, int streamId, String logFileDir) {
        int segmentIndex = ReplayIndexDescriptor.segmentIndex(position, segmentSizeBitShift, indexFileSize);
        UnsafeBuffer segmentBuffer = segmentBuffers[segmentIndex];
        if (segmentBuffer == null) {
            File file = ReplayIndexDescriptor.replayIndexSegmentFile(logFileDir, fixSessionId, streamId, segmentIndex);
            segmentBuffers[segmentIndex] = segmentBuffer = new UnsafeBuffer((ByteBuffer)LoggerUtil.mapExistingFile(file));
        }
        return segmentBuffer;
    }

    public static class PrintError
    implements ReplayIndexHandler {
        private final BufferedWriter out;

        public PrintError(BufferedWriter out) throws IOException {
            this.out = out;
            out.write("beginPosition,sequenceIndex,sequenceNumber,recordingId,readLength\n");
        }

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = indexRecord.position();
            int sequenceIndex = indexRecord.sequenceIndex();
            int sequenceNumber = indexRecord.sequenceNumber();
            long recordingId = indexRecord.recordingId();
            int readLength = indexRecord.length();
            try {
                this.out.write(beginPosition + "," + sequenceIndex + "," + sequenceNumber + "," + recordingId + "," + readLength + "\n");
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }
    }

    public static class BoundaryPositionExtractor
    implements ReplayIndexHandler {
        private final Long2LongHashMap recordingIdToPosition = new Long2LongHashMap(-1L);
        private final Long2ObjectHashMap<Long2LongHashMap> recordingIdToSequenceIndexToPosition = new Long2ObjectHashMap();
        private final boolean min;

        public BoundaryPositionExtractor(boolean min) {
            this.min = min;
        }

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = ReplayQuery.trueBeginPosition(indexRecord.position());
            int sequenceIndex = indexRecord.sequenceIndex();
            long recordingId = indexRecord.recordingId();
            this.boundaryUpdate(this.recordingIdToPosition, beginPosition, recordingId, this.min);
            Long2LongHashMap sequenceIndexToPosition = (Long2LongHashMap)this.recordingIdToSequenceIndexToPosition.computeIfAbsent(recordingId, k -> new Long2LongHashMap(-1L));
            this.boundaryUpdate(sequenceIndexToPosition, beginPosition, sequenceIndex, true);
        }

        private void boundaryUpdate(Long2LongHashMap keyToPosition, long beginPosition, long key, boolean min) {
            long oldPosition = keyToPosition.get(key);
            if (this.beyondBounary(oldPosition, beginPosition, min)) {
                keyToPosition.put(key, beginPosition);
            }
        }

        private boolean beyondBounary(long oldPosition, long beginPosition, boolean min) {
            if (oldPosition == -1L) {
                return true;
            }
            if (min) {
                return beginPosition < oldPosition;
            }
            return beginPosition > oldPosition;
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }

        public Long2LongHashMap recordingIdToPosition() {
            return this.recordingIdToPosition;
        }

        public Long2ObjectHashMap<Long2LongHashMap> recordingIdToSequenceIndexToPosition() {
            return this.recordingIdToSequenceIndexToPosition;
        }

        public void findInconsistentSequenceIndexPositions() {
            this.recordingIdToSequenceIndexToPosition.forEach((recordingId, sequenceIndexToPosition) -> {
                List sequencePositions = sequenceIndexToPosition.entrySet().stream().map(e -> new SequencePosition((Long)e.getKey(), (Long)e.getValue())).sorted(Comparator.comparingLong(SequencePosition::position)).collect(Collectors.toList());
                sequenceIndexToPosition.forEach((sequenceIndex, position) -> sequencePositions.stream().filter(rp -> ((SequencePosition)rp).position < position && ((SequencePosition)rp).sequenceIndex > sequenceIndex).findFirst().ifPresent(sp -> System.out.println("Found suppressor for " + sequenceIndex + " @ " + position + ": " + ((SequencePosition)sp).sequenceIndex + " @ " + ((SequencePosition)sp).position)));
            });
        }
    }

    public static class SequencePosition {
        private final long sequenceIndex;
        private final long position;

        public SequencePosition(long sequenceIndex, long position) {
            this.sequenceIndex = sequenceIndex;
            this.position = position;
        }

        public long position() {
            return this.position;
        }

        public long sequenceIndex() {
            return this.sequenceIndex;
        }

        public String toString() {
            return "SequencePosition{sequenceIndex=" + this.sequenceIndex + ", position=" + this.position + '}';
        }
    }

    public static class StartPositionExtractor
    implements ReplayIndexHandler {
        private final StartPositionQuery startPositionQuery = new StartPositionQuery();

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = indexRecord.position();
            int sequenceIndex = indexRecord.sequenceIndex();
            long recordingId = indexRecord.recordingId();
            int sequenceNumber = indexRecord.sequenceNumber();
            this.startPositionQuery.updateStartPosition(sequenceNumber, sequenceIndex, recordingId, beginPosition);
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }

        public Long2ObjectHashMap<PrunePosition> recordingIdToStartPosition() {
            return this.startPositionQuery.recordingIdToStartPosition();
        }

        public int highestSequenceIndex() {
            return this.startPositionQuery.highestSequenceIndex();
        }
    }

    public static interface ReplayIndexHandler {
        public void onEntry(ReplayIndexRecordDecoder var1);

        public void onLapped();
    }
}

