/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.engine.framer.FramerContext;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;

public class ReplayEvictionHandler {
    private final ErrorHandler errorHandler;
    private ReplayQuery replayQuery;
    private ReplayQuery framerReplayQuery;
    private FramerContext framerContext;

    public ReplayEvictionHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void onReset(long fixSessionId) {
        if (this.replayQuery != null) {
            this.replayQuery.onReset(fixSessionId);
        }
        if (this.framerReplayQuery != null) {
            if (this.framerContext == null) {
                this.errorHandler.onError((Throwable)new NullPointerException("framerContext in ReplayEvictionHandler"));
                return;
            }
            this.framerContext.resetOutboundReplayQuery(fixSessionId);
        }
    }

    public void replayQuery(ReplayQuery replayQuery) {
        if (this.replayQuery != null) {
            this.errorHandler.onError((Throwable)new IllegalStateException("duplicate replay query eviction handling"));
            return;
        }
        this.replayQuery = replayQuery;
    }

    public void framerReplayQuery(ReplayQuery framerReplayQuery) {
        this.framerReplayQuery = framerReplayQuery;
    }

    public void framerContext(FramerContext framerContext) {
        this.framerContext = framerContext;
    }
}

