/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.ChecksumFramer;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.IndexedPositionDecoder;
import uk.co.real_logic.artio.storage.messages.IndexedPositionEncoder;

class IndexedPositionWriter
implements AutoCloseable {
    static final int HEADER_LENGTH = 8;
    static final int RECORD_LENGTH = 24;
    static final int POSITION_OFFSET = IndexedPositionEncoder.positionEncodingOffset();
    private static final int MISSING_RECORD = -1;
    private final IndexedPositionEncoder encoder = new IndexedPositionEncoder();
    private final int actingBlockLength = this.encoder.sbeBlockLength();
    private final int actingVersion = this.encoder.sbeSchemaVersion();
    private final IndexedPositionDecoder decoder = new IndexedPositionDecoder();
    private final Long2LongHashMap recordOffsets = new Long2LongHashMap(-1L);
    private final AtomicBuffer buffer;
    private final ErrorHandler errorHandler;
    private final RecordingIdLookup recordingIdLookup;
    private final ChecksumFramer checksumFramer;
    private final ArrayList<CheckPosition> recheckSessions = new ArrayList();

    IndexedPositionWriter(AtomicBuffer buffer, ErrorHandler errorHandler, int errorReportingOffset, String fileName, RecordingIdLookup recordingIdLookup, boolean indexChecksumEnabled) {
        this.buffer = buffer;
        this.errorHandler = errorHandler;
        this.recordingIdLookup = recordingIdLookup;
        this.checksumFramer = new ChecksumFramer(buffer, buffer.capacity(), errorHandler, errorReportingOffset, fileName, indexChecksumEnabled);
        this.setupHeader();
        this.initialiseOffsets();
    }

    private void initialiseOffsets() {
        int offset = 8;
        while ((offset = this.checksumFramer.claim(offset, 24)) != -1) {
            this.decoder.wrap((DirectBuffer)this.buffer, offset, this.actingBlockLength, this.actingVersion);
            if (this.decoder.position() != 0L) {
                this.recordOffsets.put(this.decoder.recordingId(), (long)offset);
            }
            offset += 24;
        }
        return;
    }

    private void setupHeader() {
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        messageHeaderDecoder.wrap((DirectBuffer)this.buffer, 0);
        if (messageHeaderDecoder.blockLength() == 0) {
            messageHeaderEncoder.wrap((MutableDirectBuffer)this.buffer, 0).templateId(this.encoder.sbeTemplateId()).schemaId(this.encoder.sbeSchemaId()).blockLength(this.actingBlockLength).version(this.actingVersion);
            this.checksumFramer.updateChecksums();
        } else {
            this.checksumFramer.validateCheckSums();
        }
    }

    void indexedUpTo(int aeronSessionId, long recordingId, long position) {
        Long2LongHashMap recordOffsets = this.recordOffsets;
        int offset = (int)recordOffsets.get(recordingId);
        if (offset == -1) {
            IndexedPositionDecoder decoder = this.decoder;
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            AtomicBuffer buffer = this.buffer;
            offset = 8;
            while (true) {
                if ((offset = this.checksumFramer.claim(offset, 24)) == -1) {
                    this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to record new session (%d), indexed position buffer full", aeronSessionId)));
                    return;
                }
                decoder.wrap((DirectBuffer)buffer, offset, actingBlockLength, actingVersion);
                if (decoder.position() == 0L) {
                    this.encoder.wrap((MutableDirectBuffer)buffer, offset).sessionId(aeronSessionId).recordingId(recordingId);
                    recordOffsets.put(recordingId, (long)offset);
                    this.putPosition(position, buffer, offset);
                    return;
                }
                offset += 24;
            }
        }
        this.putPosition(position, this.buffer, offset);
    }

    @Override
    public void close() {
        this.updateChecksums();
    }

    void updateChecksums() {
        this.checksumFramer.updateChecksums();
    }

    AtomicBuffer buffer() {
        return this.buffer;
    }

    private void putPosition(long position, AtomicBuffer buffer, int offset) {
        buffer.putLongVolatile(offset + POSITION_OFFSET, position);
    }

    public void trackPosition(int aeronSessionId, long endPosition) {
        boolean indexedUpTo = this.checkPosition(aeronSessionId, endPosition);
        ArrayList<CheckPosition> recheckSessions = this.recheckSessions;
        int pos = -1;
        for (int i = 0; i < recheckSessions.size(); ++i) {
            if (recheckSessions.get((int)i).aeronSessionId != aeronSessionId) continue;
            pos = i;
            break;
        }
        if (indexedUpTo) {
            if (pos != -1) {
                ArrayListUtil.fastUnorderedRemove(recheckSessions, (int)pos);
            }
        } else if (pos != -1) {
            recheckSessions.get((int)pos).endPosition = endPosition;
        } else {
            recheckSessions.add(new CheckPosition(aeronSessionId, endPosition));
        }
    }

    private boolean checkPosition(int aeronSessionId, long endPosition) {
        long recordingId = this.recordingIdLookup.findRecordingId(aeronSessionId);
        if (recordingId != -1L) {
            this.indexedUpTo(aeronSessionId, recordingId, endPosition);
            return true;
        }
        return false;
    }

    public int checkRecordings() {
        int work = 0;
        ArrayList<CheckPosition> recheckSessions = this.recheckSessions;
        int size = recheckSessions.size();
        for (int i = 0; i < size; ++i) {
            CheckPosition checkPosition = recheckSessions.get(i);
            if (!this.checkPosition(checkPosition.aeronSessionId, checkPosition.endPosition)) continue;
            ArrayListUtil.fastUnorderedRemove(recheckSessions, (int)i);
            --size;
            ++work;
        }
        return work;
    }

    public void update(int aeronSessionId, int templateId, long endPosition, long knownRecordingId) {
        long recordingId = knownRecordingId;
        if (recordingId == -1L) {
            switch (templateId) {
                case 16: 
                case 17: 
                case 33: {
                    this.trackPosition(aeronSessionId, endPosition);
                    return;
                }
                case 7: 
                case 39: 
                case 49: 
                case 55: 
                case 59: {
                    return;
                }
            }
            recordingId = this.recordingIdLookup.getRecordingId(aeronSessionId);
        }
        this.indexedUpTo(aeronSessionId, recordingId, endPosition);
    }

    static final class CheckPosition {
        final int aeronSessionId;
        long endPosition;

        CheckPosition(int aeronSessionId, long endPosition) {
            this.aeronSessionId = aeronSessionId;
            this.endPosition = endPosition;
        }
    }
}

