/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;
import uk.co.real_logic.artio.messages.StartReplayEncoder;
import uk.co.real_logic.artio.messages.ValidResendRequestDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

abstract class AbstractReplayer
implements Agent,
ControlledFragmentHandler {
    static final int POLL_LIMIT = 10;
    private static final int REPLAY_COMPLETE_LEN = 28;
    static final int START_REPLAY_LENGTH = 32;
    final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    final ValidResendRequestDecoder validResendRequest = new ValidResendRequestDecoder();
    final StartReplayEncoder startReplayEncoder = new StartReplayEncoder();
    final Consumer<StringBuilder> validResendRequestAppendTo = arg_0 -> ((ValidResendRequestDecoder)this.validResendRequest).appendTo(arg_0);
    final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    final ReplayCompleteEncoder replayCompleteEncoder = new ReplayCompleteEncoder();
    final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final CharFormatter alreadyDisconnectedFormatter = new CharFormatter("Not processing Resend Request for connId=%s because it has already disconnected");
    final CharFormatter completeReplayGapfillFormatter = new CharFormatter("ReplayerSession: completeReplay-sendGapFill action=%s, replayedMessages=%s, beginGapFillSeqNum=%s, newSequenceNumber=%s connId=%s");
    final ExclusivePublication publication;
    final FixSessionCodecsFactory fixSessionCodecsFactory;
    final BufferClaim bufferClaim;
    final SenderSequenceNumbers senderSequenceNumbers;
    boolean sendStartReplay = true;

    AbstractReplayer(ExclusivePublication publication, FixSessionCodecsFactory fixSessionCodecsFactory, BufferClaim bufferClaim, SenderSequenceNumbers senderSequenceNumbers) {
        this.publication = publication;
        this.fixSessionCodecsFactory = fixSessionCodecsFactory;
        this.bufferClaim = bufferClaim;
        this.senderSequenceNumbers = senderSequenceNumbers;
    }

    boolean trySendStartReplay(long sessionId, long connectionId, long correlationId) {
        if (this.sendStartReplay) {
            long position = this.publication.tryClaim(32, this.bufferClaim);
            if (Pressure.isBackPressured(position)) {
                return true;
            }
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int offset = this.bufferClaim.offset();
            this.startReplayEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).session(sessionId).connection(connectionId).correlationId(correlationId);
            DebugLogger.logSbeMessage(LogTag.REPLAY, this.startReplayEncoder);
            this.bufferClaim.commit();
        }
        return false;
    }

    public void onClose() {
        this.publication.close();
    }

    boolean checkDisconnected(long connectionId) {
        if (this.senderSequenceNumbers.hasDisconnected(connectionId)) {
            DebugLogger.log(LogTag.REPLAY, this.alreadyDisconnectedFormatter, connectionId);
            return true;
        }
        return false;
    }

    boolean sendCompleteMessage(long connectionId, long correlationId) {
        if (this.publication.tryClaim(28, this.bufferClaim) > 0L) {
            ReplayCompleteEncoder replayComplete = this.replayCompleteEncoder;
            replayComplete.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).libraryId(0).connection(connectionId).correlationId(correlationId);
            DebugLogger.logSbeMessage(LogTag.REPLAY, replayComplete);
            this.bufferClaim.commit();
            return true;
        }
        return false;
    }
}

