/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.storage.messages.Bool;
import uk.co.real_logic.artio.storage.messages.ConnectionBackpressureEncoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;

class ReproductionLogWriter {
    private static final int CONN_BP_LEN = 25;
    private final ConnectionBackpressureEncoder connectionBackpressure = new ConnectionBackpressureEncoder();
    private final UnsafeBuffer buffer = new UnsafeBuffer(new byte[25]);
    private final ExclusivePublication reproductionPublication;

    ReproductionLogWriter(ExclusivePublication reproductionPublication) {
        this.reproductionPublication = reproductionPublication;
        while (reproductionPublication.offer((DirectBuffer)this.buffer) < 0L) {
            Thread.yield();
        }
        MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
        this.connectionBackpressure.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, messageHeader);
    }

    void logBackPressure(long connectionId, int seqNum, boolean replay, int written) {
        if (seqNum == -1) {
            return;
        }
        this.connectionBackpressure.connectionId(connectionId).sequenceNumber(seqNum).isReplay(replay ? Bool.TRUE : Bool.FALSE).written(written);
        ExclusivePublication reproductionPublication = this.reproductionPublication;
        long position = reproductionPublication.offer((DirectBuffer)this.buffer, 0, 25);
        if (position < 0L) {
            reproductionPublication.offer((DirectBuffer)this.buffer, 0, 25);
        }
    }
}

