/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import io.aeron.Subscription;
import uk.co.real_logic.artio.engine.framer.ConnectionBackPressureEvent;
import uk.co.real_logic.artio.engine.framer.ReproductionLog;
import uk.co.real_logic.artio.storage.messages.Bool;
import uk.co.real_logic.artio.storage.messages.ConnectionBackpressureDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;

final class ReproductionLogReader {
    ReproductionLogReader() {
    }

    static ReproductionLog read(Subscription recordingSubscription) {
        if (recordingSubscription == null) {
            return null;
        }
        MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
        ConnectionBackpressureDecoder connectionBackpressure = new ConnectionBackpressureDecoder();
        ReproductionLog reproductionLog = new ReproductionLog();
        Image recordingImage = null;
        while (recordingSubscription.hasNoImages()) {
            Thread.yield();
        }
        recordingImage = recordingSubscription.imageAtIndex(0);
        while (!recordingImage.isEndOfStream() && !recordingImage.isClosed()) {
            recordingSubscription.poll((buffer, offset, length, header) -> {
                MessageHeaderDecoder messageHdr = messageHeader;
                messageHdr.wrap(buffer, offset);
                int templateId = messageHdr.templateId();
                if (templateId == 34) {
                    ConnectionBackpressureDecoder connectionBackpress = connectionBackpressure;
                    connectionBackpress.wrap(buffer, offset, messageHdr.blockLength(), messageHdr.version());
                    reproductionLog.put(connectionBackpress.connectionId(), new ConnectionBackPressureEvent(connectionBackpress.sequenceNumber(), connectionBackpress.isReplay() == Bool.TRUE, connectionBackpress.written()));
                }
            }, 10);
            Thread.yield();
        }
        return reproductionLog;
    }
}

