/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.LongDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.otf.OtfParser;
import uk.co.real_logic.artio.util.AsciiBuffer;

class PasswordCleaner {
    private static final int NO_ENTRY = -1;
    private static final int REPLACEMENT_LENGTH = 3;
    private static final UnsafeBuffer REPLACEMENT = new UnsafeBuffer(new byte[3]);
    private int passwordOffset;
    private int passwordLength;
    private int newPasswordOffset;
    private int newPasswordLength;
    private int bodyLength;
    private int bodyLengthOffset;
    private int lengthOfBodyLength;
    private final FieldScanner fieldScanner = new FieldScanner();
    private final OtfParser parser = new OtfParser((OtfMessageAcceptor)this.fieldScanner, new LongDictionary());
    private final ExpandableArrayBuffer cleanedBuffer = new ExpandableArrayBuffer();
    private int cleanedLength;

    PasswordCleaner() {
    }

    public void clean(DirectBuffer buffer, int offset, int length) {
        int newPasswordLengthChange;
        int secondLength;
        int secondOffset;
        int firstLength;
        int firstOffset;
        this.parser.onMessage(buffer, offset, length);
        int passwordOffset = this.passwordOffset;
        if (passwordOffset == -1) {
            this.cleanedBuffer.putBytes(0, buffer, offset, length);
            this.cleanedLength = length;
            return;
        }
        int newPasswordOffset = this.newPasswordOffset;
        if (passwordOffset < newPasswordOffset || newPasswordOffset == -1) {
            firstOffset = passwordOffset;
            firstLength = this.passwordLength;
            secondOffset = newPasswordOffset;
            secondLength = this.newPasswordLength;
        } else {
            firstOffset = newPasswordOffset;
            firstLength = this.newPasswordLength;
            secondOffset = passwordOffset;
            secondLength = this.passwordLength;
        }
        int headLength = firstOffset - offset;
        this.cleanedBuffer.putBytes(0, buffer, offset, headLength);
        this.putReplacement(headLength);
        int nextDestOffset = headLength + 3;
        int nextSrcOffset = firstOffset + firstLength;
        if (secondOffset == -1) {
            int tailLength = length - (headLength + firstLength);
            this.cleanedBuffer.putBytes(nextDestOffset, buffer, nextSrcOffset, tailLength);
            newPasswordLengthChange = 0;
        } else {
            int midLength = secondOffset - nextSrcOffset;
            this.cleanedBuffer.putBytes(nextDestOffset, buffer, nextSrcOffset, midLength);
            int destNewPasswordOffset = nextDestOffset + midLength;
            this.putReplacement(destNewPasswordOffset);
            int tailSrcOffset = secondOffset + secondLength;
            int tailLength = length + offset - tailSrcOffset;
            int tailDestOffset = destNewPasswordOffset + 3;
            this.cleanedBuffer.putBytes(tailDestOffset, buffer, tailSrcOffset, tailLength);
            newPasswordLengthChange = secondLength - 3;
        }
        int lengthChange = firstLength - 3 + newPasswordLengthChange;
        this.cleanedLength = length - lengthChange;
        if (this.lengthOfBodyLength == 2) {
            int endOfBodyLength = this.bodyLengthOffset - offset + this.lengthOfBodyLength;
            this.shiftRight(endOfBodyLength, this.cleanedLength - endOfBodyLength);
            ++this.lengthOfBodyLength;
            ++this.cleanedLength;
            --lengthChange;
        }
        this.updateBodyLengthField(offset, lengthChange);
    }

    private void shiftRight(int from, int bytes) {
        for (int i = from + bytes; i >= from; --i) {
            this.cleanedBuffer.putByte(i + 1, this.cleanedBuffer.getByte(i));
        }
    }

    private void putReplacement(int destNewPasswordOffset) {
        this.cleanedBuffer.putBytes(destNewPasswordOffset, (DirectBuffer)REPLACEMENT, 0, 3);
    }

    private void updateBodyLengthField(int offset, int lengthChange) {
        int newBodyLength = this.bodyLength - lengthChange;
        int relativeBodyLengthOffset = this.bodyLengthOffset - offset;
        this.cleanedBuffer.putNaturalPaddedIntAscii(relativeBodyLengthOffset, this.lengthOfBodyLength, newBodyLength);
    }

    public DirectBuffer cleanedBuffer() {
        return this.cleanedBuffer;
    }

    public int cleanedLength() {
        return this.cleanedLength;
    }

    static {
        REPLACEMENT.putStringWithoutLengthAscii(0, "***");
    }

    private class FieldScanner
    implements OtfMessageAcceptor {
        private FieldScanner() {
        }

        public MessageControl onNext() {
            PasswordCleaner.this.passwordOffset = -1;
            PasswordCleaner.this.newPasswordOffset = -1;
            PasswordCleaner.this.bodyLength = -1;
            PasswordCleaner.this.bodyLengthOffset = -1;
            PasswordCleaner.this.lengthOfBodyLength = -1;
            return MessageControl.CONTINUE;
        }

        public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
            switch (tag) {
                case 554: {
                    PasswordCleaner.this.passwordOffset = offset;
                    PasswordCleaner.this.passwordLength = length;
                    break;
                }
                case 925: {
                    PasswordCleaner.this.newPasswordOffset = offset;
                    PasswordCleaner.this.newPasswordLength = length;
                    break;
                }
                case 9: {
                    PasswordCleaner.this.bodyLengthOffset = offset;
                    PasswordCleaner.this.lengthOfBodyLength = length;
                    PasswordCleaner.this.bodyLength = buffer.getInt(offset, offset + length);
                }
            }
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupHeader(int tag, int numInGroup) {
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        public MessageControl onComplete() {
            return MessageControl.CONTINUE;
        }

        public boolean onError(ValidationError error, long messageType, int tagNumber, AsciiFieldFlyweight value) {
            return false;
        }
    }
}

