/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.engine.AbstractConnectedSessionInfo;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.messages.ConnectionType;

abstract class GatewaySession
implements AbstractConnectedSessionInfo {
    protected static final int NO_TIMEOUT = -1;
    protected final ConnectionType connectionType;
    protected final long authenticationTimeoutInMs;
    protected ReceiverEndPoint receiverEndPoint;
    protected long sessionId;
    protected long connectionId;
    protected String address;
    protected long disconnectTimeInMs = -1L;
    protected boolean hasStartedAuthentication = false;
    protected int libraryId;
    protected int lastLibraryId;

    GatewaySession(long connectionId, long sessionId, String address, ConnectionType connectionType, long authenticationTimeoutInMs, ReceiverEndPoint receiverEndPoint) {
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.address = address;
        this.connectionType = connectionType;
        this.authenticationTimeoutInMs = authenticationTimeoutInMs;
        this.receiverEndPoint = receiverEndPoint;
    }

    @Override
    public long connectionId() {
        return this.connectionId;
    }

    @Override
    public abstract String address();

    public long sessionId() {
        return this.sessionId;
    }

    abstract int poll(long var1, long var3);

    void startAuthentication(long timeInMs) {
        this.hasStartedAuthentication = true;
        this.disconnectTimeInMs = timeInMs + this.authenticationTimeoutInMs;
    }

    void onAuthenticationResult() {
        this.disconnectTimeInMs = -1L;
    }

    void disconnectAt(long disconnectTimeout) {
        this.disconnectTimeInMs = disconnectTimeout;
    }

    boolean hasDisconnected() {
        return this.receiverEndPoint == null || this.receiverEndPoint.hasDisconnected();
    }

    int checkNoLogonDisconnect(long timeInMs) {
        if (this.disconnectTimeInMs == -1L) {
            return 0;
        }
        if (this.disconnectTimeInMs <= timeInMs && !this.hasDisconnected()) {
            if (this.hasStartedAuthentication) {
                this.receiverEndPoint.onAuthenticationTimeoutDisconnect();
            } else {
                this.receiverEndPoint.onNoLogonDisconnect();
            }
            return 1;
        }
        return 0;
    }

    public boolean isOffline() {
        return this.receiverEndPoint == null;
    }

    ConnectionType connectionType() {
        return this.connectionType;
    }

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    public int libraryId() {
        return this.libraryId;
    }

    public void consumeOfflineSession(GatewaySession oldGatewaySession) {
        this.libraryId(oldGatewaySession.libraryId());
    }

    abstract long lastLogonTime();

    abstract void acceptorSequenceNumbers(int var1, int var2);

    abstract void onDisconnectReleasedByOwner();

    abstract void close();

    public abstract boolean configureThrottle(int var1, int var2);

    public abstract long startEndOfDay();
}

