/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.function.LongToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.util.CharFormatter;

class FixSenderEndPoints
implements AutoCloseable {
    final CharFormatter missReplayComplete = new CharFormatter("SEPs.missReplayComplete, connId=%s, corrId=%s, slow=%s");
    private final Long2ObjectHashMap<FixSenderEndPoint> connectionIdToSenderEndpoint = new Long2ObjectHashMap();
    private final ErrorHandler errorHandler;
    private final LongToIntFunction libraryLookup = this::libraryLookup;
    private long timeInMs;

    private int libraryLookup(long sessionId) {
        for (FixSenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (senderEndPoint.sessionId() != sessionId) continue;
            return senderEndPoint.libraryId();
        }
        return 0;
    }

    FixSenderEndPoints(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void add(FixSenderEndPoint senderEndPoint) {
        this.connectionIdToSenderEndpoint.put(senderEndPoint.connectionId(), (Object)senderEndPoint);
    }

    void removeConnection(long connectionId) {
        FixSenderEndPoint senderEndPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.remove(connectionId);
        if (senderEndPoint != null) {
            senderEndPoint.close();
        }
    }

    boolean onMessage(int libraryId, long connectionId, DirectBuffer buffer, int offset, int length, int sequenceNumber, int sequenceIndex, long messageType, int metaDataLength) {
        FixSenderEndPoint endPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            endPoint.onOutboundMessage(libraryId, buffer, offset, length, sequenceNumber, sequenceIndex, messageType, this.timeInMs, metaDataLength);
            return true;
        }
        return false;
    }

    ControlledFragmentHandler.Action onThrottleReject(int libraryId, long connectionId, long refMsgType, int refSeqNum, int sequenceNumber, int sequenceIndex, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength) {
        FixSenderEndPoint endPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            endPoint.onThrottleReject(libraryId, refMsgType, refSeqNum, sequenceNumber, sequenceIndex, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength, this.timeInMs);
        }
        return null;
    }

    ControlledFragmentHandler.Action onReplayMessage(long connectionId, DirectBuffer buffer, int offset, int length, int sequenceNumber) {
        FixSenderEndPoint endPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            return endPoint.onReplayMessage(buffer, offset, length, this.timeInMs, sequenceNumber);
        }
        this.logReplayError(connectionId, buffer, offset, length);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void logReplayError(long connectionId, DirectBuffer buffer, int offset, int length) {
        this.errorHandler.onError((Throwable)new IllegalArgumentException(String.format("Failed to replay message on conn=%1$d [%2$s], this probably indicates the connection has disconnected from Artio whilst this message was in the process of being replayed", connectionId, buffer.getStringWithoutLengthUtf8(offset, length))));
    }

    ControlledFragmentHandler.Action onReplayComplete(long connectionId, long correlationId, boolean slow) {
        FixSenderEndPoint senderEndPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onReplayComplete(correlationId);
        }
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.missReplayComplete.clear().with(connectionId).with(correlationId).with(slow));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public void close() {
        this.connectionIdToSenderEndpoint.values().forEach(FixSenderEndPoint::close);
    }

    public boolean isSlowConsumer(long connectionId) {
        FixSenderEndPoint fixSenderEndPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        return fixSenderEndPoint != null && fixSenderEndPoint.isSlowConsumer();
    }

    void timeInMs(long timeInMs) {
        this.timeInMs = timeInMs;
    }

    int poll(long timeInMs) {
        int count = 0;
        for (FixSenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (!senderEndPoint.poll(timeInMs)) continue;
            ++count;
        }
        return count;
    }

    LongToIntFunction libraryLookup() {
        return this.libraryLookup;
    }

    public void onValidResendRequest(long connection, long correlationId) {
        FixSenderEndPoint fixSenderEndPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connection);
        if (fixSenderEndPoint != null) {
            fixSenderEndPoint.onValidResendRequest(correlationId);
        }
    }

    public void onStartReplay(long connection, long correlationId, boolean slow) {
        FixSenderEndPoint fixSenderEndPoint = (FixSenderEndPoint)this.connectionIdToSenderEndpoint.get(connection);
        if (fixSenderEndPoint != null) {
            fixSenderEndPoint.onStartReplay(correlationId);
        }
    }
}

