/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;

public class FixPSenderEndPoints
implements AutoCloseable {
    private final Long2ObjectHashMap<FixPSenderEndPoint> connectionIdToSenderEndpoint = new Long2ObjectHashMap();
    private FixPSenderEndPoint[] backPressuredEndpoints = new FixPSenderEndPoint[0];

    public ControlledFragmentHandler.Action onMessage(long connectionId, DirectBuffer buffer, int offset, boolean retransmit) {
        FixPSenderEndPoint senderEndPoint = (FixPSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onMessage(buffer, offset, retransmit);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public int reattempt() {
        Object[] backpressuredEndpoints = this.backPressuredEndpoints;
        int size = backpressuredEndpoints.length;
        for (int i = 0; i < size; ++i) {
            FixPSenderEndPoint endpoint = backpressuredEndpoints[i];
            if (!endpoint.reattempt()) continue;
            backpressuredEndpoints = (FixPSenderEndPoint[])ArrayUtil.remove((Object[])backpressuredEndpoints, (int)i);
            --size;
        }
        this.backPressuredEndpoints = backpressuredEndpoints;
        return size;
    }

    public void add(FixPSenderEndPoint senderEndPoint) {
        this.connectionIdToSenderEndpoint.put(senderEndPoint.connectionId(), (Object)senderEndPoint);
    }

    void removeConnection(long connectionId) {
        FixPSenderEndPoint endPoint = (FixPSenderEndPoint)this.connectionIdToSenderEndpoint.remove(connectionId);
        if (endPoint != null) {
            endPoint.close();
        }
    }

    public ControlledFragmentHandler.Action onReplayComplete(long connectionId, long correlationId, boolean slow) {
        FixPSenderEndPoint senderEndPoint = (FixPSenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onReplayComplete(correlationId);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "ILink3SenderEndPoints{connectionIdToSenderEndpoint=" + this.connectionIdToSenderEndpoint + '}';
    }

    void backPressured(FixPSenderEndPoint endPoint) {
        this.backPressuredEndpoints = (FixPSenderEndPoint[])ArrayUtil.add((Object[])this.backPressuredEndpoints, (Object)endPoint);
    }

    public void onValidResendRequest(long connection, long correlationId) {
        FixPSenderEndPoint fixSenderEndPoint = (FixPSenderEndPoint)this.connectionIdToSenderEndpoint.get(connection);
        if (fixSenderEndPoint != null) {
            fixSenderEndPoint.onValidResendRequest(correlationId);
        }
    }

    @Override
    public void close() {
        this.connectionIdToSenderEndpoint.values().forEach(SenderEndPoint::close);
    }
}

