/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.framer.ExplicitFixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoints;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ImplicitFixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;

abstract class FixPSenderEndPoint
extends SenderEndPoint {
    protected static final int NO_REATTEMPT = 0;
    protected final FixPReceiverEndPoint receiverEndPoint;
    protected int reattemptBytesWritten = 0;

    static FixPSenderEndPoint of(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, ReproductionLogWriter reproductionPublication, int libraryId, MessageTimingHandler messageTimingHandler, boolean explicitSequenceNumbers, int templateIdOffset, int retransmissionTemplateId, FixPSenderEndPoints fixPSenderEndPoints, AtomicCounter bytesInBuffer, int maxBytesInBuffer, Framer framer, FixPReceiverEndPoint receiverEndPoint) {
        if (explicitSequenceNumbers) {
            return new ExplicitFixPSenderEndPoint(connectionId, channel, errorHandler, inboundPublication, reproductionPublication, libraryId, messageTimingHandler, bytesInBuffer, maxBytesInBuffer, framer, receiverEndPoint);
        }
        return new ImplicitFixPSenderEndPoint(connectionId, channel, errorHandler, inboundPublication, reproductionPublication, libraryId, templateIdOffset, retransmissionTemplateId, fixPSenderEndPoints, bytesInBuffer, maxBytesInBuffer, framer, receiverEndPoint);
    }

    FixPSenderEndPoint(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, ReproductionLogWriter reproductionLogWriter, int libraryId, AtomicCounter bytesInBuffer, int maxBytesInBuffer, Framer framer, FixPReceiverEndPoint receiverEndPoint) {
        super(connectionId, inboundPublication, reproductionLogWriter, libraryId, channel, bytesInBuffer, maxBytesInBuffer, errorHandler, framer);
        this.receiverEndPoint = receiverEndPoint;
    }

    public abstract ControlledFragmentHandler.Action onMessage(DirectBuffer var1, int var2, boolean var3);

    protected int writeBuffer(DirectBuffer directBuffer, int offset, int messageSize) throws IOException {
        int reattemptBytesWritten = this.reattemptBytesWritten;
        ByteBuffer buffer = directBuffer.byteBuffer();
        int startLimit = buffer.limit();
        int startPosition = buffer.position();
        ByteBufferUtil.limit(buffer, offset + messageSize);
        ByteBufferUtil.position(buffer, reattemptBytesWritten + offset);
        int written = this.channel.write(buffer, 0, false);
        ByteBufferUtil.position(buffer, offset);
        DebugLogger.logBytes(LogTag.FIX_MESSAGE_TCP, "Written  ", buffer, startPosition, written);
        buffer.limit(startLimit).position(startPosition);
        return reattemptBytesWritten + written;
    }

    abstract boolean reattempt();

    public abstract void onValidResendRequest(long var1);
}

