/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.FileSystemCorruptionException;

public class SectorFramer {
    public static final int OUT_OF_SPACE = -1;
    public static final int SECTOR_SIZE = 4096;
    public static final int CHECKSUM_SIZE = 4;
    public static final int SECTOR_DATA_LENGTH = 4092;
    public static final int FIRST_CHECKSUM_LOCATION = 4092;
    protected final int capacity;
    private int checksumOffset;
    private int sectorStart;

    public SectorFramer(int capacity) {
        this.capacity = capacity;
    }

    public int claim(int filePosition, int length) {
        int nextSectorStart = SectorFramer.nextSectorStart(filePosition);
        this.checksumOffset = nextSectorStart - 4;
        int proposedRecordEnd = filePosition + length;
        if (proposedRecordEnd > this.checksumOffset) {
            filePosition = nextSectorStart;
            this.checksumOffset += 4096;
        }
        this.sectorStart = nextSectorStart - 4096;
        return filePosition + length <= this.capacity ? filePosition : -1;
    }

    public int checksumOffset() {
        return this.checksumOffset;
    }

    public int sectorStart() {
        return this.sectorStart;
    }

    public static int nextSectorStart(int offset) {
        return offset / 4096 * 4096 + 4096;
    }

    public static void validateCheckSum(String fileName, int start, int end, int savedChecksum, int calculatedChecksum, ErrorHandler errorHandler) {
        if (calculatedChecksum != savedChecksum) {
            FileSystemCorruptionException exception = new FileSystemCorruptionException(fileName, start, end, savedChecksum, calculatedChecksum);
            errorHandler.onError((Throwable)exception);
        }
    }
}

