/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import io.aeron.Aeron;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.OffsetEpochNanoClock;
import uk.co.real_logic.artio.CommonConfiguration;

public final class ArtioAdminConfiguration {
    public static final String INBOUND_STREAM_ID_PROP = "fix.admin.inbound_stream_id";
    public static final String OUTBOUND_STREAM_ID_PROP = "fix.admin.outbound_stream_id";
    public static final String AERON_CHANNEL_PROP = "fix.admin.aeron_channel";
    public static final int DEFAULT_INBOUND_ADMIN_STREAM_ID = 21;
    public static final int DEFAULT_OUTBOUND_ADMIN_STREAM_ID = 22;
    private final AtomicBoolean isConcluded = new AtomicBoolean(false);
    private final Aeron.Context aeronContext = new Aeron.Context();
    private IdleStrategy idleStrategy;
    private EpochNanoClock epochNanoClock;
    private int inboundAdminStream = Integer.getInteger("fix.admin.inbound_stream_id", 21);
    private int outboundAdminStream = Integer.getInteger("fix.admin.outbound_stream_id", 22);
    private String aeronChannel = System.getProperty("fix.admin.aeron_channel", "aeron:ipc");
    private long replyTimeoutInNs = TimeUnit.MILLISECONDS.toNanos(10000L);

    public ArtioAdminConfiguration idleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = idleStrategy;
        return this;
    }

    public ArtioAdminConfiguration inboundAdminStream(int inboundAdminStream) {
        this.inboundAdminStream = inboundAdminStream;
        return this;
    }

    public ArtioAdminConfiguration outboundAdminStream(int outboundAdminStream) {
        this.outboundAdminStream = outboundAdminStream;
        return this;
    }

    public ArtioAdminConfiguration aeronChannel(String aeronChannel) {
        this.aeronChannel = aeronChannel;
        return this;
    }

    public ArtioAdminConfiguration replyTimeoutInNs(long replyTimeoutInNs) {
        this.replyTimeoutInNs = replyTimeoutInNs;
        return this;
    }

    public ArtioAdminConfiguration epochNanoClock(EpochNanoClock epochNanoClock) {
        this.epochNanoClock = epochNanoClock;
        return this;
    }

    public Aeron.Context aeronContext() {
        return this.aeronContext;
    }

    public IdleStrategy idleStrategy() {
        return this.idleStrategy;
    }

    public EpochNanoClock epochNanoClock() {
        return this.epochNanoClock;
    }

    public int inboundAdminStream() {
        return this.inboundAdminStream;
    }

    public int outboundAdminStream() {
        return this.outboundAdminStream;
    }

    public String aeronChannel() {
        return this.aeronChannel;
    }

    public long replyTimeoutInNs() {
        return this.replyTimeoutInNs;
    }

    void conclude() {
        if (this.isConcluded.compareAndSet(false, true)) {
            if (this.idleStrategy() == null) {
                this.idleStrategy(CommonConfiguration.backoffIdleStrategy());
            }
            if (this.epochNanoClock() == null) {
                this.epochNanoClock((EpochNanoClock)new OffsetEpochNanoClock());
            }
        } else {
            throw new IllegalStateException("This configuration has already been concluded, are you trying to re-use it?");
        }
    }
}

