/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.util.Arrays;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SenderTargetAndSubCompositeKeyDecoder;
import uk.co.real_logic.artio.storage.messages.SenderTargetAndSubCompositeKeyEncoder;

class SenderTargetAndSubSessionIdStrategy
implements SessionIdStrategy {
    private static final int BLOCK_AND_LENGTH_FIELDS_LENGTH = 6;
    private final SenderTargetAndSubCompositeKeyEncoder keyEncoder = new SenderTargetAndSubCompositeKeyEncoder();
    private final SenderTargetAndSubCompositeKeyDecoder keyDecoder = new SenderTargetAndSubCompositeKeyDecoder();
    private final int actingBlockLength = this.keyDecoder.sbeBlockLength();
    private final int actingVersion = this.keyDecoder.sbeSchemaVersion();

    SenderTargetAndSubSessionIdStrategy() {
    }

    @Override
    public CompositeKey onAcceptLogon(SessionHeaderDecoder header) {
        Objects.requireNonNull(header, "header");
        int localCompIDLength = header.targetCompIDLength();
        int localSubIDLength = header.senderSubIDLength();
        int remoteCompIDLength = header.senderCompIDLength();
        if (localCompIDLength == 0 || localSubIDLength == 0 || remoteCompIDLength == 0) {
            throw new IllegalArgumentException("Missing comp id");
        }
        return new CompositeKeyImpl(header.targetCompID(), localCompIDLength, header.senderSubID(), localSubIDLength, header.senderCompID(), remoteCompIDLength);
    }

    @Override
    public CompositeKey onInitiateLogon(String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId) {
        char[] senderCompIdChars = localCompId.toCharArray();
        char[] senderSubIdChars = localSubId.toCharArray();
        char[] targetCompIdChars = remoteCompId.toCharArray();
        return new CompositeKeyImpl(senderCompIdChars, senderCompIdChars.length, senderSubIdChars, senderSubIdChars.length, targetCompIdChars, targetCompIdChars.length);
    }

    @Override
    public void setupSession(CompositeKey compositeKey, SessionHeaderEncoder headerEncoder) {
        CompositeKeyImpl composite = (CompositeKeyImpl)compositeKey;
        headerEncoder.senderCompID(SessionIdStrategy.checkMissing(composite.localCompID));
        headerEncoder.senderSubID(SessionIdStrategy.checkMissing(composite.localSubID));
        headerEncoder.targetCompID(SessionIdStrategy.checkMissing(composite.remoteCompID));
    }

    @Override
    public int save(CompositeKey compositeKey, MutableDirectBuffer buffer, int offset) {
        String localCompID = compositeKey.localCompId();
        String localSubID = compositeKey.localSubId();
        String remoteCompID = compositeKey.remoteCompId();
        int length = localCompID.length() + localSubID.length() + remoteCompID.length() + 6;
        if (buffer.capacity() < offset + length) {
            return -1;
        }
        this.keyEncoder.wrap(buffer, offset);
        this.keyEncoder.localCompId(localCompID);
        this.keyEncoder.localSubId(localSubID);
        this.keyEncoder.remoteCompId(remoteCompID);
        return length;
    }

    @Override
    public CompositeKey load(DirectBuffer buffer, int offset, int length) {
        this.keyDecoder.wrap(buffer, offset, this.actingBlockLength, this.actingVersion);
        int localCompIdLength = this.keyDecoder.localCompIdLength();
        byte[] localCompId = new byte[localCompIdLength];
        this.keyDecoder.getLocalCompId(localCompId, 0, localCompIdLength);
        int localSubIdLength = this.keyDecoder.localSubIdLength();
        byte[] localSubId = new byte[localSubIdLength];
        this.keyDecoder.getLocalSubId(localSubId, 0, localSubIdLength);
        int remoteCompIdLength = this.keyDecoder.remoteCompIdLength();
        byte[] remoteCompId = new byte[remoteCompIdLength];
        this.keyDecoder.getRemoteCompId(remoteCompId, 0, remoteCompIdLength);
        return new CompositeKeyImpl(localCompId, localSubId, remoteCompId);
    }

    @Override
    public int validateCompIds(CompositeKey compositeKey, SessionHeaderDecoder header) {
        CompositeKeyImpl key = (CompositeKeyImpl)compositeKey;
        if (!CodecUtil.equals((char[])key.remoteCompID, (char[])header.senderCompID(), (int)header.senderCompIDLength())) {
            return 49;
        }
        if (!CodecUtil.equals((char[])key.localCompID, (char[])header.targetCompID(), (int)header.targetCompIDLength())) {
            return 56;
        }
        boolean hasSenderSubID = header.hasSenderSubID();
        if (!hasSenderSubID || !CodecUtil.equals((char[])key.localSubID, (char[])header.senderSubID(), (int)header.senderSubIDLength())) {
            return 50;
        }
        return 0;
    }

    private static final class CompositeKeyImpl
    implements CompositeKey {
        private final char[] localCompID;
        private final char[] localSubID;
        private final char[] remoteCompID;
        private final int hashCode;

        private CompositeKeyImpl(char[] localCompID, int localCompIDLength, char[] localSubID, int localSubIDLength, char[] remoteCompID, int remoteCompIDLength) {
            this.localCompID = Arrays.copyOf(localCompID, localCompIDLength);
            this.remoteCompID = Arrays.copyOf(remoteCompID, remoteCompIDLength);
            this.localSubID = Arrays.copyOf(localSubID, localSubIDLength);
            this.hashCode = this.hash(this.localCompID, this.localSubID, this.remoteCompID);
        }

        private CompositeKeyImpl(byte[] localCompID, byte[] localSubID, byte[] remoteCompID) {
            this.localCompID = CodecUtil.fromBytes((byte[])localCompID);
            this.localSubID = CodecUtil.fromBytes((byte[])localSubID);
            this.remoteCompID = CodecUtil.fromBytes((byte[])remoteCompID);
            this.hashCode = this.hash(this.localCompID, this.localSubID, this.remoteCompID);
        }

        private int hash(char[] localCompID, char[] localSubID, char[] remoteCompID) {
            int result = Arrays.hashCode(localCompID);
            result = 31 * result + Arrays.hashCode(localSubID);
            result = 31 * result + Arrays.hashCode(remoteCompID);
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeKeyImpl) {
                CompositeKeyImpl compositeKey = (CompositeKeyImpl)obj;
                return Arrays.equals(compositeKey.localCompID, this.localCompID) && Arrays.equals(compositeKey.localSubID, this.localSubID) && Arrays.equals(compositeKey.remoteCompID, this.remoteCompID);
            }
            return false;
        }

        public String toString() {
            return "CompositeKey{localCompId=" + this.localCompId() + ", localSubId=" + this.localSubId() + ", remoteCompId=" + this.remoteCompId() + '}';
        }

        @Override
        public String localCompId() {
            return new String(this.localCompID);
        }

        @Override
        public String localSubId() {
            return new String(this.localSubID);
        }

        @Override
        public String localLocationId() {
            return "";
        }

        @Override
        public String remoteCompId() {
            return new String(this.remoteCompID);
        }

        @Override
        public String remoteSubId() {
            return "";
        }

        @Override
        public String remoteLocationId() {
            return "";
        }
    }
}

