/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.EndOfDayDecoder;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.InboundFixPConnectDecoder;
import uk.co.real_logic.artio.messages.LibraryExtendPositionDecoder;
import uk.co.real_logic.artio.messages.ManageFixPConnectionDecoder;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataReplyDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ReplayCompleteDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesReplyDecoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberDecoder;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.SlowStatusNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleConfigurationReplyDecoder;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataReplyDecoder;
import uk.co.real_logic.artio.protocol.LibraryEndPointHandler;

public final class LibraryProtocolSubscription
implements ControlledFragmentHandler {
    private static final int READ_META_DATA_META_DATA_PREFIX = 13 + ReadMetaDataReplyDecoder.metaDataHeaderLength();
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ErrorDecoder error = new ErrorDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final ReleaseSessionReplyDecoder releaseSessionReply = new ReleaseSessionReplyDecoder();
    private final RequestSessionReplyDecoder requestSessionReply = new RequestSessionReplyDecoder();
    private final WriteMetaDataReplyDecoder writeMetaDataReply = new WriteMetaDataReplyDecoder();
    private final ReadMetaDataReplyDecoder readMetaDataReply = new ReadMetaDataReplyDecoder();
    private final ControlNotificationDecoder controlNotification = new ControlNotificationDecoder();
    private final SlowStatusNotificationDecoder slowStatusNotification = new SlowStatusNotificationDecoder();
    private final ResetLibrarySequenceNumberDecoder resetLibrarySequenceNumber = new ResetLibrarySequenceNumberDecoder();
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final FollowerSessionReplyDecoder followerSessionReply = new FollowerSessionReplyDecoder();
    private final EndOfDayDecoder endOfDay = new EndOfDayDecoder();
    private final ReplayMessagesReplyDecoder replayMessagesReply = new ReplayMessagesReplyDecoder();
    private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
    private final LibraryExtendPositionDecoder libraryExtendPosition = new LibraryExtendPositionDecoder();
    private final ReplayCompleteDecoder replayComplete = new ReplayCompleteDecoder();
    private final InboundFixPConnectDecoder inboundFixPConnect = new InboundFixPConnectDecoder();
    private final ManageFixPConnectionDecoder manageFixPConnection = new ManageFixPConnectionDecoder();
    private final ThrottleNotificationDecoder throttleNotification = new ThrottleNotificationDecoder();
    private final ThrottleConfigurationReplyDecoder throttleConfigurationReply = new ThrottleConfigurationReplyDecoder();
    private final LibraryEndPointHandler handler;

    public LibraryProtocolSubscription(LibraryEndPointHandler handler) {
        this.handler = handler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 8: {
                return this.onManageSession(buffer, offset, blockLength, version);
            }
            case 13: {
                return this.onError(buffer, offset, blockLength, version);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version);
            }
            case 30: {
                return this.onReleaseSessionReply(buffer, offset, blockLength, version);
            }
            case 32: {
                return this.onRequestSessionReply(buffer, offset, blockLength, version);
            }
            case 39: {
                return this.onControlNotification(buffer, offset, blockLength, version);
            }
            case 43: {
                return this.onSlowStatusNotification(buffer, offset, blockLength, version);
            }
            case 44: {
                return this.onResetLibrarySequenceNumber(buffer, offset, blockLength, version);
            }
            case 48: {
                return this.onFollowerSessionReply(buffer, offset, blockLength, version);
            }
            case 50: {
                return this.onWriteMetaDataReply(buffer, offset, blockLength, version);
            }
            case 52: {
                return this.onReadMetaDataReply(buffer, offset, blockLength, version);
            }
            case 49: {
                return this.onEndOfDay(buffer, offset, blockLength, version);
            }
            case 54: {
                return this.onReplayMessagesReply(buffer, offset, blockLength, version);
            }
            case 57: {
                return this.onILinkConnect(buffer, offset, blockLength, version);
            }
            case 60: {
                return this.onLibraryExtendPosition(buffer, offset, blockLength, version);
            }
            case 45: {
                return this.onReplayComplete(buffer, offset, blockLength, version);
            }
            case 67: {
                return this.onInboundFixPConnect(buffer, offset, blockLength, version);
            }
            case 68: {
                return this.onManageFixPConnection(buffer, offset, blockLength, version);
            }
            case 70: {
                return this.onThrottleNotification(buffer, offset, blockLength, version, header.position());
            }
            case 73: {
                return this.onThrottleConfigurationReply(buffer, offset, blockLength, version, header.position());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onThrottleConfigurationReply(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        ThrottleConfigurationReplyDecoder throttleConfigurationReply = this.throttleConfigurationReply;
        throttleConfigurationReply.wrap(buffer, offset, blockLength, version);
        int libraryId = throttleConfigurationReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onThrottleConfigurationReply(libraryId, throttleConfigurationReply.replyToId(), throttleConfigurationReply.status());
    }

    private ControlledFragmentHandler.Action onThrottleNotification(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        ThrottleNotificationDecoder throttleNotification = this.throttleNotification;
        throttleNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = throttleNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        int businessRejectRefIDOffset = throttleNotification.limit() + ThrottleNotificationDecoder.businessRejectRefIDHeaderLength();
        return this.handler.onThrottleNotification(libraryId, throttleNotification.connection(), throttleNotification.refMsgType(), throttleNotification.refSeqNum(), buffer, businessRejectRefIDOffset, throttleNotification.businessRejectRefIDLength(), position);
    }

    private ControlledFragmentHandler.Action onLibraryExtendPosition(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.libraryExtendPosition.wrap(buffer, offset, blockLength, version);
        return this.handler.onLibraryExtendPosition(this.libraryExtendPosition.libraryId(), this.libraryExtendPosition.correlationId(), this.libraryExtendPosition.sessionId(), this.libraryExtendPosition.stopPosition(), this.libraryExtendPosition.initialTermId(), this.libraryExtendPosition.termBufferLength(), this.libraryExtendPosition.mtuLength());
    }

    private ControlledFragmentHandler.Action onControlNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.controlNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = this.controlNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onControlNotification(libraryId, this.controlNotification.initialAcceptedSessionOwner(), this.controlNotification.sessions());
    }

    private ControlledFragmentHandler.Action onSlowStatusNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.slowStatusNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = this.slowStatusNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onSlowStatusNotification(libraryId, this.slowStatusNotification.connectionId(), this.slowStatusNotification.status() == SlowStatus.SLOW);
    }

    private ControlledFragmentHandler.Action onResetLibrarySequenceNumber(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.resetLibrarySequenceNumber.wrap(buffer, offset, blockLength, version);
        int libraryId = this.resetLibrarySequenceNumber.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onResetLibrarySequenceNumber(libraryId, this.resetLibrarySequenceNumber.session());
    }

    private ControlledFragmentHandler.Action onFollowerSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.followerSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.followerSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onFollowerSessionReply(libraryId, this.followerSessionReply.replyToId(), this.followerSessionReply.session());
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        return this.handler.onApplicationHeartbeat(this.applicationHeartbeat.libraryId());
    }

    private ControlledFragmentHandler.Action onReleaseSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.releaseSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.releaseSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReleaseSessionReply(libraryId, this.releaseSessionReply.replyToId(), this.releaseSessionReply.status());
    }

    private ControlledFragmentHandler.Action onRequestSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.requestSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onRequestSessionReply(libraryId, this.requestSessionReply.replyToId(), this.requestSessionReply.status());
    }

    private ControlledFragmentHandler.Action onWriteMetaDataReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.writeMetaDataReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.writeMetaDataReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onWriteMetaDataReply(libraryId, this.writeMetaDataReply.replyToId(), this.writeMetaDataReply.status());
    }

    private ControlledFragmentHandler.Action onReadMetaDataReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.readMetaDataReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.readMetaDataReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReadMetaDataReply(libraryId, this.readMetaDataReply.replyToId(), this.readMetaDataReply.status(), buffer, offset + READ_META_DATA_META_DATA_PREFIX, this.readMetaDataReply.metaDataLength());
    }

    private ControlledFragmentHandler.Action onILinkConnect(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.iLinkConnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.iLinkConnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onILinkConnect(libraryId, this.iLinkConnect.correlationId(), this.iLinkConnect.connection(), this.iLinkConnect.uuid(), this.iLinkConnect.lastReceivedSequenceNumber(), this.iLinkConnect.lastSentSequenceNumber(), this.iLinkConnect.newlyAllocated() == Bool.TRUE, this.iLinkConnect.lastUuid());
    }

    private ControlledFragmentHandler.Action onReplayMessagesReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.replayMessagesReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.replayMessagesReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReplayMessagesReply(libraryId, this.replayMessagesReply.replyToId(), this.replayMessagesReply.status());
    }

    private ControlledFragmentHandler.Action onError(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.error.wrap(buffer, offset, blockLength, version);
        int libraryId = this.error.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onError(libraryId, this.error.errorType(), this.error.replyToId(), this.error.message());
    }

    private ControlledFragmentHandler.Action onManageSession(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.manageSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.manageSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onManageSession(libraryId, this.manageSession.connection(), this.manageSession.session(), this.manageSession.lastSentSequenceNumber(), this.manageSession.lastReceivedSequenceNumber(), this.manageSession.sessionStatus(), this.manageSession.slowStatus(), this.manageSession.connectionType(), this.manageSession.sessionState(), this.manageSession.heartbeatIntervalInS(), this.manageSession.closedResendInterval() == Bool.TRUE, this.manageSession.resendRequestChunkSize(), this.manageSession.sendRedundantResendRequests() == Bool.TRUE, this.manageSession.enableLastMsgSeqNumProcessed() == Bool.TRUE, this.manageSession.replyToId(), this.manageSession.sequenceIndex(), this.manageSession.awaitingResend() == AwaitingResend.YES, this.manageSession.lastResentMsgSeqNo(), this.manageSession.lastResendChunkMsgSeqNum(), this.manageSession.endOfResendRequestRange(), this.manageSession.awaitingHeartbeat() == Bool.TRUE, this.manageSession.logonReceivedSequenceNumber(), this.manageSession.logonSequenceIndex(), this.manageSession.lastLogonTime(), this.manageSession.lastSequenceResetTime(), this.manageSession.localCompId(), this.manageSession.localSubId(), this.manageSession.localLocationId(), this.manageSession.remoteCompId(), this.manageSession.remoteSubId(), this.manageSession.remoteLocationId(), this.manageSession.address(), this.manageSession.username(), this.manageSession.password(), FixDictionary.find((String)this.manageSession.fixDictionary()), this.manageSession.metaDataStatus(), buffer, this.manageSession.limit() + ManageSessionDecoder.metaDataHeaderLength(), this.manageSession.metaDataLength(), this.manageSession.cancelOnDisconnectOption(), this.manageSession.cancelOnDisconnectTimeoutInNs());
    }

    private ControlledFragmentHandler.Action onEndOfDay(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.endOfDay.wrap(buffer, offset, blockLength, version);
        int libraryId = this.endOfDay.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onEngineClose(libraryId);
    }

    private ControlledFragmentHandler.Action onReplayComplete(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.replayComplete.wrap(buffer, offset, blockLength, version);
        long connection = this.replayComplete.connection();
        int libraryId = this.replayComplete.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onReplayComplete(libraryId, connection);
    }

    private ControlledFragmentHandler.Action onInboundFixPConnect(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.inboundFixPConnect.wrap(buffer, offset, blockLength, version);
        int limit = this.inboundFixPConnect.limit();
        return this.handler.onInboundFixPConnect(this.inboundFixPConnect.connection(), this.inboundFixPConnect.sessionId(), this.inboundFixPConnect.protocolType(), buffer, limit, this.inboundFixPConnect.messageLength());
    }

    private ControlledFragmentHandler.Action onManageFixPConnection(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.manageFixPConnection.wrap(buffer, offset, blockLength, version);
        int limit = this.manageFixPConnection.limit();
        return this.handler.onManageFixPConnection(this.manageFixPConnection.libraryId(), this.manageFixPConnection.correlationId(), this.manageFixPConnection.connection(), this.manageFixPConnection.sessionId(), this.manageFixPConnection.protocolType(), this.manageFixPConnection.lastReceivedSequenceNumber(), this.manageFixPConnection.lastSentSequenceNumber(), this.manageFixPConnection.lastConnectPayload(), this.manageFixPConnection.offline() == Bool.TRUE, buffer, limit, this.manageFixPConnection.messageLength());
    }
}

