/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.exceptions.TimeoutException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPConnection;
import uk.co.real_logic.artio.fixp.FixPConnectionHandler;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.library.FixPSessionOwner;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;

public abstract class InternalFixPConnection
implements FixPConnection {
    protected final GatewayPublication outboundPublication;
    protected final GatewayPublication inboundPublication;
    protected final int libraryId;
    protected final EpochNanoClock clock;
    protected final FixPSessionOwner owner;
    protected final AbstractFixPProxy proxy;
    protected final FixPMessageDissector dissector;
    protected FixPConnection.State state;
    protected FixPConnectionHandler handler;
    protected LibraryReply<InternalFixPConnection> initiateReply;
    protected long connectionId;
    protected long requestedKeepAliveIntervalInMs;
    protected long nextSentSeqNo;
    protected long nextRecvSeqNo;
    protected long retransmitFillTimeoutInMs = -1L;
    protected long nextReceiveMessageTimeInMs;
    protected long nextSendMessageTimeInMs;

    protected InternalFixPConnection(long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, EpochNanoClock clock, FixPSessionOwner owner, AbstractFixPProxy proxy, FixPMessageDissector dissector) {
        this.connectionId = connectionId;
        this.outboundPublication = outboundPublication;
        this.inboundPublication = inboundPublication;
        this.libraryId = libraryId;
        this.clock = clock;
        this.owner = owner;
        this.proxy = proxy;
        this.dissector = dissector;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public long nextSentSeqNo() {
        return this.nextSentSeqNo;
    }

    public void nextSentSeqNo(long nextSentSeqNo) {
        this.nextSentSeqNo = nextSentSeqNo;
    }

    public long nextRecvSeqNo() {
        return this.nextRecvSeqNo;
    }

    public void nextRecvSeqNo(long nextRecvSeqNo) {
        this.nextRecvSeqNo = nextRecvSeqNo;
    }

    public long requestDisconnect(DisconnectReason reason) {
        return this.outboundPublication.saveRequestDisconnect(this.libraryId, this.connectionId, reason);
    }

    public boolean canSendMessage() {
        FixPConnection.State state = this.state;
        return state == FixPConnection.State.ESTABLISHED || state == FixPConnection.State.AWAITING_KEEPALIVE || state == FixPConnection.State.RECV_FINISHED_SENDING || state == FixPConnection.State.UNBOUND;
    }

    public FixPConnection.State state() {
        return this.state;
    }

    public long tryClaim(MessageEncoderFlyweight message) {
        return this.tryClaim(message, 0);
    }

    public long tryClaim(MessageEncoderFlyweight message, int variableLength) {
        this.validateCanSend();
        long timestamp = this.requestTimestampInNs();
        long position = this.proxy.claimMessage(message.sbeBlockLength() + variableLength, message, timestamp);
        if (position > 0L) {
            ++this.nextSentSeqNo;
        }
        return position;
    }

    public void commit() {
        this.proxy.commit();
        this.onAttemptedToSendMessage();
    }

    public void abort() {
        this.proxy.abort();
        --this.nextSentSeqNo;
    }

    protected void onReceivedMessage() {
        if (this.state == FixPConnection.State.AWAITING_KEEPALIVE) {
            this.state(FixPConnection.State.ESTABLISHED);
        }
        this.nextReceiveMessageTimeInMs = this.nextTimeoutInMs();
    }

    protected long nextTimeoutInMs() {
        return System.currentTimeMillis() + this.requestedKeepAliveIntervalInMs;
    }

    protected void onAttemptedToSendMessage() {
        this.nextSendMessageTimeInMs = this.nextTimeoutInMs();
    }

    protected long requestTimestampInNs() {
        return this.clock.nanoTime();
    }

    protected void validateCanSend() {
        if (!this.canSendMessage()) {
            throw new IllegalStateException("State should be ESTABLISHED or AWAITING_KEEPALIVE or RECV_FINISHED_SENDING in order to send but is " + this.state);
        }
    }

    protected void initiateReply(LibraryReply<?> initiateReply) {
        this.initiateReply = initiateReply;
    }

    protected void onNegotiateFailure() {
        this.onReplyError((Exception)new TimeoutException("Timed out: no reply for Negotiate"));
    }

    protected void onEstablishFailure() {
        this.onReplyError((Exception)new TimeoutException("Timed out: no reply for Establish"));
    }

    protected void onReplyError(Exception error) {
        this.initiateReply.onError(error);
        this.initiateReply = null;
    }

    protected int commonPoll(FixPConnection.State state, long timeInMs) {
        switch (state) {
            case ESTABLISHED: {
                return this.pollEstablished(timeInMs);
            }
            case AWAITING_KEEPALIVE: {
                return this.pollAwaitingKeepAlive(timeInMs);
            }
            case UNBINDING: {
                return this.pollUnbinding(timeInMs);
            }
        }
        return 0;
    }

    protected int pollAwaitingKeepAlive(long timeInMs) {
        if (timeInMs > this.nextReceiveMessageTimeInMs) {
            this.keepAliveExpiredTerminate();
            return 1;
        }
        return 0;
    }

    protected abstract void keepAliveExpiredTerminate();

    protected int pollUnbinding(long timeInMs) {
        if (timeInMs > this.nextSendMessageTimeInMs) {
            this.fullyUnbind();
        }
        return 0;
    }

    protected int pollEstablished(long timeInMs) {
        int events = this.pollExtraEstablished(timeInMs);
        if (timeInMs > this.nextReceiveMessageTimeInMs) {
            this.sendSequence(true);
            this.onReceivedMessage();
            this.state(FixPConnection.State.AWAITING_KEEPALIVE);
            ++events;
        } else if (timeInMs > this.nextSendMessageTimeInMs) {
            this.sendSequence(false);
            ++events;
        }
        return events;
    }

    protected abstract int pollExtraEstablished(long var1);

    protected abstract long sendSequence(boolean var1);

    protected void fullyUnbind() {
        this.fullyUnbind(DisconnectReason.LOGOUT);
    }

    protected void fullyUnbind(DisconnectReason reason) {
        this.requestDisconnect(reason);
        this.owner.remove(this);
        this.unbindState(DisconnectReason.APPLICATION_DISCONNECT);
    }

    protected void unbindState(DisconnectReason reason) {
        this.state(FixPConnection.State.UNBOUND);
        this.handler.onDisconnect((FixPConnection)this, reason);
        if (this.initiateReply != null) {
            this.onReplyError(new Exception("Unbound due to: " + reason));
        }
    }

    protected void state(FixPConnection.State state) {
        this.state = state;
    }

    public void handler(FixPConnectionHandler handler) {
        this.handler = handler;
    }

    protected abstract int poll(long var1);

    protected abstract void onReplayComplete();

    protected abstract void onOfflineReconnect(long var1, FixPContext var3);

    protected boolean onThrottleNotification(long refMsgType, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength) {
        throw new UnsupportedOperationException("throttling isn't supported for this Protocol type");
    }

    public abstract long startEndOfDay();
}

