/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import java.io.File;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.GatewayProcess;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.ilink.ILink3Connection;
import uk.co.real_logic.artio.ilink.ILink3ConnectionConfiguration;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryScheduler;
import uk.co.real_logic.artio.library.LibraryTransport;
import uk.co.real_logic.artio.library.MetadataHandler;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.MetaDataStatus;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.timing.LibraryTimers;

public class FixLibrary
extends GatewayProcess {
    public static final int NO_MESSAGE_REPLAY = -1;
    public static final int CURRENT_SEQUENCE = -2;
    private static final ThreadLocal<Boolean> RETHROW_EXCEPTION = ThreadLocal.withInitial(() -> true);
    private final LibraryConfiguration configuration;
    private final LibraryScheduler scheduler;
    private final LibraryPoller poller;
    private boolean isPolling = false;

    static void setClientConductorThread() {
        RETHROW_EXCEPTION.set(false);
    }

    FixLibrary(LibraryConfiguration configuration) {
        this.configuration = configuration;
        this.scheduler = configuration.scheduler();
        configuration.conclude();
        try {
            this.scheduler.configure(configuration.aeronContext());
            this.init(configuration);
            LibraryTimers timers = new LibraryTimers(configuration.epochNanoClock(), this.fixCounters.negativeTimestamps());
            this.initMonitoringAgent(timers.all(), configuration, null, null);
            LibraryTransport transport = new LibraryTransport(configuration, this.fixCounters, this.aeron);
            this.poller = new LibraryPoller(configuration, timers, this.fixCounters, transport, this, (EpochClock)new SystemEpochClock(), this.errorHandler);
        }
        catch (Exception e) {
            try {
                this.closeAnythingHoldingFileHandles();
                this.deleteFiles();
            }
            catch (Exception innerException) {
                innerException.addSuppressed(e);
                throw innerException;
            }
            throw e;
        }
    }

    private void closeAnythingHoldingFileHandles() {
        if (this.monitoringAgent == null) {
            this.monitoringFile.close();
        } else {
            this.monitoringAgent.onClose();
        }
    }

    private FixLibrary connect() {
        this.poller.startConnecting();
        this.scheduler.launch(this.configuration, this.errorHandler, this.monitoringAgent, this.conductorAgent());
        return this;
    }

    public static FixLibrary connect(LibraryConfiguration configuration) {
        return new FixLibrary(configuration).connect();
    }

    public int poll(int fragmentLimit) {
        this.isPolling = true;
        try {
            int n = this.poller.poll(fragmentLimit);
            return n;
        }
        finally {
            this.isPolling = false;
        }
    }

    public boolean isConnected() {
        return this.poller.isConnected();
    }

    public boolean isAtEndOfDay() {
        return this.poller.isAtEndOfDay();
    }

    public boolean isClosed() {
        return this.poller.isClosed();
    }

    public int libraryId() {
        return this.poller.libraryId();
    }

    public List<Session> sessions() {
        return this.poller.sessions();
    }

    public List<Session> pendingInitiatorSessions() {
        return this.poller.pendingInitiatorSessions();
    }

    @Override
    public void close() {
        if (this.isPolling) {
            throw new IllegalArgumentException("You cannot close the library in the middle of a poll");
        }
        this.internalClose();
    }

    void internalClose() {
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.poller, () -> this.scheduler.close(this.libraryId()), () -> super.close(), this::deleteFiles});
    }

    private void deleteFiles() {
        boolean deletedHistogramFile = this.removeParentDirectory(this.configuration.histogramLoggingFile());
        boolean deletedMonitoringFile = this.removeParentDirectory(this.configuration.monitoringFile());
        this.checkFileDeletion(deletedHistogramFile, this.configuration.histogramLoggingFile());
        this.checkFileDeletion(deletedMonitoringFile, this.configuration.monitoringFile());
    }

    private void checkFileDeletion(boolean deletedFile, String path) {
        if (!deletedFile) {
            throw new FixGatewayException("Unable to delete: " + path);
        }
    }

    private boolean removeParentDirectory(String path) {
        File file = new File(path);
        if (file.exists() && !file.delete()) {
            return false;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && parentFile.exists() && parentFile.listFiles().length == 0) {
            IoUtil.delete((File)parentFile, (boolean)true);
        }
        return true;
    }

    public Reply<Session> initiate(SessionConfiguration configuration) {
        return this.poller.initiate(configuration);
    }

    public Reply<SessionReplyStatus> releaseToGateway(Session session, long timeoutInMs) {
        CommonConfiguration.validateTimeout(timeoutInMs);
        return this.poller.releaseToGateway(session, timeoutInMs);
    }

    public Reply<SessionReplyStatus> requestSession(long sessionId, int resendFromSequenceNumber, int resendFromSequenceIndex, long timeoutInMs) {
        CommonConfiguration.validateTimeout(timeoutInMs);
        return this.poller.requestSession(sessionId, resendFromSequenceNumber, resendFromSequenceIndex, timeoutInMs);
    }

    public SessionWriter sessionWriter(long sessionId, long connectionId, int sequenceIndex) {
        return this.poller.sessionWriter(sessionId, connectionId, sequenceIndex);
    }

    public Reply<SessionWriter> followerSession(SessionHeaderEncoder headerEncoder, long timeoutInMs) {
        return this.poller.followerSession(headerEncoder, timeoutInMs);
    }

    public Reply<Long> followerFixPSession(FixPContext context, long testTimeoutInMs) {
        return this.poller.followerFixPSession(context, testTimeoutInMs);
    }

    public Reply<MetaDataStatus> writeMetaData(long sessionId, int metaDataUpdateOffset, DirectBuffer buffer, int offset, int length) {
        return this.poller.writeMetaData(sessionId, metaDataUpdateOffset, buffer, offset, length);
    }

    public void readMetaData(long sessionId, MetadataHandler handler) {
        this.poller.readMetaData(sessionId, handler);
    }

    public String currentAeronChannel() {
        return this.poller.currentAeronChannel();
    }

    public Reply<ILink3Connection> initiate(ILink3ConnectionConfiguration configuration) {
        return this.poller.initiate(configuration);
    }

    @Deprecated
    public List<ILink3Connection> iLink3Sessions() {
        return this.poller.iLink3Sessions();
    }

    public List<ILink3Connection> fixPConnections() {
        return this.poller.iLink3Sessions();
    }

    @Override
    protected boolean shouldRethrowExceptionInErrorHandler() {
        return RETHROW_EXCEPTION.get();
    }
}

