/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.fixp.FixPProtocol;
import uk.co.real_logic.artio.fixp.PrintingFixPMessageConsumer;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.FixPMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;

public abstract class AbstractFixPProxy {
    protected static final int ARTIO_HEADER_LENGTH = 32;
    protected final MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
    protected final FixPMessageEncoder fixPMessage = new FixPMessageEncoder();
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected final PrintingFixPMessageConsumer fixPMessageConsumer;
    protected final ExclusivePublication publication;
    protected long connectionId;
    protected long sessionId;

    protected AbstractFixPProxy(FixPProtocol protocol, FixPMessageDissector dissector, long connectionId, ExclusivePublication publication) {
        this.fixPMessageConsumer = new PrintingFixPMessageConsumer(-1, protocol, dissector);
        this.connectionId = connectionId;
        this.publication = publication;
    }

    public void ids(long connectionId, long sessionId) {
        this.connectionId = connectionId;
        this.sessionId = sessionId;
    }

    public abstract long sendSequence(long var1, long var3);

    public abstract long claimMessage(int var1, MessageEncoderFlyweight var2, long var3);

    public void commit() {
        BufferClaim bufferClaim = this.bufferClaim;
        if (FixPProtocol.BUSINESS_MESSAGE_LOGGING_ENABLED) {
            this.fixPMessageConsumer.onMessage(null, (DirectBuffer)bufferClaim.buffer(), bufferClaim.offset(), null);
        }
        bufferClaim.commit();
    }

    public void abort() {
        this.bufferClaim.abort();
    }

    protected long claimMessage(int messageLength, MessageEncoderFlyweight message, long timestamp, int totalHeaderLength, int protocolHeaderLength, short protocolType) {
        BufferClaim bufferClaim = this.bufferClaim;
        long position = this.publication.tryClaim(totalHeaderLength + messageLength, bufferClaim);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = bufferClaim.buffer();
        int offset = bufferClaim.offset();
        this.fixPMessage.wrapAndApplyHeader(buffer, bufferClaim.offset(), this.messageHeader).connection(this.connectionId).sessionId(this.sessionId).enqueueTime(timestamp);
        SimpleOpenFramingHeader.writeSofh((MutableDirectBuffer)buffer, (int)(offset += 32), (int)(protocolHeaderLength + messageLength), (short)protocolType);
        offset += 4;
        offset = this.applyHeader(message, buffer, offset);
        message.wrap(buffer, offset);
        return position;
    }

    protected abstract int applyHeader(MessageEncoderFlyweight var1, MutableDirectBuffer var2, int var3);

    public abstract ByteBuffer encodeReject(FixPContext var1, FixPFirstMessageResponse var2);

    public abstract byte[] encodeFirstMessage(FixPContext var1);
}

