/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.Verify;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.StreamTimestampZipper;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public class FixMessageLogger
implements Agent {
    private final StreamTimestampZipper zipper;
    private final Configuration configuration;
    private volatile boolean closed = false;

    public static void main(String[] args) {
        AgentRunner runner = FixMessageLogger.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((AgentRunner)runner).close()));
    }

    public static AgentRunner start() {
        Configuration configuration = new Configuration().fixMessageConsumer(FixMessageLogger::print);
        FixMessageLogger logger = new FixMessageLogger(configuration);
        AgentRunner runner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)logger);
        AgentRunner.startOnThread((AgentRunner)runner);
        return runner;
    }

    private static void print(FixMessageDecoder fixMessageDecoder, DirectBuffer buffer, int offset, int length, ArtioLogHeader header) {
        System.out.printf("%s:stream=%s %s%n", fixMessageDecoder.status(), header.streamId(), fixMessageDecoder.body());
    }

    @Deprecated
    public FixMessageLogger(FixMessageConsumer fixMessageConsumer, Aeron.Context context, String libraryAeronChannel, int inboundStreamId, int outboundStreamId, int outboundReplayStreamId) {
        this(new Configuration().fixMessageConsumer(fixMessageConsumer).context(context).libraryAeronChannel(libraryAeronChannel).inboundStreamId(inboundStreamId).outboundStreamId(outboundStreamId).outboundReplayStreamId(outboundReplayStreamId));
    }

    public FixMessageLogger(Configuration configuration) {
        configuration.conclude();
        this.configuration = configuration;
        Aeron aeron = configuration.aeron;
        SubscriptionPoller[] pollers = null;
        try {
            String libraryAeronChannel = configuration.libraryAeronChannel;
            pollers = new SubscriptionPoller[]{this.newSubscriptionPoller(aeron, libraryAeronChannel, configuration.inboundStreamId), this.newSubscriptionPoller(aeron, libraryAeronChannel, configuration.outboundStreamId), this.newSubscriptionPoller(aeron, "aeron:ipc", configuration.outboundReplayStreamId)};
        }
        catch (Throwable t) {
            if (configuration.ownsAeronClient) {
                aeron.close();
            }
            LangUtil.rethrowUnchecked((Throwable)t);
        }
        this.zipper = new StreamTimestampZipper(configuration.fixMessageConsumer, configuration.fixPMessageConsumer, configuration.compactionSize, pollers);
    }

    private SubscriptionPoller newSubscriptionPoller(Aeron aeron, String libraryAeronChannel, int streamId) {
        return new SubscriptionPoller(aeron.addSubscription(libraryAeronChannel, streamId));
    }

    public int doWork() {
        return this.zipper.poll();
    }

    public void onClose() {
        if (!this.closed) {
            this.closed = true;
            if (this.zipper != null) {
                this.zipper.onClose();
            }
            if (this.configuration.ownsAeronClient) {
                this.configuration.aeron.close();
            }
        }
    }

    public String roleName() {
        return "FixMessageLogger";
    }

    int bufferPosition() {
        return this.zipper.bufferPosition();
    }

    int bufferCapacity() {
        return this.zipper.bufferCapacity();
    }

    private static final class SubscriptionPoller
    implements StreamTimestampZipper.Poller {
        private final Subscription subscription;

        private SubscriptionPoller(Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public int poll(FragmentAssembler fragmentAssembler) {
            return this.subscription.poll((FragmentHandler)fragmentAssembler, 10);
        }

        @Override
        public int streamId() {
            return this.subscription.streamId();
        }

        @Override
        public void close() {
            this.subscription.close();
        }
    }

    public static class Configuration {
        public static final int DEFAULT_COMPACTION_SIZE = 65536;
        private FixMessageConsumer fixMessageConsumer;
        private Aeron.Context context;
        private boolean ownsAeronClient;
        private Aeron aeron;
        private String libraryAeronChannel = "aeron:ipc";
        private int inboundStreamId = 1;
        private int outboundStreamId = 2;
        private int outboundReplayStreamId = 3;
        private int compactionSize = 65536;
        private FixPMessageConsumer fixPMessageConsumer;

        public Configuration fixMessageConsumer(FixMessageConsumer fixMessageConsumer) {
            this.fixMessageConsumer = fixMessageConsumer;
            return this;
        }

        @Deprecated
        public Configuration iLinkMessageConsumer(ILinkMessageConsumer iLinkMessageConsumer) {
            return this.fixPMessageConsumer((FixPMessageConsumer)iLinkMessageConsumer);
        }

        public Configuration fixPMessageConsumer(FixPMessageConsumer fixPMessageConsumer) {
            this.fixPMessageConsumer = fixPMessageConsumer;
            return this;
        }

        public Configuration context(Aeron.Context context) {
            Verify.notNull((Object)context, (String)"context");
            this.ownsAeronClient(true);
            this.context = context;
            return this;
        }

        public Configuration aeron(Aeron aeron) {
            Verify.notNull((Object)aeron, (String)"aeron");
            this.aeron = aeron;
            return this;
        }

        public Configuration ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public Configuration libraryAeronChannel(String libraryAeronChannel) {
            Verify.notNull((Object)libraryAeronChannel, (String)"libraryAeronChannel");
            this.libraryAeronChannel = libraryAeronChannel;
            return this;
        }

        public Configuration inboundStreamId(int inboundStreamId) {
            this.inboundStreamId = inboundStreamId;
            return this;
        }

        public Configuration outboundStreamId(int outboundStreamId) {
            this.outboundStreamId = outboundStreamId;
            return this;
        }

        public Configuration outboundReplayStreamId(int outboundReplayStreamId) {
            this.outboundReplayStreamId = outboundReplayStreamId;
            return this;
        }

        public Configuration compactionSize(int compactionSize) {
            if (compactionSize <= 0) {
                throw new IllegalArgumentException("Compaction size must be positive, but is: " + compactionSize);
            }
            this.compactionSize = compactionSize;
            return this;
        }

        void conclude() {
            Verify.notNull((Object)this.fixMessageConsumer, (String)"fixMessageConsumer");
            if (this.aeron == null) {
                if (this.context == null) {
                    this.context(new Aeron.Context());
                }
                this.aeron = Aeron.connect((Aeron.Context)this.context);
            }
        }
    }
}

