/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.validation.AbstractAuthenticationProxy;

abstract class GatewaySessions {
    protected final CharFormatter acquiredConnection = new CharFormatter("Gateway Acquired Connection %s");
    protected final List<GatewaySession> sessions = new ArrayList<GatewaySession>();
    protected final EpochClock epochClock;
    protected final GatewayPublication inboundPublication;
    protected final GatewayPublication outboundPublication;
    protected final SequenceNumberIndexReader sentSequenceNumberIndex;
    protected final SequenceNumberIndexReader receivedSequenceNumberIndex;
    protected ErrorHandler errorHandler;

    GatewaySessions(EpochClock epochClock, GatewayPublication inboundPublication, GatewayPublication outboundPublication, ErrorHandler errorHandler, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex) {
        this.epochClock = epochClock;
        this.inboundPublication = inboundPublication;
        this.outboundPublication = outboundPublication;
        this.errorHandler = errorHandler;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
    }

    static GatewaySession removeSessionByConnectionId(long connectionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            sessions.remove(i);
            return session;
        }
        return null;
    }

    GatewaySession releaseBySessionId(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.remove(index);
    }

    GatewaySession sessionById(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.get(index);
    }

    private int indexBySessionId(long sessionId) {
        List<GatewaySession> sessions = this.sessions;
        return GatewaySessions.indexBySessionId(sessionId, sessions);
    }

    static int indexBySessionId(long sessionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.sessionId() != sessionId) continue;
            return i;
        }
        return -1;
    }

    void releaseByConnectionId(long connectionId) {
        GatewaySession session = GatewaySessions.removeSessionByConnectionId(connectionId, this.sessions);
        if (session != null) {
            session.onDisconnectReleasedByOwner();
            session.close();
        }
    }

    int pollSessions(long timeInMs, long timeInNs) {
        List<GatewaySession> sessions = this.sessions;
        int eventsProcessed = 0;
        int i = 0;
        int size = sessions.size();
        while (i < size) {
            GatewaySession session = sessions.get(i);
            eventsProcessed += session.poll(timeInMs, timeInNs);
            if (session.hasDisconnected()) {
                --size;
                continue;
            }
            ++i;
        }
        return eventsProcessed;
    }

    List<GatewaySession> sessions() {
        return this.sessions;
    }

    private boolean lookupSequenceNumbers(GatewaySession gatewaySession, long requiredPosition) {
        long indexedPosition;
        int aeronSessionId = this.outboundPublication.sessionId();
        long initialPosition = this.outboundPublication.initialPosition();
        if (requiredPosition > initialPosition && (indexedPosition = this.sentSequenceNumberIndex.indexedPosition(aeronSessionId)) < requiredPosition) {
            return false;
        }
        long sessionId = gatewaySession.sessionId();
        int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        gatewaySession.acceptorSequenceNumbers(lastSentSequenceNumber, lastReceivedSequenceNumber);
        if (lastReceivedSequenceNumber != -1) {
            this.setLastSequenceResetTime(gatewaySession);
        }
        return true;
    }

    protected abstract void setLastSequenceResetTime(GatewaySession var1);

    void track(GatewaySession gatewaySession) {
        this.sessions.add(gatewaySession);
    }

    protected abstract class PendingAcceptorLogon
    implements AbstractAuthenticationProxy,
    AcceptorLogonResult {
        private static final long NO_REQUIRED_POSITION = -1L;
        protected final long connectionId;
        protected final TcpChannel channel;
        protected final Framer framer;
        protected volatile AuthenticationState state = AuthenticationState.PENDING;
        protected GatewaySession session;
        protected DisconnectReason reason;
        protected long requiredPosition = -1L;
        protected long lingerTimeoutInMs;
        protected long lingerExpiryTimeInMs;
        protected ByteBuffer rejectEncodeBuffer;

        PendingAcceptorLogon(GatewaySession gatewaySession, long connectionId, TcpChannel channel, Framer framer) {
            this.session = gatewaySession;
            this.connectionId = connectionId;
            this.channel = channel;
            this.framer = framer;
        }

        protected void onStrategyError(String strategyName, Throwable throwable, long connectionId, String theDefault, String messageForError) {
            String message = String.format("Exception thrown by %s strategy for connectionId=%d, processing [%s], defaulted to %s", strategyName, connectionId, messageForError, theDefault);
            this.onError(new FixGatewayException(message, throwable));
        }

        protected void onError(Throwable throwable) {
            if (GatewaySessions.this.errorHandler == null) {
                LangUtil.rethrowUnchecked((Throwable)throwable);
            } else {
                GatewaySessions.this.errorHandler.onError(throwable);
            }
        }

        @Override
        public DisconnectReason reason() {
            return this.reason;
        }

        @Override
        public void accept() {
            this.validateState();
            this.state = AuthenticationState.AUTHENTICATED;
        }

        protected void validateState() {
            AuthenticationState state = this.state;
            if (state != AuthenticationState.PENDING && state != AuthenticationState.AUTHENTICATED) {
                throw new IllegalStateException(String.format("Cannot reject and accept a pending operation at the same time (state=%s)", new Object[]{state}));
            }
        }

        @Override
        public boolean poll() {
            switch (this.state) {
                case AUTHENTICATED: {
                    this.session.onAuthenticationResult();
                    this.onAuthenticated();
                    return false;
                }
                case ACCEPTED: {
                    return true;
                }
                case REJECTED: {
                    this.checkedOnAuthenticationResult();
                    return true;
                }
                case SENDING_REJECT_MESSAGE: {
                    this.checkedOnAuthenticationResult();
                    return this.onSendingRejectMessage();
                }
                case LINGERING_REJECT_MESSAGE: {
                    return this.onLingerRejectMessage();
                }
                case INDEXER_CATCHUP: {
                    this.onIndexerCatchup();
                    return false;
                }
            }
            return false;
        }

        protected abstract void onAuthenticated();

        private void checkedOnAuthenticationResult() {
            if (this.session != null) {
                this.session.onAuthenticationResult();
                this.session = null;
            }
        }

        private boolean onLingerRejectMessage() {
            boolean complete;
            long timeInMs = GatewaySessions.this.epochClock.time();
            boolean bl = complete = timeInMs >= this.lingerExpiryTimeInMs;
            if (complete) {
                this.state = AuthenticationState.REJECTED;
            }
            return complete;
        }

        private boolean onSendingRejectMessage() {
            if (this.rejectEncodeBuffer == null) {
                try {
                    this.encodeRejectMessage();
                }
                catch (Exception e) {
                    GatewaySessions.this.errorHandler.onError((Throwable)e);
                    this.state = AuthenticationState.REJECTED;
                    return true;
                }
            }
            try {
                this.channel.write(this.rejectEncodeBuffer);
                if (!this.rejectEncodeBuffer.hasRemaining()) {
                    this.lingerExpiryTimeInMs = GatewaySessions.this.epochClock.time() + this.lingerTimeoutInMs;
                    this.state = AuthenticationState.LINGERING_REJECT_MESSAGE;
                }
            }
            catch (IOException e) {
                this.state = AuthenticationState.REJECTED;
                return true;
            }
            return false;
        }

        protected abstract void encodeRejectMessage();

        private void onIndexerCatchup() {
            if (GatewaySessions.this.lookupSequenceNumbers(this.session, this.requiredPosition)) {
                this.state = AuthenticationState.ACCEPTED;
            }
        }

        @Override
        public abstract void reject();

        @Override
        public String remoteAddress() {
            return this.channel.remoteAddr();
        }

        protected void reject(DisconnectReason reason) {
            this.validateState();
            this.reason = reason;
            this.state = AuthenticationState.REJECTED;
        }

        @Override
        public boolean isAccepted() {
            return AuthenticationState.ACCEPTED == this.state;
        }

        @Override
        public long connectionId() {
            return this.connectionId;
        }
    }

    static enum AuthenticationState {
        PENDING,
        AUTHENTICATED,
        INDEXER_CATCHUP,
        ACCEPTED,
        SENDING_REJECT_MESSAGE,
        LINGERING_REJECT_MESSAGE,
        REJECTED;

    }
}

