/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.FixPContexts;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySession;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.InboundFixPConnectEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.FixPAuthenticationProxy;

public class FixPGatewaySessions
extends GatewaySessions {
    static final int ACCEPTED_HEADER_LENGTH = 28;
    private final EngineConfiguration engineConfiguration;
    private final FixPContexts fixPContexts;

    FixPGatewaySessions(EpochClock epochClock, GatewayPublication inboundPublication, GatewayPublication outboundPublication, ErrorHandler errorHandler, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex, EngineConfiguration engineConfiguration, FixPContexts fixPContexts) {
        super(epochClock, inboundPublication, outboundPublication, errorHandler, sentSequenceNumberIndex, receivedSequenceNumberIndex);
        this.engineConfiguration = engineConfiguration;
        this.fixPContexts = fixPContexts;
    }

    @Override
    protected void setLastSequenceResetTime(GatewaySession gatewaySession) {
    }

    public AcceptorLogonResult authenticate(long sessionId, MutableAsciiBuffer buffer, int offset, int messageSize, FixPGatewaySession gatewaySession, long connectionId, TcpChannel channel, Framer framer, FixPProtocolType protocolType, FixPContext identification, AbstractFixPProxy fixPProxy) {
        return new FixPPendingAcceptorLogon(sessionId, buffer, offset, messageSize, gatewaySession, connectionId, channel, framer, protocolType, identification, fixPProxy);
    }

    public FixPContexts fixPContexts() {
        return this.fixPContexts;
    }

    class FixPPendingAcceptorLogon
    extends GatewaySessions.PendingAcceptorLogon
    implements FixPAuthenticationProxy {
        public static final int LINGER_TIMEOUT_IN_MS = 500;
        private final long sessionId;
        private final MutableAsciiBuffer buffer;
        private final int offset;
        private final int messageSize;
        private final FixPProtocolType protocolType;
        private final FixPContext identification;
        private final AbstractFixPProxy fixPProxy;
        private FixPFirstMessageResponse fixPFirstMessageResponse;

        FixPPendingAcceptorLogon(long sessionId, MutableAsciiBuffer buffer, int offset, int messageSize, FixPGatewaySession gatewaySession, long connectionId, TcpChannel channel, Framer framer, FixPProtocolType protocolType, FixPContext identification, AbstractFixPProxy fixPProxy) {
            super(FixPGatewaySessions.this, gatewaySession, connectionId, channel, framer);
            this.sessionId = sessionId;
            this.buffer = buffer;
            this.offset = offset;
            this.messageSize = messageSize;
            this.protocolType = protocolType;
            this.identification = identification;
            this.fixPProxy = fixPProxy;
            FixPFirstMessageResponse rejectReason = FixPGatewaySessions.this.fixPContexts.onAcceptorLogon(sessionId, identification, connectionId);
            if (rejectReason == FixPFirstMessageResponse.OK) {
                this.authenticate(connectionId);
            } else {
                this.reject(rejectReason);
            }
        }

        protected void authenticate(long connectionId) {
            block2: {
                try {
                    FixPGatewaySessions.this.engineConfiguration.fixPAuthenticationStrategy().authenticate(this.identification, this);
                }
                catch (Throwable throwable) {
                    this.onStrategyError("authentication", throwable, connectionId, "false", this.identification.toString());
                    if (this.state == GatewaySessions.AuthenticationState.REJECTED) break block2;
                    this.reject();
                }
            }
        }

        @Override
        protected void onAuthenticated() {
            FixPGatewaySession session = (FixPGatewaySession)this.session;
            session.authenticated();
            if (this.framer.onFixPLogonMessageReceived(session, this.sessionId)) {
                this.state = GatewaySessions.AuthenticationState.ACCEPTED;
            } else {
                MessageHeaderEncoder header = new MessageHeaderEncoder();
                InboundFixPConnectEncoder inboundFixPConnect = new InboundFixPConnectEncoder();
                UnsafeBuffer logonBuffer = new UnsafeBuffer(new byte[28]);
                inboundFixPConnect.wrapAndApplyHeader((MutableDirectBuffer)logonBuffer, 0, header).connection(this.connectionId).sessionId(this.sessionId).protocolType(this.protocolType).messageLength(this.messageSize);
                long position = FixPGatewaySessions.this.inboundPublication.dataPublication().offer((DirectBuffer)logonBuffer, 0, 28, (DirectBuffer)this.buffer, this.offset, this.messageSize);
                if (position < 0L) {
                    System.out.println("position = " + position);
                } else {
                    this.state = GatewaySessions.AuthenticationState.ACCEPTED;
                }
            }
        }

        @Override
        protected void encodeRejectMessage() {
            this.rejectEncodeBuffer = this.fixPProxy.encodeReject(this.identification, this.fixPFirstMessageResponse);
        }

        @Override
        public void reject() {
            this.reject(FixPFirstMessageResponse.CREDENTIALS);
        }

        private void reject(FixPFirstMessageResponse response) {
            this.reason = DisconnectReason.FAILED_AUTHENTICATION;
            this.fixPFirstMessageResponse = response;
            this.lingerTimeoutInMs = 500L;
            this.state = GatewaySessions.AuthenticationState.SENDING_REJECT_MESSAGE;
        }
    }
}

