/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.engine.FixPConnectedSessionInfo;
import uk.co.real_logic.artio.engine.framer.AcceptorFixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySessions;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPKey;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class FixPGatewaySession
extends GatewaySession
implements FixPConnectedSessionInfo {
    private final FixPProtocolType protocolType;
    private final AbstractFixPParser parser;
    private final AbstractFixPProxy fixPProxy;
    private final AcceptorFixPReceiverEndPoint receiverEndPoint;
    private final FixPSenderEndPoint senderEndPoint;
    private final FixPGatewaySessions gatewaySessions;
    private byte[] firstMessage;
    private FixPContext context;

    FixPGatewaySession(long connectionId, long sessionId, String address, ConnectionType connectionType, long authenticationTimeoutInMs, FixPProtocolType protocolType, AbstractFixPParser parser, AbstractFixPProxy fixPProxy, AcceptorFixPReceiverEndPoint receiverEndPoint, FixPSenderEndPoint senderEndPoint, FixPGatewaySessions gatewaySessions) {
        super(connectionId, sessionId, address, connectionType, authenticationTimeoutInMs, receiverEndPoint);
        this.protocolType = protocolType;
        this.parser = parser;
        this.fixPProxy = fixPProxy;
        this.receiverEndPoint = receiverEndPoint;
        this.senderEndPoint = senderEndPoint;
        this.gatewaySessions = gatewaySessions;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    int poll(long timeInMs, long timeInNs) {
        return this.checkNoLogonDisconnect(timeInMs);
    }

    @Override
    long lastLogonTime() {
        return 0L;
    }

    @Override
    void acceptorSequenceNumbers(int lastSentSequenceNumber, int lastReceivedSequenceNumber) {
    }

    public AcceptorLogonResult onLogon(MutableAsciiBuffer buffer, int offset, int messageSize, TcpChannel channel, Framer framer) {
        this.firstMessage = new byte[messageSize];
        buffer.getBytes(offset, this.firstMessage, 0, messageSize);
        this.sessionId = this.parser.sessionId((DirectBuffer)buffer, offset);
        this.receiverEndPoint.sessionId(this.sessionId);
        this.context = this.parser.lookupContext((DirectBuffer)buffer, offset, messageSize);
        this.startAuthentication(System.currentTimeMillis());
        return this.gatewaySessions.authenticate(this.sessionId, buffer, offset, messageSize, this, this.connectionId, channel, framer, this.protocolType, this.context, this.fixPProxy);
    }

    void setupOfflineSession(FixPContext context, byte[] firstMessage, int libraryId) {
        this.context = context;
        this.firstMessage = firstMessage;
        this.libraryId(libraryId);
    }

    public FixPProtocolType protocolType() {
        return this.protocolType;
    }

    public byte[] firstMessage() {
        return this.firstMessage;
    }

    public void setManagementTo(int libraryId) {
        this.libraryId(libraryId);
        this.receiverEndPoint.libraryId(libraryId);
        this.senderEndPoint.libraryId(libraryId);
    }

    public void authenticated() {
        this.receiverEndPoint.authenticated();
    }

    @Override
    public void onDisconnectReleasedByOwner() {
    }

    public void onEndSequence() {
        this.context.onEndSequence();
        this.gatewaySessions.fixPContexts().updateContext(this.context);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "FixPGatewaySession{protocolType=" + this.protocolType + ", connectionType=" + this.connectionType + ", sessionId=" + this.sessionId + ", connectionId=" + this.connectionId + ", address='" + this.address + '\'' + ", libraryId=" + this.libraryId + '}';
    }

    @Override
    public FixPKey key() {
        return this.context.key();
    }

    @Override
    public boolean configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        this.receiverEndPoint.configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
        return true;
    }

    @Override
    public long startEndOfDay() {
        if (this.receiverEndPoint != null) {
            this.receiverEndPoint.completeDisconnect(DisconnectReason.ENGINE_SHUTDOWN);
        }
        return 1L;
    }
}

