/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.ConnectedSessionInfo;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.ThrottleConfigurationStatus;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.FixSessionOwner;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.util.AsciiBuffer;

class FixGatewaySession
extends GatewaySession
implements ConnectedSessionInfo,
FixSessionOwner {
    private final boolean closedResendInterval;
    private final int resendRequestChunkSize;
    private final boolean sendRedundantResendRequests;
    private final boolean enableLastMsgSeqNumProcessed;
    private final EngineConfiguration configuration;
    private FixDictionary fixDictionary;
    private FixReceiverEndPoint receiverEndPoint;
    private FixSenderEndPoint senderEndPoint;
    private SessionContext context;
    private SessionParser sessionParser;
    private InternalSession session;
    private DirectSessionProxy proxy;
    private CompositeKey sessionKey;
    private String username;
    private String password;
    private int heartbeatIntervalInS;
    private Consumer<FixGatewaySession> onGatewaySessionLogon;
    private boolean initialResetSeqNum;
    private int logonReceivedSequenceNumber;
    private int logonSequenceIndex;
    private long lastSequenceResetTime = -1L;
    private long lastLogonTime = -1L;
    private CancelOnDisconnectOption cancelOnDisconnectOption;
    private long cancelOnDisconnectTimeoutWindowInNs;

    FixGatewaySession(long connectionId, SessionContext context, String address, ConnectionType connectionType, CompositeKey sessionKey, FixReceiverEndPoint receiverEndPoint, FixSenderEndPoint senderEndPoint, Consumer<FixGatewaySession> onGatewaySessionLogon, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, EngineConfiguration configuration) {
        super(connectionId, context.sessionId(), address, connectionType, configuration.authenticationTimeoutInMs(), receiverEndPoint);
        this.context = context;
        this.sessionKey = sessionKey;
        this.receiverEndPoint = receiverEndPoint;
        this.senderEndPoint = senderEndPoint;
        this.onGatewaySessionLogon = onGatewaySessionLogon;
        this.closedResendInterval = closedResendInterval;
        this.resendRequestChunkSize = resendRequestChunkSize;
        this.sendRedundantResendRequests = sendRedundantResendRequests;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        this.configuration = configuration;
        this.fixDictionary(fixDictionary);
    }

    @Override
    public String address() {
        if (this.receiverEndPoint != null) {
            return this.receiverEndPoint.address();
        }
        return this.address;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.sessionKey;
    }

    void manage(SessionParser sessionParser, InternalSession session, BlockablePosition blockablePosition, DirectSessionProxy proxy) {
        this.sessionParser = sessionParser;
        this.session = session;
        this.proxy = proxy;
        this.session.sessionProcessHandler(this);
        if (this.receiverEndPoint != null) {
            this.receiverEndPoint.libraryId(0);
            this.senderEndPoint.libraryId(0, blockablePosition);
        }
    }

    void handoverManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.setManagementTo(libraryId, blockablePosition);
        this.sessionParser = null;
        this.context.updateAndSaveFrom(this.session);
        this.session.close();
        this.session = null;
        this.proxy = null;
    }

    void setManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.libraryId(libraryId);
        if (this.receiverEndPoint != null) {
            this.receiverEndPoint.libraryId(libraryId);
            this.receiverEndPoint.pause();
            this.senderEndPoint.libraryId(libraryId, blockablePosition);
        }
    }

    void play() {
        if (this.receiverEndPoint != null) {
            this.receiverEndPoint.play();
        }
    }

    @Override
    int poll(long timeInMs, long timeInNs) {
        int events = this.session != null ? this.session.poll(timeInNs) : 0;
        return events + this.checkNoLogonDisconnect(timeInMs);
    }

    @Override
    public void onLogon(Session session) {
        this.context.updateFrom(session);
        this.onGatewaySessionLogon.accept(this);
    }

    @Override
    public Reply<ReplayMessagesStatus> replayReceivedMessages(long sessionId, int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long timeout) {
        return (Reply)this.unsupported();
    }

    @Override
    public void enqueueTask(BooleanSupplier task) {
        this.unsupported();
    }

    @Override
    public Reply<ThrottleConfigurationStatus> messageThrottle(long sessionId, int throttleWindowInMs, int throttleLimitOfMessages) {
        return (Reply)this.unsupported();
    }

    private <T> T unsupported() {
        throw new UnsupportedOperationException("Should never be invoked inside the Engine.");
    }

    InternalSession session() {
        return this.session;
    }

    public void onMessage(DirectBuffer buffer, int offset, int length, long messageType, long position) {
        if (this.sessionParser != null) {
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Gateway Received ", buffer, offset, length);
            this.session.messageInfo().isValid(true);
            this.sessionParser.onMessage(buffer, offset, length, messageType, position);
        }
    }

    void onLogon(String username, String password, int heartbeatIntervalInS) {
        this.username = username;
        this.password = password;
        this.heartbeatIntervalInS = heartbeatIntervalInS;
        if (this.session != null) {
            this.session.setupSession(this.sessionId, this.sessionKey, null);
            this.sessionParser.sessionKey(this.sessionKey);
            this.sessionParser.sequenceIndex(this.context.sequenceIndex());
            DebugLogger.log(LogTag.GATEWAY_MESSAGE, "Setup Session As: ", this.sessionKey.localCompId());
        }
        if (this.senderEndPoint != null) {
            this.senderEndPoint.sessionId(this.sessionId);
        }
    }

    public void onLogon(long sessionId, SessionContext context, CompositeKey sessionKey, String username, String password, int heartbeatIntervalInS, int logonReceivedSequenceNumber, CancelOnDisconnectOption cancelOnDisconnectOption, long cancelOnDisconnectTimeoutWindowInNs) {
        this.sessionId = sessionId;
        this.context = context;
        this.sessionKey = sessionKey;
        this.logonReceivedSequenceNumber = logonReceivedSequenceNumber;
        this.logonSequenceIndex = context.sequenceIndex();
        this.cancelOnDisconnectOption = cancelOnDisconnectOption;
        this.cancelOnDisconnectTimeoutWindowInNs = cancelOnDisconnectTimeoutWindowInNs;
        this.senderEndPoint.onLogon(sessionKey, this.configuration);
        this.onLogon(username, password, heartbeatIntervalInS);
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    int heartbeatIntervalInS() {
        return this.heartbeatIntervalInS;
    }

    @Override
    void acceptorSequenceNumbers(int retrievedSentSequenceNumber, int retrievedReceivedSequenceNumber) {
        if (this.session != null) {
            this.session.lastSentMsgSeqNum(FixGatewaySession.adjustLastSequenceNumber(retrievedSentSequenceNumber));
            int lastReceivedMsgSeqNum = FixGatewaySession.adjustLastSequenceNumber(retrievedReceivedSequenceNumber);
            this.session.initialLastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
        }
    }

    void lastLogonWasSequenceReset() {
        this.lastSequenceResetTime(this.lastLogonTime);
    }

    static int adjustLastSequenceNumber(int lastSequenceNumber) {
        return lastSequenceNumber == -1 ? 0 : lastSequenceNumber;
    }

    public String toString() {
        return "GatewaySession{sessionId=" + this.sessionId + ", sessionKey=" + this.sessionKey + '}';
    }

    @Override
    public long bytesInBuffer() {
        return this.senderEndPoint.bytesInBuffer();
    }

    @Override
    void close() {
        CloseHelper.close((AutoCloseable)this.session);
    }

    @Override
    public int sequenceIndex() {
        return this.context.sequenceIndex();
    }

    SlowStatus slowStatus() {
        if (this.isOffline()) {
            return SlowStatus.NOT_SLOW;
        }
        return this.senderEndPoint.isSlowConsumer() ? SlowStatus.SLOW : SlowStatus.NOT_SLOW;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public boolean enableLastMsgSeqNumProcessed() {
        return this.enableLastMsgSeqNumProcessed;
    }

    public SessionContext context() {
        return this.context;
    }

    void initialResetSeqNum(boolean resetSeqNum) {
        this.initialResetSeqNum = resetSeqNum;
    }

    boolean initialResetSeqNum() {
        return this.initialResetSeqNum;
    }

    FixDictionary fixDictionary() {
        return this.fixDictionary;
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
        if (this.senderEndPoint != null) {
            this.senderEndPoint.fixDictionary(fixDictionary);
        }
    }

    public int logonReceivedSequenceNumber() {
        return this.logonReceivedSequenceNumber;
    }

    public int logonSequenceIndex() {
        return this.logonSequenceIndex;
    }

    public CancelOnDisconnectOption cancelOnDisconnectOption() {
        return this.cancelOnDisconnectOption == null ? CancelOnDisconnectOption.DO_NOT_CANCEL_ON_DISCONNECT_OR_LOGOUT : this.cancelOnDisconnectOption;
    }

    public long cancelOnDisconnectTimeoutWindowInNs() {
        return this.cancelOnDisconnectTimeoutWindowInNs;
    }

    void updateSessionDictionary() {
        if (this.session != null) {
            this.session.fixDictionary(this.fixDictionary);
            this.sessionParser.fixDictionary(this.fixDictionary);
        }
    }

    long lastSequenceResetTime() {
        return this.lastSequenceResetTime;
    }

    void lastSequenceResetTime(long lastSequenceResetTime) {
        this.lastSequenceResetTime = lastSequenceResetTime;
        if (this.session != null) {
            this.session.lastSequenceResetTimeInNs(lastSequenceResetTime);
        }
    }

    @Override
    long lastLogonTime() {
        return this.lastLogonTime;
    }

    void lastLogonTime(long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
        if (this.session != null) {
            this.session.lastLogonTimeInNs(lastLogonTime);
        }
    }

    public void goOffline() {
        this.connectionId = -1L;
        this.address = ":-1";
        ((GatewaySession)this).receiverEndPoint = null;
        this.receiverEndPoint = null;
        this.senderEndPoint = null;
        this.onGatewaySessionLogon = null;
    }

    public long lastSentPosition() {
        return this.proxy.lastSentPosition();
    }

    @Override
    public void onDisconnectReleasedByOwner() {
        if (this.session != null) {
            this.session.onDisconnect();
        }
    }

    public boolean onThrottleNotification(long messageType, int refSeqNum, AsciiBuffer refIdBuffer, int refIdOffset, int refIdLength) {
        if (this.session != null) {
            return this.session.onThrottleNotification(messageType, refSeqNum, (DirectBuffer)refIdBuffer, refIdOffset, refIdLength);
        }
        return true;
    }

    @Override
    public boolean configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        boolean ok = this.senderEndPoint.configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
        if (ok) {
            this.receiverEndPoint.configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
        }
        return ok;
    }

    public void onSequenceReset(long resetTimeInNs) {
        this.context.onSequenceReset(resetTimeInNs);
    }

    @Override
    public long startEndOfDay() {
        InternalSession session = this.session;
        if (session != null) {
            SessionState state = session.state();
            switch (state) {
                case SENT_LOGON: 
                case ACTIVE: 
                case AWAITING_LOGOUT: 
                case LOGGING_OUT_AND_DISCONNECTING: 
                case LOGGING_OUT: {
                    long position = session.logoutAndDisconnect(DisconnectReason.ENGINE_SHUTDOWN);
                    if (position >= 0L) break;
                    return position;
                }
                case CONNECTED: 
                case CONNECTING: 
                case DISCONNECTING: {
                    long position = session.requestDisconnect(DisconnectReason.ENGINE_SHUTDOWN);
                    if (position >= 0L) break;
                    return position;
                }
            }
        }
        return 1L;
    }
}

