/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.storage.messages.EngineInformationDecoder;
import uk.co.real_logic.artio.storage.messages.EngineInformationEncoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;

public class DuplicateEngineChecker
implements Agent {
    static final String FILE_NAME = "engine-info";
    private final EngineInformationEncoder engineInformation = new EngineInformationEncoder();
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    private final long duplicateEngineTimeoutInMs;
    private final File file;
    private final String logFileDir;
    private final boolean errorIfDuplicateEngineDetected;
    private MappedByteBuffer mappedByteBuffer;
    private long nextDeadlineInMs;

    public DuplicateEngineChecker(long duplicateEngineTimeoutInMs, String logFileDir, boolean errorIfDuplicateEngineDetected) {
        this.duplicateEngineTimeoutInMs = duplicateEngineTimeoutInMs;
        this.file = new File(logFileDir, FILE_NAME);
        this.logFileDir = logFileDir;
        this.errorIfDuplicateEngineDetected = errorIfDuplicateEngineDetected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        if (this.file.exists()) {
            this.mappedByteBuffer = IoUtil.mapExistingFile((File)this.file, (String)FILE_NAME);
            try {
                this.buffer.wrap((ByteBuffer)this.mappedByteBuffer);
                MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
                EngineInformationDecoder engineInformationDecoder = new EngineInformationDecoder();
                messageHeaderDecoder.wrap((DirectBuffer)this.buffer, 0);
                engineInformationDecoder.wrap((DirectBuffer)this.buffer, 8, messageHeaderDecoder.blockLength(), messageHeaderDecoder.version());
                long heartbeatTimeInMs = engineInformationDecoder.heartbeatTimeInMs();
                String otherRuntimeName = engineInformationDecoder.runtimeName();
                long latestEngineHeartbeatInMs = System.currentTimeMillis() - this.duplicateEngineTimeoutInMs;
                if (heartbeatTimeInMs > latestEngineHeartbeatInMs && this.errorIfDuplicateEngineDetected) {
                    throw new IllegalStateException(String.format("Error starting Engine a duplicate Artio Engine instance might be running [%s] produced heartbeat at %d, less than %d ms ago.", otherRuntimeName, heartbeatTimeInMs, this.duplicateEngineTimeoutInMs));
                }
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)this.mappedByteBuffer);
            }
        }
        File tempFile = new File(this.logFileDir, UUID.randomUUID().toString() + "-" + FILE_NAME);
        byte[] thisRuntimeName = ManagementFactory.getRuntimeMXBean().getName().getBytes(StandardCharsets.UTF_8);
        long length = 16 + EngineInformationEncoder.runtimeNameHeaderLength() + thisRuntimeName.length;
        this.mappedByteBuffer = IoUtil.mapNewFile((File)tempFile, (long)length);
        this.buffer.wrap((ByteBuffer)this.mappedByteBuffer);
        this.engineInformation.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, new MessageHeaderEncoder()).putRuntimeName(thisRuntimeName, 0, thisRuntimeName.length);
        this.saveheartbeatTime(System.currentTimeMillis());
        this.mappedByteBuffer.force();
        try {
            Files.move(tempFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int doWork() {
        long currentTimeInMs = System.currentTimeMillis();
        if (currentTimeInMs > this.nextDeadlineInMs) {
            this.saveheartbeatTime(currentTimeInMs);
            return 1;
        }
        return 0;
    }

    public String roleName() {
        return "DuplicateEngineChecker";
    }

    private void saveheartbeatTime(long currentTimeInMs) {
        this.engineInformation.heartbeatTimeInMs(currentTimeInMs);
        this.nextDeadlineInMs = currentTimeInMs + this.duplicateEngineTimeoutInMs;
    }

    public void finalClose() {
        this.unmap();
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    void unmap() {
        if (this.mappedByteBuffer != null) {
            IoUtil.unmap((MappedByteBuffer)this.mappedByteBuffer);
            IoUtil.unmap((ByteBuffer)this.buffer.byteBuffer());
        }
    }
}

