/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ILinkConnectDecoder {
    public static final int BLOCK_LENGTH = 53;
    public static final int TEMPLATE_ID = 57;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 19;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ILinkConnectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 53;
    }

    public int sbeTemplateId() {
        return 57;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 19;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ILinkConnectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ILinkConnectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (57 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int connectionId() {
        return 3;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 12;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connection() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int uuidId() {
        return 4;
    }

    public static int uuidSinceVersion() {
        return 0;
    }

    public static int uuidEncodingOffset() {
        return 20;
    }

    public static int uuidEncodingLength() {
        return 8;
    }

    public static String uuidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long uuidNullValue() {
        return -1L;
    }

    public static long uuidMinValue() {
        return 0L;
    }

    public static long uuidMaxValue() {
        return -2L;
    }

    public long uuid() {
        return this.buffer.getLong(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastReceivedSequenceNumberId() {
        return 5;
    }

    public static int lastReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastReceivedSequenceNumberEncodingOffset() {
        return 28;
    }

    public static int lastReceivedSequenceNumberEncodingLength() {
        return 8;
    }

    public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastReceivedSequenceNumberNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lastReceivedSequenceNumberMinValue() {
        return -9223372036854775807L;
    }

    public static long lastReceivedSequenceNumberMaxValue() {
        return Long.MAX_VALUE;
    }

    public long lastReceivedSequenceNumber() {
        return this.buffer.getLong(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastSentSequenceNumberId() {
        return 6;
    }

    public static int lastSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastSentSequenceNumberEncodingOffset() {
        return 36;
    }

    public static int lastSentSequenceNumberEncodingLength() {
        return 8;
    }

    public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastSentSequenceNumberNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lastSentSequenceNumberMinValue() {
        return -9223372036854775807L;
    }

    public static long lastSentSequenceNumberMaxValue() {
        return Long.MAX_VALUE;
    }

    public long lastSentSequenceNumber() {
        return this.buffer.getLong(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public static int newlyAllocatedId() {
        return 7;
    }

    public static int newlyAllocatedSinceVersion() {
        return 0;
    }

    public static int newlyAllocatedEncodingOffset() {
        return 44;
    }

    public static int newlyAllocatedEncodingLength() {
        return 1;
    }

    public static String newlyAllocatedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short newlyAllocatedRaw() {
        return (short)(this.buffer.getByte(this.offset + 44) & 0xFF);
    }

    public Bool newlyAllocated() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 44) & 0xFF));
    }

    public static int lastUuidId() {
        return 8;
    }

    public static int lastUuidSinceVersion() {
        return 0;
    }

    public static int lastUuidEncodingOffset() {
        return 45;
    }

    public static int lastUuidEncodingLength() {
        return 8;
    }

    public static String lastUuidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastUuidNullValue() {
        return -1L;
    }

    public static long lastUuidMinValue() {
        return 0L;
    }

    public static long lastUuidMaxValue() {
        return -2L;
    }

    public long lastUuid() {
        return this.buffer.getLong(this.offset + 45, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ILinkConnectDecoder decoder = new ILinkConnectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ILinkConnect](sbeTemplateId=");
        builder.append(57);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 19) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(19);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 53) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(53);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("connection=");
        builder.append(this.connection());
        builder.append('|');
        builder.append("uuid=");
        builder.append(this.uuid());
        builder.append('|');
        builder.append("lastReceivedSequenceNumber=");
        builder.append(this.lastReceivedSequenceNumber());
        builder.append('|');
        builder.append("lastSentSequenceNumber=");
        builder.append(this.lastSentSequenceNumber());
        builder.append('|');
        builder.append("newlyAllocated=");
        builder.append((Object)this.newlyAllocated());
        builder.append('|');
        builder.append("lastUuid=");
        builder.append(this.lastUuid());
        this.limit(originalLimit);
        return builder;
    }
}

