/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.builder.AbstractBusinessMessageRejectEncoder;
import uk.co.real_logic.artio.builder.AbstractHeartbeatEncoder;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.AbstractLogoutEncoder;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.AbstractResendRequestEncoder;
import uk.co.real_logic.artio.builder.AbstractSequenceResetEncoder;
import uk.co.real_logic.artio.builder.AbstractTestRequestEncoder;
import uk.co.real_logic.artio.decoder.AbstractHeartbeatDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogoutDecoder;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.AbstractTestRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractUserRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;

class FixDictionaryGenerator {
    private static final String TEMPLATE = "public class FixDictionaryImpl implements FixDictionary\n{\n    public String beginString()\n    {\n        return \"%1$s\";\n    }\n\n    public SessionHeaderDecoder makeHeaderDecoder()\n    {\n        return new HeaderDecoder();\n    }\n\n";
    private static final String MAKE_TEMPLATE = "    public Abstract%1$s make%1$s()\n    {\n        return %2$s;\n    }\n\n";
    private static final String NULL = "null";
    private final Dictionary dictionary;
    private final OutputManager outputManager;
    private final String encoderPackage;
    private final String decoderPackage;
    private final String parentPackage;

    FixDictionaryGenerator(Dictionary dictionary, OutputManager outputManager, String encoderPackage, String decoderPackage, String parentPackage) {
        this.dictionary = dictionary;
        this.outputManager = outputManager;
        this.encoderPackage = encoderPackage;
        this.decoderPackage = decoderPackage;
        this.parentPackage = parentPackage;
    }

    public void generate() {
        Set allMessageNames = this.dictionary.messages().stream().map(Aggregate::name).collect(Collectors.toSet());
        this.outputManager.withOutput("FixDictionaryImpl", out -> {
            try {
                StringBuilder sb = new StringBuilder(String.format(TEMPLATE, this.dictionary.beginString()));
                out.append(GenerationUtil.fileHeader(this.parentPackage));
                out.append(GenerationUtil.importFor(FixDictionary.class));
                out.append(GenerationUtil.importFor(AbstractLogonEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "Logon", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractResendRequestEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "ResendRequest", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractLogoutEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "Logout", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractHeartbeatEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "Heartbeat", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractRejectEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "Reject", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractTestRequestEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "TestRequest", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractSequenceResetEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "SequenceReset", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractBusinessMessageRejectEncoder.class));
                FixDictionaryGenerator.addEncoderImport(out, this.encoderPackage, "BusinessMessageReject", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractLogonDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "Logon", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractLogoutDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "Logout", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractRejectDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "Reject", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractTestRequestDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "TestRequest", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractSequenceResetDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "SequenceReset", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractHeartbeatDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "Heartbeat", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractResendRequestDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "ResendRequest", allMessageNames, sb);
                out.append(GenerationUtil.importFor(AbstractUserRequestDecoder.class));
                FixDictionaryGenerator.addDecoderImport(out, this.decoderPackage, "UserRequest", allMessageNames, sb);
                out.append(GenerationUtil.importFor(SessionHeaderDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".HeaderDecoder"));
                out.append(sb.toString());
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            finally {
                out.append("}\n");
            }
        });
    }

    private static void addEncoderImport(Writer out, String encoderPackage, String messageName, Set<String> allMessageNames, StringBuilder sb) throws IOException {
        FixDictionaryGenerator.addImport(out, encoderPackage, messageName, allMessageNames, sb, "Encoder");
    }

    private static void addDecoderImport(Writer out, String decoderPackage, String messageName, Set<String> allMessageNames, StringBuilder sb) throws IOException {
        FixDictionaryGenerator.addImport(out, decoderPackage, messageName, allMessageNames, sb, "Decoder");
    }

    private static void addImport(Writer out, String classPackage, String messageName, Set<String> allMessageNames, StringBuilder sb, String encoderOrDecoder) throws IOException {
        String constructor;
        String encoderClass = messageName + encoderOrDecoder;
        if (allMessageNames.contains(messageName)) {
            constructor = String.format("new %s()", encoderClass);
            out.append(GenerationUtil.importFor(classPackage + "." + encoderClass));
        } else {
            constructor = NULL;
        }
        sb.append(String.format(MAKE_TEMPLATE, encoderClass, constructor));
    }
}

