/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class SessionIdDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 28;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 7;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionIdDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 28;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SessionIdDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SessionIdDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (28 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sessionIdId() {
        return 1;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 0;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long sessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceIndexId() {
        return 2;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 8;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceIndex() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logonTimeId() {
        return 3;
    }

    public static int logonTimeSinceVersion() {
        return 0;
    }

    public static int logonTimeEncodingOffset() {
        return 12;
    }

    public static int logonTimeEncodingLength() {
        return 8;
    }

    public static String logonTimeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logonTimeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logonTimeMinValue() {
        return -9223372036854775807L;
    }

    public static long logonTimeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logonTime() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int compositeKeyLengthId() {
        return 4;
    }

    public static int compositeKeyLengthSinceVersion() {
        return 0;
    }

    public static int compositeKeyLengthEncodingOffset() {
        return 20;
    }

    public static int compositeKeyLengthEncodingLength() {
        return 4;
    }

    public static String compositeKeyLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int compositeKeyLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int compositeKeyLengthMinValue() {
        return -2147483647;
    }

    public static int compositeKeyLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int compositeKeyLength() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastSequenceResetTimeId() {
        return 5;
    }

    public static int lastSequenceResetTimeSinceVersion() {
        return 0;
    }

    public static int lastSequenceResetTimeEncodingOffset() {
        return 24;
    }

    public static int lastSequenceResetTimeEncodingLength() {
        return 8;
    }

    public static String lastSequenceResetTimeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastSequenceResetTimeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lastSequenceResetTimeMinValue() {
        return -9223372036854775807L;
    }

    public static long lastSequenceResetTimeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long lastSequenceResetTime() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastFixDictionaryId() {
        return 6;
    }

    public static int lastFixDictionarySinceVersion() {
        return 3;
    }

    public static String lastFixDictionaryCharacterEncoding() {
        return "UTF-8";
    }

    public static String lastFixDictionaryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lastFixDictionaryHeaderLength() {
        return 2;
    }

    public int lastFixDictionaryLength() {
        if (this.parentMessage.actingVersion < 3) {
            return 0;
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int skipLastFixDictionary() {
        if (this.parentMessage.actingVersion < 3) {
            return 0;
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getLastFixDictionary(MutableDirectBuffer dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 3) {
            return 0;
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLastFixDictionary(byte[] dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 3) {
            return 0;
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLastFixDictionary(DirectBuffer wrapBuffer) {
        if (this.parentMessage.actingVersion < 3) {
            wrapBuffer.wrap(this.buffer, this.offset, 0);
            return;
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String lastFixDictionary() {
        String value;
        if (this.parentMessage.actingVersion < 3) {
            return "";
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SessionIdDecoder decoder = new SessionIdDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SessionId](sbeTemplateId=");
        builder.append(28);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 7) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(7);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("sequenceIndex=");
        builder.append(this.sequenceIndex());
        builder.append('|');
        builder.append("logonTime=");
        builder.append(this.logonTime());
        builder.append('|');
        builder.append("compositeKeyLength=");
        builder.append(this.compositeKeyLength());
        builder.append('|');
        builder.append("lastSequenceResetTime=");
        builder.append(this.lastSequenceResetTime());
        builder.append('|');
        builder.append("lastFixDictionary=");
        builder.append('\'').append(this.lastFixDictionary()).append('\'');
        this.limit(originalLimit);
        return builder;
    }
}

