/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;

public final class Exceptions {
    public static void closeAll(List<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            Exception exception = (Exception)exceptions.remove(0);
            exceptions.forEach(exception::addSuppressed);
            LangUtil.rethrowUnchecked((Throwable)exception);
        }
    }

    public static void closeAll(AutoCloseable ... closeables) {
        Exceptions.closeAll(Arrays.asList(closeables));
    }

    public static void closeAll(Agent ... agents) {
        Exceptions.closeAll(Stream.of(agents).filter(Objects::nonNull).map(agent -> () -> ((Agent)agent).onClose()).collect(Collectors.toList()));
    }

    public static void suppressingClose(AutoCloseable closeable, Exception originalException) {
        try {
            closeable.close();
        }
        catch (Exception ex) {
            originalException.addSuppressed(ex);
        }
    }

    public static void printStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            System.out.println(Thread.currentThread().getName());
            ex.printStackTrace(System.out);
            return;
        }
    }

    public static void printStackTracesForAllThreads() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        Object[] threads = bean.dumpAllThreads(true, true);
        System.err.println(Arrays.toString(threads));
    }

    public static boolean isJustDisconnect(Exception ex) {
        String msg = ex.getMessage();
        return msg != null && (msg.contains("Connection reset by peer") || msg.contains("An established connection was aborted"));
    }

    public static String toString(Throwable throwable) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (PrintStream printStream = new PrintStream(bytes);){
            throwable.printStackTrace(printStream);
            String string = bytes.toString();
            return string;
        }
    }
}

