/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class PreviousRecordingDecoder {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 30;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PreviousRecordingDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final InboundRecordingsDecoder inboundRecordings = new InboundRecordingsDecoder(this);
    private final OutboundRecordingsDecoder outboundRecordings = new OutboundRecordingsDecoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 30;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public PreviousRecordingDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long inboundRecordingsDecoderId() {
        return 1L;
    }

    public static int inboundRecordingsDecoderSinceVersion() {
        return 0;
    }

    public InboundRecordingsDecoder inboundRecordings() {
        this.inboundRecordings.wrap(this.buffer);
        return this.inboundRecordings;
    }

    public static long outboundRecordingsDecoderId() {
        return 2L;
    }

    public static int outboundRecordingsDecoderSinceVersion() {
        return 0;
    }

    public OutboundRecordingsDecoder outboundRecordings() {
        this.outboundRecordings.wrap(this.buffer);
        return this.outboundRecordings;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        PreviousRecordingDecoder decoder = new PreviousRecordingDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[PreviousRecording](sbeTemplateId=");
        builder.append(30);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 0) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(0);
        builder.append("):");
        builder.append("inboundRecordings=[");
        InboundRecordingsDecoder inboundRecordings = this.inboundRecordings();
        if (inboundRecordings.count() > 0) {
            while (inboundRecordings.hasNext()) {
                inboundRecordings.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("outboundRecordings=[");
        OutboundRecordingsDecoder outboundRecordings = this.outboundRecordings();
        if (outboundRecordings.count() > 0) {
            while (outboundRecordings.hasNext()) {
                outboundRecordings.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static final class OutboundRecordingsDecoder
    implements Iterable<OutboundRecordingsDecoder>,
    Iterator<OutboundRecordingsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final PreviousRecordingDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        OutboundRecordingsDecoder(PreviousRecordingDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public OutboundRecordingsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<OutboundRecordingsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int recordingIdId() {
            return 11;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long recordingId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("recordingId=");
            builder.append(this.recordingId());
            builder.append(')');
            return builder;
        }
    }

    public static final class InboundRecordingsDecoder
    implements Iterable<InboundRecordingsDecoder>,
    Iterator<InboundRecordingsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final PreviousRecordingDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        InboundRecordingsDecoder(PreviousRecordingDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public InboundRecordingsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<InboundRecordingsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int recordingIdId() {
            return 10;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long recordingId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("recordingId=");
            builder.append(this.recordingId());
            builder.append(')');
            return builder;
        }
    }
}

