/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.FixPMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;

public abstract class AbstractFixPProxy {
    protected static final int ARTIO_HEADER_LENGTH = 24;
    protected final MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
    protected final FixPMessageEncoder fixPMessage = new FixPMessageEncoder();
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected final ExclusivePublication publication;
    protected long connectionId;

    protected AbstractFixPProxy(long connectionId, ExclusivePublication publication) {
        this.connectionId = connectionId;
        this.publication = publication;
    }

    public void connectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    public abstract long sendSequence(long var1, long var3);

    public abstract long claimMessage(int var1, MessageEncoderFlyweight var2, long var3);

    public void commit() {
        this.bufferClaim.commit();
    }

    public void abort() {
        this.bufferClaim.abort();
    }

    protected long claimMessage(int messageLength, MessageEncoderFlyweight message, long timestamp, int totalHeaderLength, int protocolHeaderLength, short protocolType) {
        BufferClaim bufferClaim = this.bufferClaim;
        long position = this.publication.tryClaim(totalHeaderLength + messageLength, bufferClaim);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = bufferClaim.buffer();
        int offset = bufferClaim.offset();
        this.fixPMessage.wrapAndApplyHeader(buffer, bufferClaim.offset(), this.messageHeader).connection(this.connectionId).enqueueTime(timestamp);
        SimpleOpenFramingHeader.writeSofh(buffer, offset += 24, protocolHeaderLength + messageLength, protocolType);
        offset += 4;
        offset = this.applyHeader(message, buffer, offset);
        message.wrap(buffer, offset);
        return position;
    }

    protected abstract int applyHeader(MessageEncoderFlyweight var1, MutableDirectBuffer var2, int var3);
}

