/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.agrona.Verify;
import org.agrona.generation.ResourceConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;

public final class DictionaryParser {
    private static final String FIELD_EXPR = "/fix/fields/field";
    private static final String MESSAGE_EXPR = "/fix/messages/message";
    private static final String COMPONENT_EXPR = "/fix/components/component";
    private static final String HEADER_EXPR = "/fix/header/field";
    private static final String TRAILER_EXPR = "/fix/trailer/field";
    private final DocumentBuilder documentBuilder;
    private final XPathExpression findField;
    private final XPathExpression findMessage;
    private final XPathExpression findComponent;
    private final XPathExpression findHeader;
    private final XPathExpression findTrailer;
    private final boolean allowDuplicates;

    public DictionaryParser(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.findField = xPath.compile(FIELD_EXPR);
            this.findMessage = xPath.compile(MESSAGE_EXPR);
            this.findComponent = xPath.compile(COMPONENT_EXPR);
            this.findHeader = xPath.compile(HEADER_EXPR);
            this.findTrailer = xPath.compile(TRAILER_EXPR);
        }
        catch (ParserConfigurationException | XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Dictionary parse(InputStream in, Dictionary fixtDictionary) throws Exception {
        Document document = this.documentBuilder.parse(in);
        Map<String, Field> fields = this.parseFields(document);
        HashMap<Entry, String> forwardReferences = new HashMap<Entry, String>();
        Map<String, Component> components = this.parseComponents(document, fields, forwardReferences);
        List<Message> messages = this.parseMessages(document, fields, components, forwardReferences);
        this.reconnectForwardReferences(forwardReferences, components);
        this.sanitizeDictionary(fields, messages);
        this.validateDataFields(messages);
        this.validateDataFields(components.values());
        if (fixtDictionary != null) {
            ArrayList<Message> allMessages = new ArrayList<Message>(fixtDictionary.messages());
            allMessages.addAll(messages);
            HashMap<String, Field> allFields = new HashMap<String, Field>(fixtDictionary.fields());
            allFields.putAll(fields);
            HashMap<String, Component> allComponents = new HashMap<String, Component>(fixtDictionary.components());
            allComponents.putAll(components);
            return new Dictionary(allMessages, allFields, allComponents, fixtDictionary.header(), fixtDictionary.trailer(), fixtDictionary.specType(), fixtDictionary.majorVersion(), fixtDictionary.minorVersion());
        }
        NamedNodeMap fixAttributes = document.getElementsByTagName("fix").item(0).getAttributes();
        int majorVersion = this.getInt(fixAttributes, "major");
        int minorVersion = this.getInt(fixAttributes, "minor");
        Component header = this.extractComponent(document, fields, this.findHeader, "Header", components, forwardReferences);
        Component trailer = this.extractComponent(document, fields, this.findTrailer, "Trailer", components, forwardReferences);
        this.validateDataFieldsInAggregate(header);
        this.validateDataFieldsInAggregate(trailer);
        String specType = this.getValueOrDefault(fixAttributes, "type", "FIX");
        return new Dictionary(messages, fields, components, header, trailer, specType, majorVersion, minorVersion);
    }

    private void validateDataFields(Collection<? extends Aggregate> aggregates) {
        aggregates.forEach(this::validateDataFieldsInAggregate);
    }

    private void validateDataFieldsInAggregate(Aggregate aggregate) {
        Map<String, Field> nameToField = aggregate.fieldEntries().map(entry -> (Field)entry.element()).collect(Collectors.toMap(Field::name, f -> f));
        for (Entry entry2 : aggregate.entries()) {
            entry2.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> {
                if (field.type().isDataBased()) {
                    String name = field.name();
                    if (!this.hasLengthField((Field)field, "Length", nameToField) && !this.hasLengthField((Field)field, "Len", nameToField)) {
                        throw new IllegalStateException(String.format("Each DATA field must have a corresponding LENGTH field using the suffix 'Len' or 'Length'. %1$s is missing a length field in %2$s", name, aggregate.name()));
                    }
                }
            }), (ResourceConsumer<Group>)((ResourceConsumer)this::validateDataFieldsInAggregate), (ResourceConsumer<Component>)((ResourceConsumer)this::validateDataFieldsInAggregate));
        }
    }

    private boolean hasLengthField(Field field, String suffix, Map<String, Field> nameToField) {
        Field.Type type;
        String fieldName = field.name() + suffix;
        Field associatedLengthField = nameToField.get(fieldName);
        if (associatedLengthField != null && ((type = associatedLengthField.type()) == Field.Type.LENGTH || type == Field.Type.INT)) {
            field.associatedLengthField(associatedLengthField);
            return true;
        }
        return false;
    }

    private void correctMultiCharacterCharEnums(Map<String, Field> fields) {
        fields.values().stream().filter(Field::isEnum).filter(field -> field.type() == Field.Type.CHAR).filter(this::hasMultipleCharacters).forEach(field -> field.type(Field.Type.STRING));
    }

    private boolean hasMultipleCharacters(Field field) {
        return field.values().stream().anyMatch(value -> value.representation().length() > 1);
    }

    private void reconnectForwardReferences(Map<Entry, String> forwardReferences, Map<String, Component> components) {
        forwardReferences.forEach((entry, name) -> {
            Component component = (Component)components.get(name);
            Verify.notNull((Object)component, (String)("element:" + name));
            entry.element(component);
        });
    }

    private Map<String, Component> parseComponents(Document document, Map<String, Field> fields, Map<Entry, String> forwardReferences) throws XPathExpressionException {
        HashMap<String, Component> components = new HashMap<String, Component>();
        this.extractNodes(document, this.findComponent, node -> {
            NamedNodeMap attributes = node.getAttributes();
            String name = this.name(attributes);
            Component component = new Component(name);
            this.extractEntries(node.getChildNodes(), fields, component.entries(), components, forwardReferences);
            components.put(name, component);
        });
        return components;
    }

    private Map<String, Field> parseFields(Document document) throws XPathExpressionException {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        this.extractNodes(document, this.findField, node -> {
            NamedNodeMap attributes = node.getAttributes();
            String name = this.name(attributes);
            int number = this.getInt(attributes, "number");
            Field.Type type = Field.Type.lookup(this.getValue(attributes, "type"));
            String normalisedFieldName = DictionaryParser.ensureNumInGroupStartsWithNo(name, type);
            Field field = new Field(number, normalisedFieldName, type);
            this.extractEnumValues(field.values(), node.getChildNodes());
            Field oldField = fields.put(name, field);
            if (oldField != null) {
                throw new IllegalStateException(String.format("Cannot have the same field name defined twice; this is against the FIX spec.Details to follow:\nField : %1$s (%2$s)\nField : %3$s (%4$s)", field.name(), field.number(), oldField.name(), oldField.number()));
            }
        });
        return fields;
    }

    private static String ensureNumInGroupStartsWithNo(String name, Field.Type type) {
        if (type == Field.Type.NUMINGROUP) {
            return name.startsWith("No") ? name : "No" + name;
        }
        return name;
    }

    private int getInt(NamedNodeMap attributes, String attributeName) {
        return Integer.parseInt(this.getValue(attributes, attributeName));
    }

    private void extractEnumValues(List<Field.Value> values, NodeList childNodes) {
        this.forEach(childNodes, node -> {
            NamedNodeMap attributes = node.getAttributes();
            String representation = this.getValue(attributes, "enum");
            String description = this.getValue(attributes, "description");
            values.add(new Field.Value(representation, DictionaryParser.enumDescriptionToJavaName(description)));
        });
    }

    private List<Message> parseMessages(Document document, Map<String, Field> fields, Map<String, Component> components, Map<Entry, String> forwardReferences) throws XPathExpressionException {
        ArrayList<Message> messages = new ArrayList<Message>();
        this.extractNodes(document, this.findMessage, node -> {
            NamedNodeMap attributes = node.getAttributes();
            String name = this.name(attributes);
            String fullType = this.getValue(attributes, "msgtype");
            String category = this.getValue(attributes, "msgcat");
            Message message = new Message(name, fullType, category);
            this.extractEntries(node.getChildNodes(), fields, message.entries(), components, forwardReferences);
            messages.add(message);
        });
        return messages;
    }

    private void extractEntries(NodeList childNodes, Map<String, Field> fields, List<Entry> entries, Map<String, Component> components, Map<Entry, String> forwardReferences) {
        this.forEach(childNodes, node -> {
            NamedNodeMap attributes = node.getAttributes();
            String name = this.name(attributes);
            if (name.trim().length() == 0) {
                return;
            }
            boolean required = this.isRequired(attributes);
            Consumer<Entry.Element> newEntry = element -> {
                Verify.notNull((Object)element, (String)("element for " + name));
                entries.add(new Entry(required, (Entry.Element)element));
            };
            switch (node.getNodeName()) {
                case "field": {
                    newEntry.accept((Entry.Element)fields.get(name));
                    break;
                }
                case "group": {
                    Group group = Group.of((Field)fields.get(name));
                    this.extractEntries(node.getChildNodes(), fields, group.entries(), components, forwardReferences);
                    newEntry.accept(group);
                    break;
                }
                case "component": {
                    Component component = (Component)components.get(name);
                    Entry entry = new Entry(required, component);
                    if (component == null) {
                        forwardReferences.put(entry, name);
                    }
                    entries.add(entry);
                }
            }
        });
    }

    private Component extractComponent(Document document, Map<String, Field> fields, XPathExpression expression, String name, Map<String, Component> components, Map<Entry, String> forwardReferences) throws XPathExpressionException {
        Component component = new Component(name);
        NodeList nodes = this.evaluate(document, expression);
        this.extractEntries(nodes, fields, component.entries(), components, forwardReferences);
        return component;
    }

    private String name(NamedNodeMap attributes) {
        return this.getValue(attributes, "name");
    }

    private boolean isRequired(NamedNodeMap attributes) {
        return "Y".equals(this.getValue(attributes, "required"));
    }

    private String getValue(NamedNodeMap attributes, String attributeName) {
        Objects.requireNonNull(attributes, "Null attributes for " + attributeName);
        return Objects.requireNonNull(this.getOptionalValue(attributes, attributeName), "Empty item for:" + attributeName);
    }

    private String getOptionalValue(NamedNodeMap attributes, String attributeName) {
        Objects.requireNonNull(attributes, "Null attributes for " + attributeName);
        Node attributeNode = attributes.getNamedItem(attributeName);
        return attributeNode == null ? null : attributeNode.getNodeValue();
    }

    private String getValueOrDefault(NamedNodeMap attributes, String attributeName, String defaultValue) {
        Objects.requireNonNull(attributes, "Null attributes for " + attributeName);
        String value = this.getOptionalValue(attributes, attributeName);
        return value == null ? defaultValue : value;
    }

    private void extractNodes(Document document, XPathExpression expression, Consumer<Node> handler) throws XPathExpressionException {
        this.forEach(this.evaluate(document, expression), handler);
    }

    private NodeList evaluate(Document document, XPathExpression expression) throws XPathExpressionException {
        return (NodeList)expression.evaluate(document, XPathConstants.NODESET);
    }

    private void forEach(NodeList nodes, Consumer<Node> handler) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            handler.accept(node);
        }
    }

    private void sanitizeDictionary(Map<String, Field> fields, List<Message> messages) {
        this.correctMultiCharacterCharEnums(fields);
        this.identifyDuplicateFieldDefinitionsForMessages(messages);
    }

    private void identifyDuplicateFieldDefinitionsForMessages(List<Message> messages) {
        StringBuilder errorMessage = new StringBuilder();
        for (Message message : messages) {
            HashSet<Integer> allFieldsForMessage = new HashSet<Integer>();
            DictionaryParser.identifyDuplicateFieldDefinitionsForMessage(message.name(), message, allFieldsForMessage, new ArrayDeque<String>(), errorMessage);
        }
        if (errorMessage.length() > 0 && !this.allowDuplicates) {
            throw new IllegalStateException(String.format("%sUse -D%s=true to allow duplicated fields (Dangerous. May break parser).", errorMessage, "fix.codecs.allow_duplicate_fields"));
        }
    }

    private static void identifyDuplicateFieldDefinitionsForMessage(String messageName, Aggregate aggregate, Set<Integer> allFields, Deque<String> path, StringBuilder errorCollector) {
        for (Entry e : aggregate.entries()) {
            e.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> DictionaryParser.addField(messageName, field, allFields, path, errorCollector)), (ResourceConsumer<Group>)((ResourceConsumer)group -> {
                path.push(group.name());
                DictionaryParser.identifyDuplicateFieldDefinitionsForMessage(messageName, group, allFields, path, errorCollector);
                path.pop();
            }), (ResourceConsumer<Component>)((ResourceConsumer)component -> {
                path.push(component.name());
                DictionaryParser.identifyDuplicateFieldDefinitionsForMessage(messageName, component, allFields, path, errorCollector);
                path.pop();
            }));
        }
    }

    private static void addField(String messageName, Field field, Set<Integer> fieldsForMessage, Deque<String> path, StringBuilder errorCollector) {
        if (!fieldsForMessage.add(field.number())) {
            if (errorCollector.length() == 0) {
                errorCollector.append("Cannot have the same field defined more than once on a message; this is against the FIX spec. Details to follow:\n");
            }
            errorCollector.append("Message: ").append(messageName).append(" Field : ").append(field.name()).append(" (").append(field.number()).append(")");
            if (!path.isEmpty()) {
                errorCollector.append(" Through Path: ").append(path.toString());
            }
            errorCollector.append('\n');
        }
    }

    private static String enumDescriptionToJavaName(String enumDescription) {
        StringBuilder enumName = new StringBuilder();
        char firstChar = enumDescription.charAt(0);
        if (Character.isJavaIdentifierStart(firstChar)) {
            enumName.append(firstChar);
        } else if (Character.isJavaIdentifierPart(firstChar)) {
            enumName.append('_').append(firstChar);
        } else {
            enumName.append('_');
        }
        for (int i = 1; i < enumDescription.length(); ++i) {
            char nextChar = enumDescription.charAt(i);
            if (Character.isJavaIdentifierPart(nextChar)) {
                enumName.append(nextChar);
                continue;
            }
            enumName.append('_');
        }
        return enumName.toString();
    }
}

