/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcDateOnlyDecoder {
    public static final int SIZE_OF_YEAR = 4;
    public static final int SIZE_OF_MONTH = 2;
    public static final int SIZE_OF_DAY = 2;
    public static final int LENGTH = 8;
    private final AsciiBuffer flyweight = new MutableAsciiBuffer();

    public int decode(byte[] bytes) {
        this.flyweight.wrap(bytes);
        return UtcDateOnlyDecoder.decode(this.flyweight, 0);
    }

    public static int decode(AsciiBuffer date, int offset) {
        int endYear = offset + 4;
        int endMonth = endYear + 2;
        int endDay = endMonth + 2;
        int year = date.getNatural(offset, endYear);
        int month = CalendricalUtil.getValidInt(date, endYear, endMonth, 1, 12);
        int day = CalendricalUtil.getValidInt(date, endMonth, endDay, 1, 31);
        return CalendricalUtil.toEpochDay(year, month, day);
    }
}

