/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

class AcceptorGenerator {
    public static final String ON_MESSAGE = "onMessage";
    public static final String DICTIONARY_DECODER = "DictionaryDecoder";
    public static final String DICTIONARY_ACCEPTOR = "DictionaryAcceptor";
    public static final String DEFAULT_DICTIONARY_ACCEPTOR = "DefaultDictionaryAcceptor";
    private final Dictionary dictionary;
    private final String packageName;
    private final OutputManager outputManager;

    AcceptorGenerator(Dictionary dictionary, String packageName, OutputManager outputManager) {
        this.dictionary = dictionary;
        this.packageName = packageName;
        this.outputManager = outputManager;
    }

    public void generate() {
        this.generateAcceptor();
        this.generateDefaultAcceptor();
        this.generateDecoder();
    }

    private void generateAcceptor() {
        this.outputManager.withOutput(DICTIONARY_ACCEPTOR, acceptorOutput -> {
            this.generateAcceptorClass((Writer)acceptorOutput);
            for (Message message : this.dictionary.messages()) {
                this.generateAcceptorCallback((Writer)acceptorOutput, message);
            }
            this.generateAcceptorSuffix((Writer)acceptorOutput);
        });
    }

    private void generateDefaultAcceptor() {
        this.outputManager.withOutput(DEFAULT_DICTIONARY_ACCEPTOR, acceptorOutput -> {
            this.generateDefaultAcceptorClass((Writer)acceptorOutput);
            for (Message message : this.dictionary.messages()) {
                this.generateDefaultAcceptorCallback((Writer)acceptorOutput, message);
            }
            this.generateDefaultAcceptorSuffix((Writer)acceptorOutput);
        });
    }

    private void generateAcceptorCallback(Writer acceptorOutput, Message message) throws IOException {
        acceptorOutput.append(String.format("    void on%1$s(final %2$s decoder);\n\n", message.name(), DecoderGenerator.decoderClassName(message)));
    }

    private void generateDefaultAcceptorCallback(Writer acceptorOutput, Message message) throws IOException {
        acceptorOutput.append(String.format("    @Override\n    public void on%1$s(final %2$s decoder) {};\n\n", message.name(), DecoderGenerator.decoderClassName(message)));
    }

    private void generateAcceptorSuffix(Writer acceptorOutput) throws IOException {
        acceptorOutput.append("\n}\n");
    }

    private void generateDefaultAcceptorSuffix(Writer acceptorOutput) throws IOException {
        acceptorOutput.append("\n}\n");
    }

    private void generateAcceptorClass(Writer acceptorOutput) throws IOException {
        acceptorOutput.append(GenerationUtil.fileHeader(this.packageName));
        acceptorOutput.append("\npublic interface DictionaryAcceptor\n{\n");
    }

    private void generateDefaultAcceptorClass(Writer acceptorOutput) throws IOException {
        acceptorOutput.append(GenerationUtil.fileHeader(this.packageName));
        acceptorOutput.append("\npublic class DefaultDictionaryAcceptor implements DictionaryAcceptor\n{\n");
    }

    private void generateDecoder() {
        this.outputManager.withOutput(DICTIONARY_DECODER, decoderOutput -> {
            this.generateDecoderClass((Writer)decoderOutput);
            for (Message message : this.dictionary.messages()) {
                this.generateDecoderField((Writer)decoderOutput, message);
            }
            this.generateDecoderOnMessage((Writer)decoderOutput);
            for (int index = 0; index < this.dictionary.messages().size(); ++index) {
                this.generateDecoderCase((Writer)decoderOutput, this.dictionary.messages().get(index), index);
            }
            this.generateDecoderSuffix((Writer)decoderOutput);
        });
    }

    private void generateDecoderSuffix(Writer decoderOutput) throws IOException {
        decoderOutput.append("    }\n\n");
        decoderOutput.append("}\n");
    }

    private void generateDecoderOnMessage(Writer decoderOutput) throws IOException {
        decoderOutput.append("\n    public DictionaryDecoder(final DictionaryAcceptor acceptor)\n    {\n        this.acceptor = acceptor;\n    }\n\n    public void onMessage(\n        final AsciiBuffer buffer,\n        final int offset,\n        final int length,\n        final long messageType)\n    {\n");
    }

    private void generateDecoderCase(Writer decoderOutput, Message message, int index) throws IOException {
        decoderOutput.append(String.format("        %1$sif (messageType == %2$s.MESSAGE_TYPE)\n        {            %3$s.decode(buffer, offset, length);\n            acceptor.on%4$s(%3$s);\n            %3$s.reset();\n        }\n\n", index == 0 ? "" : "else ", DecoderGenerator.decoderClassName(message), JavaUtil.formatPropertyName((String)message.name()), message.name()));
    }

    private void generateDecoderField(Writer decoderOutput, Message message) throws IOException {
        decoderOutput.append(String.format("    private final %1$s %2$s = new %1$s();\n", DecoderGenerator.decoderClassName(message), JavaUtil.formatPropertyName((String)message.name())));
    }

    private void generateDecoderClass(Writer decoderOutput) throws IOException {
        decoderOutput.append(GenerationUtil.fileHeader(this.packageName));
        decoderOutput.append(GenerationUtil.importFor(AsciiBuffer.class));
        decoderOutput.append("\npublic final class DictionaryDecoder\n{\n\n    private final DictionaryAcceptor acceptor;\n\n");
    }
}

