/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.EncoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.generation.OptionalSessionFields;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

class DecoderGenerator
extends Generator {
    private static final Set<String> REQUIRED_SESSION_CODECS = new HashSet<String>(Arrays.asList("LogonDecoder", "LogoutDecoder", "RejectDecoder", "TestRequestDecoder", "SequenceResetDecoder", "HeartbeatDecoder", "ResendRequestDecoder", "UserRequestDecoder"));
    public static final String REQUIRED_FIELDS = "REQUIRED_FIELDS";
    private static final String GROUP_FIELDS = "GROUP_FIELDS";
    private static final String ALL_GROUP_FIELDS = "ALL_GROUP_FIELDS";
    private static final String MESSAGE_DECODER = "import uk.co.real_logic.artio.builder.Decoder;\n\npublic interface MessageDecoder extends Decoder\n{\n    HeaderDecoder header();\n\n    TrailerDecoder trailer();\n}";
    public static final int INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP = RejectReason.INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP.representation();
    public static final int INVALID_TAG_NUMBER = RejectReason.INVALID_TAG_NUMBER.representation();
    public static final int REQUIRED_TAG_MISSING = RejectReason.REQUIRED_TAG_MISSING.representation();
    public static final int TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = RejectReason.TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE.representation();
    public static final int TAG_SPECIFIED_WITHOUT_A_VALUE = RejectReason.TAG_SPECIFIED_WITHOUT_A_VALUE.representation();
    public static final int VALUE_IS_INCORRECT = RejectReason.VALUE_IS_INCORRECT.representation();
    public static final int TAG_APPEARS_MORE_THAN_ONCE = RejectReason.TAG_APPEARS_MORE_THAN_ONCE.representation();
    public static final int TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14;
    private Aggregate currentAggregate = null;
    private final int initialBufferSize;
    private final String encoderPackage;

    static String decoderClassName(Aggregate aggregate) {
        return DecoderGenerator.decoderClassName(aggregate.name());
    }

    static String decoderClassName(String name) {
        return name + "Decoder";
    }

    DecoderGenerator(Dictionary dictionary, int initialBufferSize, String thisPackage, String commonPackage, String encoderPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownFieldClass, Class<?> rejectUnknownEnumValueClass, boolean flyweightsEnabled, String codecRejectUnknownEnumValueEnabled) {
        super(dictionary, thisPackage, commonPackage, outputManager, validationClass, rejectUnknownFieldClass, rejectUnknownEnumValueClass, flyweightsEnabled, codecRejectUnknownEnumValueEnabled);
        this.initialBufferSize = initialBufferSize;
        this.encoderPackage = encoderPackage;
    }

    @Override
    public void generate() {
        this.generateMessageDecoderInterface();
        super.generate();
    }

    private void generateMessageDecoderInterface() {
        this.outputManager.withOutput("MessageDecoder", out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            out.append(MESSAGE_DECODER);
        });
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType type) {
        if (type == AggregateType.COMPONENT) {
            this.componentInterface((Component)aggregate);
            return;
        }
        String className = DecoderGenerator.decoderClassName(aggregate);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            if (REQUIRED_SESSION_CODECS.contains(className)) {
                out.append(GenerationUtil.importFor("uk.co.real_logic.artio.decoder.Abstract" + className));
            } else if (type == AggregateType.HEADER) {
                out.append(GenerationUtil.importFor(MessageTypeEncoding.class));
                out.append(GenerationUtil.importFor(SessionHeaderDecoder.class));
            }
            this.generateImports("Decoder", type, (Writer)out, Encoder.class);
            this.importEncoders(aggregate, (Writer)out);
            this.generateAggregateClass(aggregate, type, className, (Writer)out);
        });
    }

    private void importEncoders(Aggregate aggregate, Writer out) throws IOException {
        String encoderFullClassName = this.encoderPackage + "." + EncoderGenerator.encoderClassName(aggregate.name());
        out.write(GenerationUtil.importFor(encoderFullClassName));
        this.importChildEncoderClasses(aggregate, out, encoderFullClassName);
    }

    private void importChildEncoderClasses(Aggregate aggregate, Writer out, String encoderFullClassName) throws IOException {
        for (Entry entry : aggregate.entries()) {
            if (entry.isComponent()) {
                String componentClassName = this.encoderPackage + "." + EncoderGenerator.encoderClassName(entry.name());
                out.write(GenerationUtil.importFor(componentClassName));
                this.importChildEncoderClasses((Aggregate)((Object)entry.element()), out, componentClassName);
                continue;
            }
            if (!entry.isGroup()) continue;
            String entryClassName = EncoderGenerator.encoderClassName(entry.name());
            out.write(GenerationUtil.importStaticFor(encoderFullClassName, entryClassName));
            this.importChildEncoderClasses((Aggregate)((Object)entry.element()), out, encoderFullClassName + "." + entryClassName);
        }
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        Aggregate parentAggregate = this.currentAggregate;
        this.currentAggregate = aggregate;
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        List<String> interfaces = aggregate.entriesWith(element -> element instanceof Component).map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
        if (isMessage) {
            interfaces.add("MessageDecoder");
            if (REQUIRED_SESSION_CODECS.contains(className)) {
                interfaces.add("Abstract" + className);
            }
        } else if (type == AggregateType.HEADER) {
            interfaces.add(SessionHeaderDecoder.class.getSimpleName());
        }
        out.append(this.classDeclaration(className, interfaces, false));
        this.generateValidation(out, aggregate, type);
        if (isMessage) {
            Message message = (Message)aggregate;
            out.append(this.messageType(message.fullType(), message.packedType()));
            List<Field> fields = this.compileAllFieldsFor(message);
            String messageFieldsSet = this.generateFieldDictionary(fields, "messageFields", false);
            out.append(this.commonCompoundImports("Decoder", true, messageFieldsSet));
        }
        this.groupMethods(out, aggregate);
        this.headerMethods(out, aggregate, type);
        this.generateGetters(out, className, aggregate.entries());
        out.append(this.decodeMethod(aggregate.entries(), aggregate, type));
        out.append(this.completeResetMethod(isMessage, aggregate.entries(), this.additionalReset(isGroup)));
        out.append(this.generateAppendTo(aggregate, isMessage));
        out.append(this.generateToEncoder(aggregate));
        out.append("}\n");
        this.currentAggregate = parentAggregate;
    }

    private List<Field> compileAllFieldsFor(Message message) {
        Stream<Field> messageBodyFields = this.extractFields(message.entries());
        Stream<Field> headerFields = this.extractFields(this.dictionary.header().entries());
        Stream<Field> trailerFields = this.extractFields(this.dictionary.trailer().entries());
        return Stream.of(headerFields, messageBodyFields, trailerFields).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private void headerMethods(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        if (type == AggregateType.HEADER) {
            out.append("    public HeaderDecoder()\n    {\n        this(new TrailerDecoder());\n    }\n\n");
            this.wrapTrailerInConstructor(out, aggregate);
            this.generatePackedMessageTypeMethod(out);
        }
    }

    private void generatePackedMessageTypeMethod(Writer out) throws IOException {
        if (this.flyweightsEnabled) {
            out.append("    public long messageType()\n    {\n        return buffer.getMessageType(msgTypeOffset, msgTypeLength);\n    }\n\n");
        } else {
            out.append("    public long messageType()\n    {\n        return MessageTypeEncoding.packMessageType(msgType(), msgTypeLength());\n    }\n\n");
        }
    }

    private void groupClass(Group group, Writer out) throws IOException {
        String className = DecoderGenerator.decoderClassName(group);
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Decoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        Entry numberField = group.numberField();
        return String.format("    public void %1$s()\n    {\n        for (final %2$s %6$s : %5$s.iterator())\n        {\n            %6$s.reset();\n            if (%6$s.next() == null)\n            {\n                break;\n            }\n        }\n        %3$s = 0;\n        has%4$s = false;\n    }\n\n", this.nameOfResetMethod(name), DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name(), DecoderGenerator.iteratorFieldName(group), JavaUtil.formatPropertyName((String)DecoderGenerator.decoderClassName(name)));
    }

    private static String iteratorClassName(Group group) {
        return group.name() + "Iterator";
    }

    private static String iteratorFieldName(Group group) {
        return JavaUtil.formatPropertyName((String)DecoderGenerator.iteratorClassName(group));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        String lengthReset = this.flyweightsEnabled ? "        %1$sLength = 0;\n" : "";
        return String.format("    public void %2$s()\n    {\n" + lengthReset + "        %1$s.reset();\n    }\n\n", JavaUtil.formatPropertyName((String)name), this.nameOfResetMethod(name));
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetFieldValue(field, "MISSING_INT");
    }

    private String additionalReset(boolean isGroup) {
        return "        buffer = null;\n        if (CODEC_VALIDATION_ENABLED)\n        {\n            invalidTagId = Decoder.NO_ERROR;\n            rejectReason = Decoder.NO_ERROR;\n            missingRequiredFields.clear();\n" + (isGroup ? "" : "            unknownFields.clear();\n            alreadyVisitedFields.clear();\n") + "        }\n";
    }

    private void generateValidation(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        List<Field> requiredFields = this.requiredFields(aggregate.entries()).collect(Collectors.toList());
        out.append(this.generateFieldDictionary(requiredFields, REQUIRED_FIELDS, true));
        if (aggregate.containsGroup()) {
            List<Field> groupFields = aggregate.allFieldsIncludingComponents().map(Entry::element).map(element -> (Field)element).collect(Collectors.toList());
            String groupFieldString = this.generateFieldDictionary(groupFields, GROUP_FIELDS, true);
            out.append(groupFieldString);
        }
        String enumValidation = aggregate.allFieldsIncludingComponents().filter(entry -> entry.element().isEnumField()).map(this::generateEnumValidation).collect(Collectors.joining("\n"));
        String groupValidation = aggregate.allGroupsIncludingComponents().map(this::generateGroupValidation).collect(Collectors.joining("\n"));
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        String messageValidation = isMessage ? "        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())\n        {\n            invalidTagId = unknownFieldsIterator.nextValue();\n            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? " + TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE + " : " + INVALID_TAG_NUMBER + ";\n            return false;\n        }\n        if (!header.validate())\n        {\n            invalidTagId = header.invalidTagId();\n            rejectReason = header.rejectReason();\n            return false;\n        }\n        else if (!trailer.validate())\n        {\n            invalidTagId = trailer.invalidTagId();\n            rejectReason = trailer.rejectReason();\n            return false;\n        }\n" : "";
        out.append(String.format((isGroup ? this.generateAllGroupFields(aggregate) : "    private final IntHashSet alreadyVisitedFields = new IntHashSet(%5$d);\n\n    private final IntHashSet unknownFields = new IntHashSet(10);\n\n") + "    private final IntHashSet missingRequiredFields = new IntHashSet(%1$d);\n\n    private int invalidTagId = Decoder.NO_ERROR;\n\n    public int invalidTagId()\n    {\n        return invalidTagId;\n    }\n\n    private int rejectReason = Decoder.NO_ERROR;\n\n    public int rejectReason()\n    {\n        return rejectReason;\n    }\n\n    public boolean validate()\n    {\n        if (rejectReason != Decoder.NO_ERROR)\n        {\n            return false;\n        }\n        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();\n" + (isMessage ? "        final IntIterator unknownFieldsIterator = unknownFields.iterator();\n" : "") + "%2$s        if (missingFieldsIterator.hasNext())\n        {\n            invalidTagId = missingFieldsIterator.nextValue();\n            rejectReason = " + REQUIRED_TAG_MISSING + ";\n            return false;\n        }\n%3$s%4$s        return true;\n    }\n\n", ConstantGenerator.sizeHashSet(requiredFields), messageValidation, enumValidation, groupValidation, 2L * aggregate.allFieldsIncludingComponents().count()));
    }

    private String generateAllGroupFields(Aggregate groupAggregate) {
        List<Field> allGroupFields = groupAggregate.fieldEntries().map(entry -> (Field)entry.element()).collect(Collectors.toList());
        return this.generateFieldDictionary(allGroupFields, ALL_GROUP_FIELDS, true);
    }

    private String generateFieldDictionary(Collection<Field> fields, String name, boolean shouldGenerateValidationGating) {
        String addFields = fields.stream().map(field -> DecoderGenerator.addField(field, name, shouldGenerateValidationGating ? "            " : "        ")).collect(Collectors.joining());
        String generatedFieldEntryCode = shouldGenerateValidationGating ? "        if (CODEC_VALIDATION_ENABLED)\n        {\n%s        }\n" : "%s";
        int hashMapSize = ConstantGenerator.sizeHashSet(fields);
        return String.format("    public final IntHashSet %2$s = new IntHashSet(%1$d);\n\n    {\n%3$s    }\n\n", hashMapSize, name, String.format(generatedFieldEntryCode, addFields));
    }

    public static String addField(Field field, String name, String prefix) {
        return String.format("%1$s%2$s.add(Constants.%3$s);\n", prefix, name, GenerationUtil.constantName(field.name()));
    }

    private CharSequence generateEnumValidation(Entry entry) {
        Field field = (Field)entry.element();
        if (!EnumGenerator.hasEnumGenerated(field)) {
            return "";
        }
        String name = entry.name();
        int tagNumber = field.number();
        Field.Type type = field.type();
        String propertyName = JavaUtil.formatPropertyName((String)name);
        boolean isPrimitive = type.isIntBased() || type == Field.Type.CHAR;
        String enumValidation = String.format("        if (" + this.codecRejectUnknownEnumValueEnabled + " && !%1$s.isValid(%2$s%4$s))\n        {\n            invalidTagId = %3$s;\n            rejectReason = " + VALUE_IS_INCORRECT + ";\n            return false;\n        }\n", EnumGenerator.enumName(name), propertyName, tagNumber, isPrimitive ? "()" : "Wrapper");
        String enumValidationMethod = type.isMultiValue() ? String.format("          int %1$sOffset = 0;\n          for (int i = 0; i < %1$sLength; i++)\n          {\n              if (%1$s()[i] == ' ')\n              {\n                  %1$sWrapper.wrap(%1$s(), %1$sOffset, i - %1$sOffset);\n%2$s                  %1$sOffset = i + 1;\n              }\n          }\n          %1$sWrapper.wrap(%1$s(), %1$sOffset, %1$sLength - %1$sOffset);\n%2$s", propertyName, enumValidation) : String.format((isPrimitive ? "" : "        %1$sWrapper.wrap(%1$s(), %1$sLength);\n") + "%2$s", propertyName, enumValidation);
        return entry.required() ? enumValidationMethod : String.format("        if (has%1$s)\n        {\n%2$s        }\n", entry.name(), enumValidationMethod);
    }

    private CharSequence generateGroupValidation(Entry entry) {
        Group group = (Group)entry.element();
        Entry numberField = group.numberField();
        String numberFieldName = numberField.name();
        boolean required = entry.required();
        String validationCode = String.format("%3$s        {\n%3$s            int count = 0;\n%3$s            final %4$s iterator = %2$s.iterator();\n%3$s            for (final %1$s group : iterator)\n%3$s            {\n%3$s                count++;%3$s                if (!group.validate())\n%3$s                {\n%3$s                    invalidTagId = group.invalidTagId();\n%3$s                    rejectReason = group.rejectReason();\n%3$s                    return false;\n%3$s                }\n%3$s            }\n%3$s            if (count != iterator.numberFieldValue())\n%3$s            {\n%3$s                invalidTagId = %5$s;\n%3$s                rejectReason = %6$s;\n%3$s                return false;\n%3$s            }\n%3$s        }\n", DecoderGenerator.decoderClassName(group), DecoderGenerator.iteratorFieldName(group), required ? "" : "    ", DecoderGenerator.iteratorClassName(group), numberField.number(), INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP);
        if (required) {
            return validationCode;
        }
        return String.format("        if (has%1$s)\n        {\n%2$s        }\n", numberFieldName, validationCode);
    }

    private Stream<Field> requiredFields(List<Entry> entries) {
        return entries.stream().filter(Entry::required).flatMap(this::extractRequiredFields);
    }

    private Stream<Field> extractRequiredFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.of((Field)group.numberField().element()), (e, component) -> this.requiredFields(component.entries()));
    }

    private Stream<Field> extractFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.concat(Stream.of((Field)group.numberField().element()), group.entries().stream().flatMap(this::extractFields)), (e, component) -> component.entries().stream().flatMap(this::extractFields));
    }

    private Stream<Field> extractFields(List<Entry> entries) {
        return entries.stream().flatMap(this::extractFields);
    }

    private void componentInterface(Component component) {
        String className = DecoderGenerator.decoderClassName(component);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            List interfaces = component.allComponents().map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
            String interfaceExtension = interfaces.isEmpty() ? "" : " extends " + String.join((CharSequence)", ", interfaces);
            this.generateImports("Decoder", AggregateType.COMPONENT, (Writer)out, Encoder.class);
            this.importEncoders(component, (Writer)out);
            out.append(String.format("\npublic interface %1$s %2$s\n{\n\n", className, interfaceExtension));
            for (Entry entry : component.entries()) {
                this.interfaceGetter(component, entry, (Writer)out);
            }
            out.append("\n}\n");
        });
    }

    private void interfaceGetter(Aggregate parent, Entry entry, Writer out) {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldInterfaceGetter(entry, (Field)field))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupInterfaceGetter(parent, (Group)group, out)), (ResourceConsumer<Component>)((ResourceConsumer)component -> {}));
    }

    private void groupInterfaceGetter(Aggregate parent, Group group, Writer out) throws IOException {
        this.groupClass(group, out);
        this.generateGroupIterator(parent, out, group);
        Entry numberField = group.numberField();
        out.append(String.format("public %1$s %2$s();\n", DecoderGenerator.iteratorClassName(group), DecoderGenerator.iteratorFieldName(group)));
        out.append(this.fieldInterfaceGetter(numberField, (Field)numberField.element()));
        out.append(String.format("    public %1$s %2$s();\n", DecoderGenerator.decoderClassName(group), JavaUtil.formatPropertyName((String)group.name())));
    }

    private void wrappedForEachEntry(Aggregate aggregate, Writer out, ResourceConsumer<Entry> consumer) throws IOException {
        out.append("\n");
        aggregate.entries().forEach(t -> {
            try {
                consumer.accept(t);
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        });
        out.append("\n");
    }

    private String fieldInterfaceGetter(Entry entry, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String length = type.isStringBased() ? String.format("    public int %1$sLength();\n", fieldName) : "";
        String stringAsciiView = type.isStringBased() ? String.format("    public void %1$s(AsciiSequenceView view);\n", fieldName) : "";
        String optional = !entry.required() ? String.format("    public boolean has%1$s();\n", name) : "";
        String enumDecoder = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? String.format("    public %s %sAsEnum();\n", name, fieldName) : "";
        return String.format("    public %1$s %2$s();\n%3$s%4$s%5$s%6$s", this.javaTypeOf(type), fieldName, optional, length, enumDecoder, stringAsciiView);
    }

    private void generateGetter(Entry entry, Writer out, Set<String> missingOptionalFields) {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldGetter(entry, (Field)field, missingOptionalFields))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupGetter((Group)group, out, missingOptionalFields)), (ResourceConsumer<Component>)((ResourceConsumer)component -> this.componentGetter((Component)component, out, missingOptionalFields)));
    }

    private void groupMethods(Writer out, Aggregate aggregate) throws IOException {
        if (aggregate instanceof Group) {
            this.wrapTrailerAndMessageFieldsInConstructor(out, aggregate);
            out.append(String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        return next;\n    }\n\n    private IntHashSet seenFields = new IntHashSet(%2$d);\n\n", DecoderGenerator.decoderClassName(aggregate), ConstantGenerator.sizeHashSet(aggregate.entries())));
        }
    }

    private void wrapTrailerAndMessageFieldsInConstructor(Writer out, Aggregate aggregate) throws IOException {
        out.append(String.format("    private final TrailerDecoder trailer;\n    private final IntHashSet %1$s;\n    public %2$s(final TrailerDecoder trailer, final IntHashSet %1$s)\n    {\n        this.trailer = trailer;\n        this.%1$s = %1$s;\n    }\n\n", "messageFields", DecoderGenerator.decoderClassName(aggregate)));
    }

    private void wrapTrailerInConstructor(Writer out, Aggregate aggregate) throws IOException {
        out.append(String.format("    private final TrailerDecoder trailer;\n    public %1$s(final TrailerDecoder trailer)\n    {\n        this.trailer = trailer;\n    }\n\n", DecoderGenerator.decoderClassName(aggregate)));
    }

    private String messageType(String fullType, long packedType) {
        return String.format("    public static final long MESSAGE_TYPE = %1$dL;\n\n    public static final String MESSAGE_TYPE_AS_STRING = \"%2$s\";\n\n    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();\n\n    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);\n\n", packedType, fullType);
    }

    private void generateGetters(Writer out, String className, List<Entry> entries) throws IOException {
        List<String> optionalFields = OptionalSessionFields.DECODER_OPTIONAL_SESSION_FIELDS.get(className);
        HashSet<String> missingOptionalFields = optionalFields == null ? Collections.emptySet() : new HashSet<String>(optionalFields);
        for (Entry entry : entries) {
            this.generateGetter(entry, out, missingOptionalFields);
        }
        this.generateMissingOptionalSessionFields(out, missingOptionalFields);
        this.generateOptionalSessionFieldsSupportedMethods(optionalFields, missingOptionalFields, out);
    }

    private void generateMissingOptionalSessionFields(Writer out, Set<String> missingOptionalFields) throws IOException {
        for (String optionalField : missingOptionalFields) {
            String propertyName = JavaUtil.formatPropertyName((String)optionalField);
            out.append(String.format("    public char[] %1$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public boolean has%2$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public int %1$sLength()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public String %1$sAsString()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public void %1$s(final AsciiSequenceView view)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n", propertyName, optionalField));
        }
    }

    private void componentGetter(Component component, Writer out, Set<String> missingOptionalFields) throws IOException {
        Aggregate parentAggregate = this.currentAggregate;
        this.currentAggregate = component;
        this.wrappedForEachEntry(component, out, (ResourceConsumer<Entry>)((ResourceConsumer)entry -> this.generateGetter((Entry)entry, out, missingOptionalFields)));
        this.currentAggregate = parentAggregate;
    }

    private void groupGetter(Group group, Writer out, Set<String> missingOptionalFields) throws IOException {
        if (!(this.currentAggregate instanceof Component)) {
            this.groupClass(group, out);
            this.generateGroupIterator(this.currentAggregate, out, group);
        }
        Entry numberField = group.numberField();
        String prefix = this.fieldGetter(numberField, (Field)numberField.element(), missingOptionalFields);
        out.append(String.format("\n    private %1$s %2$s = null;\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n%3$s\n    private %4$s %5$s = new %4$s(this);\n    public %4$s %5$s()\n    {\n        return %5$s.iterator();\n    }\n\n", DecoderGenerator.decoderClassName(group), JavaUtil.formatPropertyName((String)group.name()), prefix, DecoderGenerator.iteratorClassName(group), DecoderGenerator.iteratorFieldName(group)));
    }

    private void generateGroupIterator(Aggregate parent, Writer out, Group group) throws IOException {
        String numberFieldName = group.numberField().name();
        String formattedNumberFieldName = JavaUtil.formatPropertyName((String)numberFieldName);
        String numberFieldReset = group.numberField().required() ? String.format("parent.%1$s()", formattedNumberFieldName) : String.format("parent.has%1$s() ? parent.%2$s() : 0", numberFieldName, formattedNumberFieldName);
        out.append(String.format("    public class %1$s implements Iterable<%2$s>, java.util.Iterator<%2$s>\n    {\n        private final %3$s parent;\n        private int remainder;\n        private %2$s current;\n\n        public %1$s(final %3$s parent)\n        {\n            this.parent = parent;\n        }\n\n        public boolean hasNext()\n        {\n            return remainder > 0 && current != null;\n        }\n        public %2$s next()\n        {\n            remainder--;\n            final %2$s value = current;\n            current = current.next();\n            return value;\n        }\n        public int numberFieldValue()\n        {\n            return %4$s;\n        }\n        public void reset()\n        {\n            remainder = numberFieldValue();\n            current = parent.%5$s();\n        }\n        public %1$s iterator()\n        {\n            reset();\n            return this;\n        }\n    }\n\n", DecoderGenerator.iteratorClassName(group), DecoderGenerator.decoderClassName(group), DecoderGenerator.decoderClassName(parent), numberFieldReset, JavaUtil.formatPropertyName((String)group.name())));
    }

    private String fieldGetter(Entry entry, Field field, Set<String> missingOptionalFields) {
        String offsetField;
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String optionalCheck = this.optionalCheck(entry);
        String asStringBody = this.generateAsStringBody(entry, name, fieldName);
        missingOptionalFields.remove(name);
        String extraStringDecode = type.isStringBased() ? String.format("    public String %1$sAsString()\n    {\n        return %3$s;\n    }\n\n    public void %1$s(final AsciiSequenceView view)\n    {\n%2$s        view.wrap(buffer, %1$sOffset, %1$sLength);\n    }\n\n", fieldName, optionalCheck, asStringBody) : "";
        String lengthBasedFields = type.hasLengthField(this.flyweightsEnabled) ? String.format("    private int %1$sLength;\n\n    public int %1$sLength()\n    {\n%2$s        return %1$sLength;\n    }\n\n%3$s", fieldName, optionalCheck, extraStringDecode) : "";
        String string = offsetField = type.hasOffsetField(this.flyweightsEnabled) ? String.format("    private int %1$sOffset;\n\n%2$s", fieldName, lengthBasedFields) : "";
        String enumValueDecoder = String.format(type.isStringBased() ? "%1$s.decode(%2$sWrapper)" : (this.flyweightsEnabled && (type.isIntBased() || type.isFloatBased()) ? "%1$s.decode(%2$s())" : "%1$s.decode(%2$s)"), EnumGenerator.enumName(name), fieldName);
        String enumStringBasedWrapperField = String.format("    private final CharArrayWrapper %1$sWrapper = new CharArrayWrapper();\n", fieldName);
        String enumDecoder = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? String.format("%4$s    public %6$s %2$sAsEnum()\n    {\n" + (!entry.required() ? "        if (!has%1$s)\n return %6$s.%5$s;\n" : "") + (type.isStringBased() ? "        %2$sWrapper.wrap(%2$s(), %2$sLength);\n" : "") + "        return %3$s;\n    }\n\n", name, fieldName, enumValueDecoder, enumStringBasedWrapperField, "NULL_VAL", EnumGenerator.enumName(name)) : (field.type().isMultiValue() ? enumStringBasedWrapperField : "");
        String lazyInitialisation = DecoderGenerator.fieldLazyInstantialisation(field, fieldName);
        return String.format("    private %1$s %2$s%3$s;\n\n%4$s    public %1$s %2$s()\n    {\n%5$s%9$s        return %2$s;\n    }\n\n%6$s\n%7$s\n%8$s", this.javaTypeOf(type), fieldName, this.fieldInitialisation(type), this.hasField(entry), optionalCheck, this.optionalGetter(entry), offsetField, enumDecoder, this.flyweightsEnabled ? lazyInitialisation : "");
    }

    private String generateAsStringBody(Entry entry, String name, String fieldName) {
        String asStringBody = this.flyweightsEnabled ? String.format(entry.required() ? "buffer != null ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : \"\"" : "has%2$s ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : null", fieldName, name) : String.format(entry.required() ? "new String(%1$s, 0, %1$sLength)" : "has%2$s ? new String(%1$s, 0, %1$sLength) : null", fieldName, name);
        return asStringBody;
    }

    private static String fieldLazyInstantialisation(Field field, String fieldName) {
        String decodeMethod;
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                decodeMethod = String.format("buffer.parseIntAscii(%1$sOffset, %1$sLength)", fieldName);
                break;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                decodeMethod = String.format("buffer.getFloat(%1$s, %1$sOffset, %1$sLength)", fieldName);
                break;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                decodeMethod = String.format("buffer.getChars(%1$s, %1$sOffset, %1$sLength);\n", fieldName);
                break;
            }
            case DATA: 
            case XMLDATA: {
                Field associatedLengthField = field.associatedLengthField();
                if (associatedLengthField == null) {
                    throw new IllegalStateException("No associated length field for: " + field);
                }
                String associatedFieldName = JavaUtil.formatPropertyName((String)associatedLengthField.name());
                return String.format("        if (buffer != null && %2$s > 0)\n        {\n            %1$s = buffer.getBytes(%1$s, %1$sOffset, %2$s);\n        }\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                decodeMethod = String.format("buffer.getBytes(%1$s, %1$sOffset, %1$sLength)", fieldName);
                break;
            }
            default: {
                return "";
            }
        }
        return String.format("        if (buffer != null && %1$sLength > 0)\n        {\n            %1$s = %2$s;\n        }\n", fieldName, decodeMethod);
    }

    private String fieldInitialisation(Field.Type type) {
        switch (type) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return String.format(" = new char[%d]", this.initialBufferSize);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return " = DecimalFloat.newNaNValue()";
            }
            case BOOLEAN: {
                return "";
            }
            case CHAR: {
                return " = MISSING_CHAR";
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return " = MISSING_INT";
            }
            case DATA: 
            case XMLDATA: {
                return this.initByteArray(this.initialBufferSize);
            }
            case UTCTIMESTAMP: {
                return this.initByteArray(24);
            }
            case LOCALMKTDATE: {
                return this.initByteArray(8);
            }
            case UTCTIMEONLY: {
                return this.initByteArray(12);
            }
            case UTCDATEONLY: {
                return this.initByteArray(8);
            }
            case MONTHYEAR: {
                return this.initByteArray(8);
            }
            case TZTIMEONLY: {
                return this.initByteArray(19);
            }
            case TZTIMESTAMP: {
                return this.initByteArray(31);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String initByteArray(int initialBufferSize) {
        return String.format(" = new byte[%d]", initialBufferSize);
    }

    private String optionalGetter(Entry entry) {
        return entry.required() ? "" : this.hasGetter(entry.name());
    }

    private String optionalCheck(Entry entry) {
        return entry.required() ? "" : String.format("        if (!has%s)\n        {\n            throw new IllegalArgumentException(\"No value for optional field: %1$s\");\n        }\n\n", entry.name());
    }

    private String javaTypeOf(Field.Type type) {
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return "int";
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return "DecimalFloat";
            }
            case CHAR: {
                return "char";
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return "char[]";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATA: 
            case XMLDATA: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return "byte[]";
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String decodeMethod(List<Entry> entries, Aggregate aggregate, AggregateType type) {
        boolean hasCommonCompounds = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        boolean isHeader = type == AggregateType.HEADER;
        String endGroupCheck = this.endGroupCheck(aggregate, isGroup);
        String prefix = "    private AsciiBuffer buffer;\n\n    public int decode(final AsciiBuffer buffer, final int offset, final int length)\n    {\n        // Decode " + aggregate.name() + "\n        int seenFieldCount = 0;\n        if (" + "CODEC_VALIDATION_ENABLED" + ")\n        {\n            missingRequiredFields.copy(" + REQUIRED_FIELDS + ");\n" + (isGroup ? "" : "            alreadyVisitedFields.clear();\n") + "        }\n        this.buffer = buffer;\n        final int end = offset + length;\n        int position = offset;\n" + (hasCommonCompounds ? "        position += header.decode(buffer, position, length);\n" : "") + (isGroup ? "        seenFields.clear();\n" : "") + "        int tag;\n\n        while (position < end)\n        {\n            final int equalsPosition = buffer.scan(position, end, '=');\n            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)\n            {\n               return position;\n            }\n            tag = buffer.getInt(position, equalsPosition);\n" + endGroupCheck + "            final int valueOffset = equalsPosition + 1;\n            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);\n" + this.malformedMessageCheck() + "            final int valueLength = endOfField - valueOffset;\n            if (" + "CODEC_VALIDATION_ENABLED" + ")\n            {\n                if (tag <= 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + INVALID_TAG_NUMBER + ";\n                }\n                else if (valueLength == 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_SPECIFIED_WITHOUT_A_VALUE + ";\n                }\n" + this.headerValidation(isHeader) + (isGroup ? "" : "                if (!alreadyVisitedFields.add(tag))\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_APPEARS_MORE_THAN_ONCE + ";\n                }\n") + "                missingRequiredFields.remove(tag);\n                seenFieldCount++;\n            }\n\n            switch (tag)\n            {\n";
        String body = entries.stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
        String suffix = "            default:\n                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)\n                {\n" + (isGroup ? "                    seenFields.remove(tag);\n" : "                    alreadyVisitedFields.remove(tag);\n") + "                }\n" + (isGroup ? "" : "                else\n                {\n                    if (!" + this.unknownFieldPredicate(type) + ")\n                    {\n                        unknownFields.add(tag);\n                    }\n                }\n") + "                if (" + "CODEC_REJECT_UNKNOWN_FIELD_ENABLED" + " || " + this.unknownFieldPredicate(type) + ")\n                {\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 5) + "                }\n\n            }\n\n            if (position < (endOfField + 1))\n            {\n                position = endOfField + 1;\n            }\n        }\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 2) + "    }\n\n";
        return prefix + body + suffix;
    }

    private String malformedMessageCheck() {
        return "            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)\n            {\n                rejectReason = " + VALUE_IS_INCORRECT + ";\n                break;\n            }\n";
    }

    private String decodeTrailerOrReturn(boolean hasCommonCompounds, int indent) {
        return (hasCommonCompounds ? this.indent(indent, "position += trailer.decode(buffer, position, end - position);\n") : "") + this.indent(indent, "return position - offset;\n");
    }

    private String unknownFieldPredicate(AggregateType type) {
        switch (type) {
            case TRAILER: {
                return "REQUIRED_FIELDS.contains(tag)";
            }
            case HEADER: {
                return "true";
            }
            case MESSAGE: {
                return "(trailer.REQUIRED_FIELDS.contains(tag))";
            }
        }
        return "(trailer.REQUIRED_FIELDS.contains(tag) || messageFields.contains(tag))";
    }

    private String endGroupCheck(Aggregate aggregate, boolean isGroup) {
        String endGroupCheck = isGroup ? String.format("            if (!seenFields.add(tag))\n            {\n                if (next == null)\n                {\n                    next = new %1$s(trailer, %2$s);\n                }\n                return position - offset;\n            }\n", DecoderGenerator.decoderClassName(aggregate), "messageFields") : "";
        return endGroupCheck;
    }

    private String headerValidation(boolean isHeader) {
        return isHeader ? "                else if (seenFieldCount == 0 && tag != 8)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 1 && tag != 9)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 2 && tag != 35)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n" : "";
    }

    private String decodeEntry(Entry entry) {
        return entry.matchEntry(e -> this.decodeField((Entry)e, ""), this::decodeGroup, this::decodeComponent);
    }

    private String decodeComponent(Entry entry) {
        Component component = (Component)entry.element();
        return component.entries().stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
    }

    @Override
    protected String componentAppendTo(Component component) {
        return component.entries().stream().map(this::generateEntryAppendTo).collect(Collectors.joining("\n"));
    }

    private String decodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        String groupNumberField = JavaUtil.formatPropertyName((String)group.numberField().name());
        String parseGroup = String.format("                if (%1$s == null)\n                {\n                    %1$s = new %2$s(trailer, %5$s);\n                }\n                %2$s %1$sCurrent = %1$s;\n                position = endOfField + 1;\n                final int %3$s = %4$s;\n                for (int i = 0; i < %3$s && position < end; i++)\n                {\n                    if (%1$sCurrent != null)\n                    {\n                        position += %1$sCurrent.decode(buffer, position, end - position);\n                        %1$sCurrent = %1$sCurrent.next();\n                    }\n                }\n                if (CODEC_VALIDATION_ENABLED)\n                {\n                    final int checkEqualsPosition = buffer.scan(position, end, '=');\n                    if (checkEqualsPosition != AsciiBuffer.UNKNOWN_INDEX)\n                    {\n                        final int checkTag = buffer.getInt(position, checkEqualsPosition);\n                        if (%1$s.ALL_GROUP_FIELDS.contains(checkTag))\n                        {\n                            invalidTagId = tag;\n                            rejectReason = %6$s;\n                            return position;\n                        }\n                    }\n                }\n", JavaUtil.formatPropertyName((String)group.name()), DecoderGenerator.decoderClassName(group), groupNumberField, this.flyweightsEnabled ? groupNumberField + "()" : "this." + groupNumberField, "messageFields", INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP);
        return this.decodeField(group.numberField(), parseGroup);
    }

    private String decodeField(Entry entry, String suffix) {
        Field field = (Field)entry.element();
        String name = entry.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        return String.format("            case Constants.%s:\n%s%s%s%s%s                break;\n", GenerationUtil.constantName(name), this.optionalAssign(entry), this.fieldDecodeMethod(field, fieldName), this.storeOffsetForVariableLengthFields(field.type(), fieldName), this.storeLengthForVariableLengthFields(field.type(), fieldName), suffix);
    }

    private String storeLengthForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasLengthField(this.flyweightsEnabled) ? String.format("                %sLength = valueLength;\n", fieldName) : "";
    }

    private String storeOffsetForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasOffsetField(this.flyweightsEnabled) ? String.format("                %sOffset = valueOffset;\n", fieldName) : "";
    }

    private String optionalAssign(Entry entry) {
        return entry.required() ? "" : String.format("                has%s = true;\n", entry.name());
    }

    private String fieldDecodeMethod(Field field, String fieldName) {
        String decodeMethod;
        String prefix = String.format("                %s = ", fieldName);
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = "buffer.getInt(valueOffset, endOfField)";
                break;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getFloat(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            case CHAR: {
                decodeMethod = "buffer.getChar(valueOffset)";
                break;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getChars(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            case BOOLEAN: {
                decodeMethod = "buffer.getBoolean(valueOffset)";
                break;
            }
            case DATA: 
            case XMLDATA: {
                String associatedFieldName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                if (this.flyweightsEnabled) {
                    return String.format("                endOfField = valueOffset + %1$s();\n", associatedFieldName);
                }
                return String.format("                %1$s = buffer.getBytes(%1$s, valueOffset, %2$s);\n                endOfField = valueOffset + %2$s;\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getBytes(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)field.type()) + " in " + fieldName);
            }
        }
        return prefix + decodeMethod + ";\n";
    }

    @Override
    protected String stringAppendTo(String fieldName) {
        return String.format("builder.append(%1$s(), 0, %1$sLength())", fieldName);
    }

    @Override
    protected String dataAppendTo(Field field, String fieldName) {
        String lengthName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
        if (this.flyweightsEnabled) {
            return String.format("appendData(builder, %1$s(), %2$s())", fieldName, lengthName);
        }
        return String.format("appendData(builder, %1$s, %2$s)", fieldName, lengthName);
    }

    @Override
    protected String timeAppendTo(String fieldName) {
        if (this.flyweightsEnabled) {
            return String.format("appendData(builder, %1$s(), %1$sLength())", fieldName);
        }
        return String.format("appendData(builder, %1$s, %1$sLength)", fieldName);
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        return !entry.required();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetNothing(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        return entries.stream().filter(Entry::isComponent).map(entry -> this.resetEntries(((Component)entry.element()).entries(), methods)).collect(Collectors.joining());
    }

    @Override
    protected String resetStringBasedData(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sOffset = 0;\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    @Override
    protected String groupEntryAppendTo(Group group, String name) {
        String numberField = group.numberField().name();
        return String.format("    if (has%2$s)\n    {\n        indent(builder, level);\n        builder.append(\"\\\"%1$s\\\": [\\n\");\n        %3$s %4$s = this.%4$s;\n        for (int i = 0, size = this.%5$s; i < size; i++)\n        {\n            indent(builder, level);\n            %4$s.appendTo(builder, level + 1);            if (%4$s.next() != null)\n            {\n                builder.append(',');\n            }\n            builder.append('\\n');\n            %4$s = %4$s.next();        }\n        indent(builder, level);\n        builder.append(\"],\\n\");\n    }\n", name, numberField, DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField));
    }

    private String generateToEncoder(Aggregate aggregate) {
        String entriesToEncoder = aggregate.entries().stream().map(this::generateEntryToEncoder).collect(Collectors.joining("\n"));
        String name = aggregate.name();
        return String.format("    /**\n     * {@inheritDoc}\n     */\n    public %1$s toEncoder(final Encoder encoder)\n    {\n        return toEncoder((%1$s)encoder);\n    }\n\n    public %1$s toEncoder(final %1$s encoder)\n    {\n        encoder.reset();\n        %2$s        return encoder;\n    }\n\n", EncoderGenerator.encoderClassName(name), entriesToEncoder);
    }

    private String generateEntryToEncoder(Entry entry) {
        return this.generateEntryToEncoder(entry, "encoder");
    }

    private String generateEntryToEncoder(Entry entry, String encoderName) {
        if (this.isBodyLength(entry)) {
            return "";
        }
        Entry.Element element = entry.element();
        String name = entry.name();
        if (element instanceof Field) {
            Field field = (Field)element;
            String fieldToEncoder = this.fieldToEncoder(field, encoderName);
            if (this.appendToChecksHasGetter(entry, field)) {
                String indentedFieldAppender = NEWLINE.matcher(fieldToEncoder).replaceAll("    ");
                return String.format("if (has%1$s())\n        {\n        %2$s\n        }\n", name, indentedFieldAppender);
            }
            return fieldToEncoder;
        }
        if (element instanceof Group) {
            return this.groupEntryToEncoder((Group)element, name, encoderName);
        }
        if (element instanceof Component) {
            return this.componentToEncoder((Component)element, encoderName);
        }
        return "";
    }

    protected String groupEntryToEncoder(Group group, String name, String encoderName) {
        String numberField = group.numberField().name();
        return String.format("        if (has%1$s)\n        {\n            final int size = this.%4$s;\n            %2$s %3$s = this.%3$s;\n            %6$s %3$sEncoder = %5$s.%3$s(size);\n            for (int i = 0; i < size; i++)\n            {\n                if (%3$s != null)\n                {\n                    %3$s.toEncoder(%3$sEncoder);\n                    %3$s = %3$s.next();\n                    %3$sEncoder = %3$sEncoder.next();\n                }\n            }\n        }\n", numberField, DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField), encoderName, EncoderGenerator.encoderClassName(name));
    }

    protected String componentToEncoder(Component component, String encoderName) {
        String name = component.name();
        String varName = JavaUtil.formatPropertyName((String)name);
        String prefix = String.format("\n        final %1$s %2$s = %3$s.%2$s();", EncoderGenerator.encoderClassName(name), varName, encoderName);
        return component.entries().stream().map(entry -> this.generateEntryToEncoder((Entry)entry, varName)).collect(Collectors.joining("\n", prefix, "\n"));
    }

    private String fieldToEncoder(Field field, String encoderName) {
        String fieldName = JavaUtil.formatPropertyName((String)field.name());
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return String.format("%2$s.%1$s(%1$s(), 0, %1$sLength());", fieldName, encoderName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return String.format("%2$s.%1$s(%1$s(), 0, %1$sLength());", fieldName, encoderName);
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: 
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: 
            case BOOLEAN: 
            case CHAR: {
                return String.format("%2$s.%1$s(%1$s());", fieldName, encoderName);
            }
            case DATA: 
            case XMLDATA: {
                String lengthName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                return String.format("%3$s.%1$s(%1$s()); %3$s.%2$s(%2$s());", fieldName, lengthName, encoderName);
            }
        }
        return "";
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected boolean appendToChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field);
    }
}

