/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MetaAttribute;

public class RedactSequenceUpdateDecoder {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 55;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RedactSequenceUpdateDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 55;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RedactSequenceUpdateDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sessionId() {
        return 1;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 0;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long session() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correctSequenceNumberId() {
        return 2;
    }

    public static int correctSequenceNumberSinceVersion() {
        return 0;
    }

    public static int correctSequenceNumberEncodingOffset() {
        return 8;
    }

    public static int correctSequenceNumberEncodingLength() {
        return 4;
    }

    public static String correctSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int correctSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int correctSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int correctSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int correctSequenceNumber() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int positionId() {
        return 3;
    }

    public static int positionSinceVersion() {
        return 0;
    }

    public static int positionEncodingOffset() {
        return 12;
    }

    public static int positionEncodingLength() {
        return 8;
    }

    public static String positionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long positionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long positionMinValue() {
        return -9223372036854775807L;
    }

    public static long positionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long position() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RedactSequenceUpdateDecoder decoder = new RedactSequenceUpdateDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RedactSequenceUpdate](sbeTemplateId=");
        builder.append(55);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 11) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(11);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 20) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(20);
        builder.append("):");
        builder.append("session=");
        builder.append(this.session());
        builder.append('|');
        builder.append("correctSequenceNumber=");
        builder.append(this.correctSequenceNumber());
        builder.append('|');
        builder.append("position=");
        builder.append(this.position());
        this.limit(originalLimit);
        return builder;
    }
}

