/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.EpochNanoClock;

public class OffsetEpochNanoClock
implements EpochNanoClock {
    private static final long DEFAULT_MEASUREMENT_THRESHOLD_IN_NS = 250L;
    private static final int DEFAULT_MAX_MEASUREMENT_RETRIES = 100;
    private final long initialNanoTime;
    private final long initialCurrentTimeNanos;
    private final boolean isWithinThreshold;

    public OffsetEpochNanoClock() {
        this(100, 250L);
    }

    public OffsetEpochNanoClock(int maxMeasurementRetries, long measurementThresholdInNs) {
        long bestInitialCurrentTimeNanos = 0L;
        long bestInitialNanoTime = 0L;
        long bestNanoTimeWindow = Long.MAX_VALUE;
        for (int i = 0; i < maxMeasurementRetries; ++i) {
            long firstNanoTime = System.nanoTime();
            long initialCurrentTimeMillis = System.currentTimeMillis();
            long secondNanoTime = System.nanoTime();
            long nanoTimeWndow = secondNanoTime - firstNanoTime;
            if (nanoTimeWndow < measurementThresholdInNs) {
                this.initialCurrentTimeNanos = TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis);
                this.initialNanoTime = (firstNanoTime + secondNanoTime) / 2L;
                this.isWithinThreshold = true;
                return;
            }
            if (nanoTimeWndow >= bestNanoTimeWindow) continue;
            bestInitialCurrentTimeNanos = TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis);
            bestInitialNanoTime = (firstNanoTime + secondNanoTime) / 2L;
            bestNanoTimeWindow = nanoTimeWndow;
        }
        this.initialCurrentTimeNanos = bestInitialCurrentTimeNanos;
        this.initialNanoTime = bestInitialNanoTime;
        this.isWithinThreshold = false;
    }

    public long nanoTime() {
        long nanoTimeAdjustment = System.nanoTime() - this.initialNanoTime;
        return this.initialCurrentTimeNanos + nanoTimeAdjustment;
    }

    public boolean isWithinThreshold() {
        return this.isWithinThreshold;
    }
}

