/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.fields.UtcTimeOnlyEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcTimestampEncoder {
    public static final long MIN_EPOCH_MILLIS = -62135596800000L;
    public static final long MAX_EPOCH_MILLIS = 253402300799999L;
    public static final long MIN_EPOCH_MICROS = -62135596800000000L;
    public static final long MAX_EPOCH_MICROS = 253402300799999999L;
    public static final long MIN_EPOCH_NANOS = Long.MIN_VALUE;
    public static final long MAX_EPOCH_NANOS = Long.MAX_VALUE;
    public static final int LENGTH_WITHOUT_MILLISECONDS = 17;
    public static final int LENGTH_WITH_MILLISECONDS = 21;
    public static final int LENGTH_WITH_MICROSECONDS = 24;
    public static final int LENGTH_WITH_NANOSECONDS = 27;
    private static final int LENGTH_OF_DATE = 8;
    private static final int LENGTH_OF_DATE_AND_DASH = 9;
    private static final int MILLISECONDS_EPOCH_FRACTION = EpochFractionFormat.MILLISECONDS.ordinal();
    private static final int MICROSECONDS_EPOCH_FRACTION = EpochFractionFormat.MICROSECONDS.ordinal();
    private final int epochFractionPrecision;
    private final byte[] bytes;
    private final MutableAsciiBuffer flyweight;
    private long startOfNextDayInFraction;
    private long beginningOfDayInFraction;

    public UtcTimestampEncoder() {
        this(EpochFractionFormat.MILLISECONDS);
    }

    @Deprecated
    public UtcTimestampEncoder(boolean usesMillisecondsAsEpochFraction) {
        this(usesMillisecondsAsEpochFraction ? EpochFractionFormat.MILLISECONDS : EpochFractionFormat.MICROSECONDS);
    }

    public UtcTimestampEncoder(EpochFractionFormat epochFractionPrecision) {
        this.epochFractionPrecision = epochFractionPrecision.ordinal();
        switch (epochFractionPrecision) {
            case NANOSECONDS: {
                this.bytes = new byte[27];
                break;
            }
            case MICROSECONDS: {
                this.bytes = new byte[24];
                break;
            }
            case MILLISECONDS: {
                this.bytes = new byte[21];
                break;
            }
            default: {
                throw new RuntimeException("Unknown precision: " + (Object)((Object)epochFractionPrecision));
            }
        }
        this.flyweight = new MutableAsciiBuffer(this.bytes);
    }

    public int encode(long epochFraction) {
        int epochFractionPrecision = this.epochFractionPrecision;
        if (epochFractionPrecision == MILLISECONDS_EPOCH_FRACTION) {
            return UtcTimestampEncoder.encode(epochFraction, this.flyweight, 0);
        }
        if (epochFractionPrecision == MICROSECONDS_EPOCH_FRACTION) {
            return UtcTimestampEncoder.encodeMicros(epochFraction, this.flyweight, 0);
        }
        return UtcTimestampEncoder.encodeNanos(epochFraction, this.flyweight, 0);
    }

    public int initialise(long epochFraction) {
        int lengthWithFraction;
        int fractionFieldLength;
        long fractionInDay;
        long fractionInSecond;
        long maxEpochFraction;
        long minEpochFraction;
        int epochFractionPrecision = this.epochFractionPrecision;
        if (epochFractionPrecision == MILLISECONDS_EPOCH_FRACTION) {
            minEpochFraction = -62135596800000L;
            maxEpochFraction = 253402300799999L;
            fractionInSecond = 1000L;
            fractionInDay = 86400000L;
            fractionFieldLength = 3;
            lengthWithFraction = 21;
        } else if (epochFractionPrecision == MICROSECONDS_EPOCH_FRACTION) {
            minEpochFraction = -62135596800000000L;
            maxEpochFraction = 253402300799999999L;
            fractionInSecond = 1000000L;
            fractionInDay = 86400000000L;
            fractionFieldLength = 6;
            lengthWithFraction = 24;
        } else {
            minEpochFraction = Long.MIN_VALUE;
            maxEpochFraction = Long.MAX_VALUE;
            fractionInSecond = 1000000000L;
            fractionInDay = 86400000000000L;
            fractionFieldLength = 9;
            lengthWithFraction = 27;
        }
        UtcTimestampEncoder.validate(epochFraction, minEpochFraction, maxEpochFraction);
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        long epochDay = UtcTimestampEncoder.epochDay(localSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        this.startOfNextDayInFraction = (epochDay + 1L) * fractionInDay;
        this.beginningOfDayInFraction = this.startOfNextDayInFraction - fractionInDay;
        CalendricalUtil.encodeDate(epochDay, this.flyweight, 0);
        this.flyweight.putChar(8, '-');
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, this.flyweight, 9, fractionFieldLength);
        return lengthWithFraction;
    }

    public int update(long epochFraction) {
        int lengthWithFraction;
        int fractionFieldLength;
        long fractionInSecond;
        if (epochFraction > this.startOfNextDayInFraction || epochFraction < this.beginningOfDayInFraction) {
            return this.initialise(epochFraction);
        }
        int epochFractionPrecision = this.epochFractionPrecision;
        if (epochFractionPrecision == MILLISECONDS_EPOCH_FRACTION) {
            fractionInSecond = 1000L;
            fractionFieldLength = 3;
            lengthWithFraction = 21;
        } else if (epochFractionPrecision == MICROSECONDS_EPOCH_FRACTION) {
            fractionInSecond = 1000000L;
            fractionFieldLength = 6;
            lengthWithFraction = 24;
        } else {
            fractionInSecond = 1000000000L;
            fractionFieldLength = 9;
            lengthWithFraction = 27;
        }
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, this.flyweight, 9, fractionFieldLength);
        return lengthWithFraction;
    }

    public byte[] buffer() {
        return this.bytes;
    }

    public static int encode(long epochMillis, MutableAsciiBuffer string, int offset) {
        return UtcTimestampEncoder.encodeFraction(epochMillis, string, offset, -62135596800000L, 253402300799999L, 1000L, 21, 3);
    }

    public static int encodeMicros(long epochMicros, MutableAsciiBuffer string, int offset) {
        return UtcTimestampEncoder.encodeFraction(epochMicros, string, offset, -62135596800000000L, 253402300799999999L, 1000000L, 24, 6);
    }

    public static int encodeNanos(long epochNanos, MutableAsciiBuffer string, int offset) {
        return UtcTimestampEncoder.encodeFraction(epochNanos, string, offset, Long.MIN_VALUE, Long.MAX_VALUE, 1000000000L, 27, 9);
    }

    private static int encodeFraction(long epochFraction, MutableAsciiBuffer string, int offset, long minEpochFraction, long maxEpochFraction, long fractionInSecond, int lengthWithFraction, int fractionFieldLength) {
        UtcTimestampEncoder.validate(epochFraction, minEpochFraction, maxEpochFraction);
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        long epochDay = UtcTimestampEncoder.epochDay(localSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        CalendricalUtil.encodeDate(epochDay, string, offset);
        string.putChar(offset + 8, '-');
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, string, offset + 9, fractionFieldLength);
        return lengthWithFraction;
    }

    private static long epochDay(long localSecond) {
        return Math.floorDiv(localSecond, 86400L);
    }

    private static int fractionOfSecond(long epochFraction, long fractionInSecond) {
        return (int)Math.floorMod(epochFraction, fractionInSecond);
    }

    private static long localSecond(long epochFraction, long fractionInSecond) {
        return Math.floorDiv(epochFraction, fractionInSecond);
    }

    private static void validate(long epochFraction, long minEpochFraction, long maxEpochFraction) {
        if (epochFraction < minEpochFraction || epochFraction > maxEpochFraction) {
            throw new IllegalArgumentException(epochFraction + " is outside of the valid range for this encoder");
        }
    }

    public static enum EpochFractionFormat {
        MILLISECONDS,
        MICROSECONDS,
        NANOSECONDS;

    }
}

