/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcTimeOnlyDecoder {
    public static final int SHORT_LENGTH = 8;
    public static final int LONG_LENGTH = 12;
    public static final int LONG_LENGTH_MICROS = 15;
    public static final int LONG_LENGTH_NANOS = 18;
    static final int MILLIS_FIELD_LENGTH = 3;
    static final int MICROS_FIELD_LENGTH = 6;
    static final int NANOS_FIELD_LENGTH = 9;
    private final AsciiBuffer buffer = new MutableAsciiBuffer();

    public long decode(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimeOnlyDecoder.decode(this.buffer, 0, length);
    }

    public long decodeMicros(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimeOnlyDecoder.decodeMicros(this.buffer, 0, length);
    }

    public long decodeNanos(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return UtcTimeOnlyDecoder.decodeNanos(this.buffer, 0, length);
    }

    public long decode(byte[] bytes) {
        return this.decode(bytes, bytes.length);
    }

    public long decodeMicros(byte[] bytes) {
        return this.decodeMicros(bytes, bytes.length);
    }

    public long decodeNanos(byte[] bytes) {
        return this.decodeNanos(bytes, bytes.length);
    }

    public static long decode(AsciiBuffer time, int offset, int length) {
        return UtcTimeOnlyDecoder.decodeFraction(time, offset, length, 3, 1000L);
    }

    public static long decodeMicros(AsciiBuffer time, int offset, int length) {
        return UtcTimeOnlyDecoder.decodeFraction(time, offset, length, 6, 1000000L);
    }

    public static long decodeNanos(AsciiBuffer time, int offset, int length) {
        return UtcTimeOnlyDecoder.decodeFraction(time, offset, length, 9, 1000000000L);
    }

    private static long decodeFraction(AsciiBuffer time, int offset, int length, int fractionsLength, long fractionsInSecond) {
        int startHour = offset;
        int endHour = startHour + 2;
        int startMinute = endHour + 1;
        int endMinute = startMinute + 2;
        int startSecond = endMinute + 1;
        int endSecond = startSecond + 2;
        int startFraction = endSecond + 1;
        int endFraction = startFraction + fractionsLength;
        int hour = CalendricalUtil.getValidInt(time, startHour, endHour, 0, 23);
        int minute = CalendricalUtil.getValidInt(time, startMinute, endMinute, 0, 59);
        int second = CalendricalUtil.getValidInt(time, startSecond, endSecond, 0, 60);
        int fraction = offset + length > endSecond && time.isDigit(startFraction) ? time.getNatural(startFraction, endFraction) : 0;
        int secondOfDay = hour * 3600 + minute * 60 + second;
        return (long)secondOfDay * fractionsInSecond + (long)fraction;
    }
}

