/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MetaAttribute;

public class ReplayMessagesDecoder {
    public static final int BLOCK_LENGTH = 44;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ReplayMessagesDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 44;
    }

    public int sbeTemplateId() {
        return 53;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 9;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ReplayMessagesDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionId() {
        return 2;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 4;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long session() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 3;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 12;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replayFromSequenceNumberId() {
        return 4;
    }

    public static int replayFromSequenceNumberSinceVersion() {
        return 0;
    }

    public static int replayFromSequenceNumberEncodingOffset() {
        return 20;
    }

    public static int replayFromSequenceNumberEncodingLength() {
        return 4;
    }

    public static String replayFromSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayFromSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayFromSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int replayFromSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replayFromSequenceNumber() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replayFromSequenceIndexId() {
        return 5;
    }

    public static int replayFromSequenceIndexSinceVersion() {
        return 0;
    }

    public static int replayFromSequenceIndexEncodingOffset() {
        return 24;
    }

    public static int replayFromSequenceIndexEncodingLength() {
        return 4;
    }

    public static String replayFromSequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayFromSequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayFromSequenceIndexMinValue() {
        return -2147483647;
    }

    public static int replayFromSequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replayFromSequenceIndex() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replayToSequenceNumberId() {
        return 6;
    }

    public static int replayToSequenceNumberSinceVersion() {
        return 0;
    }

    public static int replayToSequenceNumberEncodingOffset() {
        return 28;
    }

    public static int replayToSequenceNumberEncodingLength() {
        return 4;
    }

    public static String replayToSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayToSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayToSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int replayToSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replayToSequenceNumber() {
        return this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replayToSequenceIndexId() {
        return 7;
    }

    public static int replayToSequenceIndexSinceVersion() {
        return 0;
    }

    public static int replayToSequenceIndexEncodingOffset() {
        return 32;
    }

    public static int replayToSequenceIndexEncodingLength() {
        return 4;
    }

    public static String replayToSequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayToSequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayToSequenceIndexMinValue() {
        return -2147483647;
    }

    public static int replayToSequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replayToSequenceIndex() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int latestReplyArrivalTimeInMsId() {
        return 8;
    }

    public static int latestReplyArrivalTimeInMsSinceVersion() {
        return 0;
    }

    public static int latestReplyArrivalTimeInMsEncodingOffset() {
        return 36;
    }

    public static int latestReplyArrivalTimeInMsEncodingLength() {
        return 8;
    }

    public static String latestReplyArrivalTimeInMsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long latestReplyArrivalTimeInMsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long latestReplyArrivalTimeInMsMinValue() {
        return -9223372036854775807L;
    }

    public static long latestReplyArrivalTimeInMsMaxValue() {
        return Long.MAX_VALUE;
    }

    public long latestReplyArrivalTimeInMs() {
        return this.buffer.getLong(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        ReplayMessagesDecoder decoder = new ReplayMessagesDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 44, 9);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ReplayMessages](sbeTemplateId=");
        builder.append(53);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 9) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(9);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 44) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(44);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("session=");
        builder.append(this.session());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("replayFromSequenceNumber=");
        builder.append(this.replayFromSequenceNumber());
        builder.append('|');
        builder.append("replayFromSequenceIndex=");
        builder.append(this.replayFromSequenceIndex());
        builder.append('|');
        builder.append("replayToSequenceNumber=");
        builder.append(this.replayToSequenceNumber());
        builder.append('|');
        builder.append("replayToSequenceIndex=");
        builder.append(this.replayToSequenceIndex());
        builder.append('|');
        builder.append("latestReplyArrivalTimeInMs=");
        builder.append(this.latestReplyArrivalTimeInMs());
        this.limit(originalLimit);
        return builder;
    }
}

