/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.agrona.SystemUtil;
import org.agrona.generation.CompilerUtil;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.CodecGenerationTool;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class CodecValidationInspector {
    private static final String TEMP_DIR_NAME = SystemUtil.tmpDirName();

    public static void main(String[] args) throws Exception {
        int decodedLength;
        String dictionaryFile = args[0];
        String message = args[1];
        String codecName = args[2];
        if (args.length > 3) {
            char replacementChar = args[3].charAt(0);
            message = message.replace(replacementChar, '\u0001');
        }
        String outputDirPath = "/tmp/fix-codecs";
        System.out.println("message = " + message);
        CodecGenerationTool.main(new String[]{"/tmp/fix-codecs", dictionaryFile});
        File outputDir = new File("/tmp/fix-codecs");
        ArrayList<File> files = new ArrayList<File>();
        CodecValidationInspector.find(outputDir, files);
        System.out.println("Compiling " + files);
        CodecValidationInspector.compileOnDisk(codecName, files);
        System.out.println("CODEC_VALIDATION_ENABLED = " + Validation.CODEC_VALIDATION_ENABLED);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{outputDir.toURI().toURL()});
        Class<?> decoderClass = classLoader.loadClass(codecName);
        Decoder decoder = (Decoder)decoderClass.newInstance();
        MutableAsciiBuffer buffer = new MutableAsciiBuffer(message.getBytes(StandardCharsets.US_ASCII));
        int length = buffer.capacity();
        try {
            decodedLength = decoder.decode(buffer, 0, length);
        }
        catch (Exception e) {
            System.out.println(decoder);
            throw e;
        }
        if (decodedLength != length) {
            System.out.println("decodedLength = " + decodedLength + " vs length = " + length);
        }
        if (decoder.validate()) {
            System.out.println("Codec Validated Ok!");
        } else {
            System.out.println("Failed Validation");
            System.out.println("Reason = " + (Object)((Object)RejectReason.decode(decoder.rejectReason())));
            System.out.println("invalidTagId = " + decoder.invalidTagId());
        }
        System.out.println(decoder);
    }

    private static void find(File dir, List<File> files) {
        for (File file : dir.listFiles()) {
            if (file.isFile() && file.canRead() && file.getName().endsWith(".java")) {
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            CodecValidationInspector.find(file, files);
        }
    }

    public static void compileOnDisk(String className, Collection<File> files) throws ClassNotFoundException, IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            ArrayList<String> options = new ArrayList<String>(Arrays.asList("-classpath", System.getProperty("java.class.path") + File.pathSeparator + TEMP_DIR_NAME));
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            if (!CompilerUtil.compile(diagnostics, (JavaCompiler.CompilationTask)task)) {
                System.err.println("Compilation Failed!");
            }
        }
    }
}

