/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;

public class MessageHeaderEncoder {
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public MessageHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int templateIdEncodingOffset() {
        return 2;
    }

    public static int templateIdEncodingLength() {
        return 2;
    }

    public static int templateIdNullValue() {
        return 65535;
    }

    public static int templateIdMinValue() {
        return 0;
    }

    public static int templateIdMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder templateId(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int schemaIdEncodingOffset() {
        return 4;
    }

    public static int schemaIdEncodingLength() {
        return 2;
    }

    public static int schemaIdNullValue() {
        return 65535;
    }

    public static int schemaIdMinValue() {
        return 0;
    }

    public static int schemaIdMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder schemaId(int value) {
        this.buffer.putShort(this.offset + 4, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int versionEncodingOffset() {
        return 6;
    }

    public static int versionEncodingLength() {
        return 2;
    }

    public static int versionNullValue() {
        return 65535;
    }

    public static int versionMinValue() {
        return 0;
    }

    public static int versionMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder version(int value) {
        this.buffer.putShort(this.offset + 6, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        MessageHeaderDecoder writer = new MessageHeaderDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

