/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.generation.OptionalSessionFields;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

public class EncoderGenerator
extends Generator {
    private static final Set<String> REQUIRED_SESSION_CODECS = new HashSet<String>(Arrays.asList("LogonEncoder", "ResendRequestEncoder", "LogoutEncoder", "HeartbeatEncoder", "RejectEncoder", "TestRequestEncoder", "SequenceResetEncoder"));
    private static final String SUFFIX = "        buffer.putSeparator(position);\n        position++;\n%s";
    private static final String TRAILER_ENCODE_PREFIX = "    // |10=...|\n    long finishMessage(final MutableAsciiBuffer buffer, final int messageStart, final int offset)\n    {\n        int position = offset;\n\n        final int checkSum = buffer.computeChecksum(messageStart, position);\n        buffer.putBytes(position, checkSumHeader, 0, checkSumHeaderLength);\n        position += checkSumHeaderLength;\n        buffer.putNaturalPaddedIntAscii(position, 3, checkSum);\n        position += 3;\n        buffer.putSeparator(position);\n        position++;\n\n        return Encoder.result(position - messageStart, messageStart);\n    }\n    // Optional trailer fields\n    int startTrailer(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final int start = offset;\n        int position = start;\n\n";
    private static final String HEADER_ENCODE_PREFIX = "    // 8=...|9=...|\n    int finishHeader(final MutableAsciiBuffer buffer, final int bodyStart, final int bodyLength)\n    {\n        int position = bodyStart - 1;\n\n        buffer.putSeparator(position);\n        position = buffer.putNaturalIntAsciiFromEnd(bodyLength, position);\n        position -= bodyLengthHeaderLength;\n        buffer.putBytes(position, bodyLengthHeader, 0, bodyLengthHeaderLength);\n\n        if (beginStringLength > 0) {\n        position--;\n        buffer.putSeparator(position);\n        position -= beginStringLength;\n        buffer.putBytes(position, beginString, beginStringOffset, beginStringLength);\n        position -= beginStringHeaderLength;\n        buffer.putBytes(position, beginStringHeader, 0, beginStringHeaderLength);\n        } else if (CODEC_VALIDATION_ENABLED)\n        {\n            throw new EncodingException(\"Missing Field: BeginString\");\n        }\n\n        return position;\n    }\n\n    // 35=...| + other header fields\n    public long startMessage(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final int start = offset + beginStringLength + 16;\n        int position = start;";
    private static final String GROUP_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset, final int remainingElements)\n    {\n        if (remainingElements == 0)\n        {\n            return 0;\n        }\n\n        int position = offset;\n\n";
    private static final String MESSAGE_ENCODE_PREFIX = "    public long encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final long startMessageResult = header.startMessage(buffer, offset);\n        final int bodyStart = Encoder.offset(startMessageResult);\n        int position = bodyStart + Encoder.length(startMessageResult);\n\n";
    private static final String OTHER_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        int position = offset;\n\n";
    private static final String RESET_NEXT_GROUP = "        if (next != null)        {\n            next.reset();\n        }\n";
    private final byte[] buffer = new byte[MutableAsciiBuffer.LONGEST_INT_LENGTH + 1];
    private final MutableAsciiBuffer string = new MutableAsciiBuffer(this.buffer);
    private final String beginString;

    private static String encoderClassName(String name) {
        return JavaUtil.formatClassName((String)(name + "Encoder"));
    }

    public EncoderGenerator(Dictionary dictionary, String builderPackage, String builderCommonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownFieldClass, Class<?> rejectUnknownEnumValueClass) {
        super(dictionary, builderPackage, builderCommonPackage, outputManager, validationClass, rejectUnknownFieldClass, rejectUnknownEnumValueClass, false);
        Component header = dictionary.header();
        this.validateHasField(header, "BeginString");
        this.validateHasField(header, "BodyLength");
        this.beginString = dictionary.beginString();
    }

    private void validateHasField(Component header, String fieldName) {
        if (!header.hasField(fieldName)) {
            throw new IllegalArgumentException("Header does not contain needed field : " + fieldName);
        }
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType aggregateType) {
        String className = EncoderGenerator.encoderClassName(aggregate.name());
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            if (REQUIRED_SESSION_CODECS.contains(className)) {
                out.append(GenerationUtil.importFor("uk.co.real_logic.artio.builder.Abstract" + className));
            }
            this.generateImports("Encoder", aggregateType, (Writer)out, DirectBuffer.class, MutableDirectBuffer.class, UnsafeBuffer.class, AsciiSequenceView.class);
            this.generateAggregateClass(aggregate, aggregateType, className, (Writer)out);
        });
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Encoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        Entry numberField = group.numberField();
        return String.format("    public void %1$s()\n    {\n        if (%2$s != null)\n        {\n            %2$s.reset();\n        }\n        %3$s = 0;\n        has%4$s = false;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name());
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        List<Object> interfaces;
        boolean isMessage;
        boolean isHeader = type == AggregateType.HEADER;
        boolean bl = isMessage = type == AggregateType.MESSAGE;
        if (isMessage) {
            String parentName = REQUIRED_SESSION_CODECS.contains(className) ? "Abstract" + className : Encoder.class.getSimpleName();
            interfaces = Collections.singletonList(parentName);
        } else {
            interfaces = isHeader ? Collections.singletonList(SessionHeaderEncoder.class.getName()) : Collections.emptyList();
        }
        out.append(this.classDeclaration(className, interfaces, type == AggregateType.GROUP));
        out.append(this.constructor(aggregate, type, this.dictionary));
        if (isMessage) {
            out.append(this.commonCompoundImports("Encoder", false, ""));
        } else if (type == AggregateType.GROUP) {
            Group group = (Group)aggregate;
            out.append(this.nextMethod(group));
        } else if (type == AggregateType.HEADER) {
            out.append(String.format("\n    private static final byte[] DEFAULT_BEGIN_STRING=\"%s\".getBytes(StandardCharsets.US_ASCII);\n\n", this.beginString));
        }
        this.precomputedHeaders(out, aggregate.entries());
        this.generateSetters(out, className, aggregate.entries());
        out.append(this.encodeMethod(aggregate.entries(), type));
        out.append(this.completeResetMethod(aggregate, isMessage, type));
        out.append(this.toString(aggregate, isMessage));
        out.append("}\n");
    }

    private String completeResetMethod(Aggregate aggregate, boolean isMessage, AggregateType type) {
        String additionalReset;
        switch (type) {
            case GROUP: {
                additionalReset = RESET_NEXT_GROUP;
                break;
            }
            case HEADER: {
                additionalReset = "        beginString(DEFAULT_BEGIN_STRING);\n";
                break;
            }
            default: {
                additionalReset = "";
            }
        }
        return super.completeResetMethod(isMessage, aggregate.entries(), additionalReset);
    }

    private void generateGroupClass(Group group, Writer out) throws IOException {
        String className = EncoderGenerator.encoderClassName(group.name());
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    private String nextMethod(Group group) {
        return String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        if (next == null)\n        {\n            next = new %1$s();\n        }\n        return next;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()));
    }

    private String constructor(Aggregate aggregate, AggregateType type, Dictionary dictionary) {
        if (type == AggregateType.MESSAGE) {
            Component header = dictionary.header();
            Message message = (Message)aggregate;
            int packedType = message.packedType();
            String fullType = message.fullType();
            String msgType = header.hasField("MsgType") ? String.format("        header.msgType(\"%s\");\n", fullType) : "";
            return String.format("    public int messageType()\n    {\n        return %s;\n    }\n\n    public %sEncoder()\n    {\n%s    }\n\n", packedType, aggregate.name(), msgType);
        }
        if (type == AggregateType.HEADER) {
            return String.format("    public %sEncoder()\n    {\n        beginString(DEFAULT_BEGIN_STRING);\n    }\n\n", aggregate.name());
        }
        return "";
    }

    private void generateSetters(Writer out, String className, List<Entry> entries) throws IOException {
        List<String> optionalFields = OptionalSessionFields.ENCODER_OPTIONAL_SESSION_FIELDS.get(className);
        HashSet<String> missingOptionalFields = optionalFields == null ? Collections.emptySet() : new HashSet<String>(optionalFields);
        for (Entry entry : entries) {
            this.generateSetter(className, entry, out, missingOptionalFields);
        }
        this.generateMissingOptionalSessionFields(out, className, missingOptionalFields);
        this.generateOptionalSessionFieldsSupportedMethods(optionalFields, missingOptionalFields, out);
    }

    private void generateMissingOptionalSessionFields(Writer out, String className, Set<String> missingOptionalFields) throws IOException {
        for (String optionalField : missingOptionalFields) {
            String propertyName = JavaUtil.formatPropertyName((String)optionalField);
            out.append(String.format("    public %2$s %1$s(CharSequence value)\n    {\n        throw new UnsupportedOperationException();\n    }\n", propertyName, className));
        }
    }

    private void generateSetter(String className, Entry entry, Writer out, Set<String> optionalFields) {
        if (!this.isBodyLength(entry)) {
            entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.generateFieldSetter(className, (Field)field, optionalFields))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.generateGroup(className, (Group)group, out, optionalFields)), (ResourceConsumer<Component>)((ResourceConsumer)component -> this.generateComponentField(EncoderGenerator.encoderClassName(entry.name()), (Component)component, out)));
        }
    }

    private String generateFieldSetter(String className, Field field, Set<String> optionalFields) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        String hasField = String.format("    private boolean has%1$s;\n\n", name) + this.hasGetter(name);
        String hasAssign = String.format("        has%s = true;\n", name);
        String enumSetter = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? this.enumSetter(className, fieldName, field.name()) : "";
        Function<String, String> generateSetter = type -> this.generateSetter(name, (String)type, fieldName, hasField, className, hasAssign, enumSetter);
        optionalFields.remove(name);
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.generateStringSetter(className, fieldName, name, enumSetter);
            }
            case BOOLEAN: {
                return generateSetter.apply("boolean");
            }
            case CHAR: {
                return generateSetter.apply("char");
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return generateSetter.apply("int");
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return this.decimalFloatSetter(fieldName, hasField, className, hasAssign, enumSetter);
            }
            case DATA: 
            case XMLDATA: {
                return generateSetter.apply("byte[]");
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.generateBytesSetter(className, fieldName, name);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)field.type()));
    }

    private void generateGroup(String className, Group group, Writer out, Set<String> optionalFields) throws IOException {
        this.generateGroupClass(group, out);
        Entry numberField = group.numberField();
        this.generateSetter(className, numberField, out, optionalFields);
        out.append(String.format("\n    private %1$s %2$s = null;\n\n    public %1$s %2$s(final int numberOfElements)\n    {\n        has%3$s = true;\n        %4$s = numberOfElements;\n        if (%2$s == null)\n        {\n            %2$s = new %1$s();\n        }\n        return %2$s;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()), JavaUtil.formatPropertyName((String)group.name()), numberField.name(), JavaUtil.formatPropertyName((String)numberField.name())));
    }

    private String generateBytesSetter(String className, String fieldName, String name) {
        return String.format("    private final MutableDirectBuffer %1$s = new UnsafeBuffer();\n\n    private int %1$sOffset = 0;\n\n    private int %1$sLength = 0;\n\n    public %2$s %1$s(final DirectBuffer value, final int offset, final int length)\n    {\n        %1$s.wrap(value);\n        %1$sOffset = offset;\n        %1$sLength = length;\n        return this;\n    }\n\n    public %2$s %1$s(final DirectBuffer value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    public %2$s %1$s(final DirectBuffer value)\n    {\n        return %1$s(value, 0, value.capacity());\n    }\n\n    public %2$s %1$s(final byte[] value, final int offset, final int length)\n    {\n        %1$s.wrap(value);\n        %1$sOffset = offset;\n        %1$sLength = length;\n        return this;\n    }\n\n    public %2$s %1$s(final byte[] value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    public %2$s %1$s(final byte[] value)\n    {\n        return %1$s(value, 0, value.length);\n    }\n\n    public boolean has%3$s()\n    {\n        return %1$sLength > 0;\n    }\n\n    public MutableDirectBuffer %1$s()\n    {\n        return %1$s;\n    }\n\n    public String %1$sAsString()\n    {\n        return %1$s.getStringWithoutLengthAscii(%1$sOffset, %1$sLength);\n    }\n\n", fieldName, className, name);
    }

    private String generateStringSetter(String className, String fieldName, String name, String enumSetter) {
        return String.format("%2$s    public %3$s %1$s(final CharSequence value)\n    {\n        toBytes(value, %1$s);\n        %1$sOffset = 0;\n        %1$sLength = value.length();\n        return this;\n    }\n\n    public %3$s %1$s(final AsciiSequenceView value)\n    {\n        final DirectBuffer buffer = value.buffer();\n        if (buffer != null)\n        {\n            %1$s.wrap(buffer);\n            %1$sOffset = value.offset();\n            %1$sLength = value.length();\n        }\n        return this;\n    }\n\n    public %3$s %1$s(final char[] value)\n    {\n        return %1$s(value, 0, value.length);\n    }\n\n    public %3$s %1$s(final char[] value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    public %3$s %1$s(final char[] value, final int offset, final int length)\n    {\n        toBytes(value, %1$s, offset, length);\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n%4$s", fieldName, this.generateBytesSetter(className, fieldName, name), className, enumSetter);
    }

    private String generateSetter(String name, String type, String fieldName, String optionalField, String className, String optionalAssign, String enumSetter) {
        return String.format("    %s %s %s;\n\n%s    public %s %3$s(%2$s value)\n    {\n        %3$s = value;\n%s        return this;\n    }\n\n    public %2$s %3$s()\n    {\n        return %3$s;\n    }\n\n%7$s", this.isBodyLength(name) ? "public" : "private", type, fieldName, optionalField, className, optionalAssign, enumSetter);
    }

    private String decimalFloatSetter(String fieldName, String optionalField, String className, String optionalAssign, String enumSetter) {
        return String.format("    private final DecimalFloat %1$s = new DecimalFloat();\n\n%2$s    public %3$s %1$s(DecimalFloat value)\n    {\n        %1$s.set(value);\n%4$s        return this;\n    }\n\n    public %3$s %1$s(long value, int scale)\n    {\n        %1$s.set(value, scale);\n%4$s        return this;\n    }\n\n    public DecimalFloat %1$s()\n    {\n        return %1$s;\n    }\n\n%5$s", fieldName, optionalField, className, optionalAssign, enumSetter);
    }

    private String enumSetter(String className, String fieldName, String enumType) {
        return String.format("    public %s %2$s(%3$s value)\n    {\n        return %2$s(value.representation());\n    }\n\n", className, fieldName, enumType);
    }

    private String encodeMethod(List<Entry> entries, AggregateType aggregateType) {
        String suffix;
        String prefix;
        switch (aggregateType) {
            case TRAILER: {
                prefix = TRAILER_ENCODE_PREFIX;
                break;
            }
            case GROUP: {
                prefix = GROUP_ENCODE_PREFIX;
                break;
            }
            case MESSAGE: {
                prefix = MESSAGE_ENCODE_PREFIX;
                break;
            }
            case HEADER: {
                prefix = HEADER_ENCODE_PREFIX;
                break;
            }
            default: {
                prefix = OTHER_ENCODE_PREFIX;
            }
        }
        String body = entries.stream().map(this::encodeEntry).collect(Collectors.joining("\n"));
        if (aggregateType == AggregateType.MESSAGE) {
            suffix = "        position += trailer.startTrailer(buffer, position);\n\n        final int messageStart = header.finishHeader(buffer, bodyStart, position - bodyStart);\n        return trailer.finishMessage(buffer, messageStart, position);\n    }\n\n";
        } else if (aggregateType == AggregateType.HEADER) {
            suffix = "\n        return Encoder.result(position - start, start);\n    }\n\n";
        } else if (aggregateType == AggregateType.TRAILER) {
            suffix = "        return position - start;\n    }\n\n";
        } else {
            suffix = "        return position - offset;\n    }\n\n";
            if (aggregateType == AggregateType.GROUP) {
                suffix = "        if (next != null)\n        {\n            position += next.encode(buffer, position, remainingElements - 1);\n        }\n" + suffix;
            }
        }
        return prefix + body + suffix;
    }

    private String encodeEntry(Entry entry) {
        if (this.isBodyLength(entry) || this.isBeginString(entry) || this.isCheckSum(entry)) {
            return "";
        }
        return entry.matchEntry(this::encodeField, this::encodeGroup, this::encodeComponent);
    }

    private String encodeField(Entry entry) {
        String enablingSuffix;
        boolean needsMissingThrow;
        Entry.Element element = entry.element();
        Field field = (Field)element;
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        boolean mustCheckFlag = this.hasFlag(entry, field);
        boolean mustCheckLength = type.hasLengthField(false);
        boolean bl = needsMissingThrow = (mustCheckFlag || mustCheckLength) && entry.required() && !"MsgSeqNum".equals(name);
        String enablingPrefix = mustCheckFlag ? String.format("        if (has%s) {\n", name) : (mustCheckLength ? String.format("        if (%sLength > 0) {\n", fieldName) : "");
        String string = enablingSuffix = mustCheckFlag || mustCheckLength ? "        }\n" : "";
        if (needsMissingThrow) {
            enablingSuffix = enablingSuffix + "        else if (" + "CODEC_VALIDATION_ENABLED" + ")\n        {\n            throw new EncodingException(\"Missing Field: " + name + "\");\n        }\n";
        }
        String tag = this.formatTag(fieldName, enablingPrefix);
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return this.putValue(fieldName, tag, "Int", enablingSuffix);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return this.putValue(fieldName, tag, "Float", enablingSuffix);
            }
            case CHAR: {
                return this.putValue(fieldName, tag, "Char", enablingSuffix);
            }
            case BOOLEAN: {
                return this.putValue(fieldName, tag, "Boolean", enablingSuffix);
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.encodeStringField(fieldName, enablingSuffix, tag);
            }
            case DATA: 
            case XMLDATA: {
                return String.format("%s        buffer.putBytes(position, %s);\n        position += %2$s.length;\n        buffer.putSeparator(position);\n        position++;\n%s", tag, fieldName, enablingSuffix);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String encodeStringField(String fieldName, String optionalSuffix, String tag) {
        return this.formatEncoder(fieldName, optionalSuffix, tag, "        buffer.putBytes(position, %s, %2$sOffset, %2$sLength);\n        position += %2$sLength;\n");
    }

    private String formatEncoder(String fieldName, String optionalSuffix, String tag, String format) {
        return String.format("%s" + format + SUFFIX, tag, fieldName, optionalSuffix);
    }

    private String encodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        return String.format("%1$s\n        if (%2$s != null)\n        {\n            position += %2$s.encode(buffer, position, %3$s);\n        }\n", this.encodeField(group.numberField()), JavaUtil.formatPropertyName((String)group.name()), JavaUtil.formatPropertyName((String)group.numberField().name()));
    }

    private String encodeComponent(Entry entry) {
        return String.format("            position += %1$s.encode(buffer, position);\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    private String formatTag(String fieldName, String optionalPrefix) {
        return String.format("%s        buffer.putBytes(position, %sHeader, 0, %2$sHeaderLength);\n        position += %2$sHeaderLength;\n", optionalPrefix, fieldName);
    }

    private String putValue(String fieldName, String tag, String type, String optionalSuffix) {
        return String.format("%s        position += buffer.put%sAscii(position, %s);\n        buffer.putSeparator(position);\n        position++;\n%s", tag, type, fieldName, optionalSuffix);
    }

    private void precomputedHeaders(Writer out, List<Entry> entries) throws IOException {
        for (Entry entry : entries) {
            Entry.Element element = entry.element();
            if (element instanceof Field) {
                this.precomputedFieldHeader(out, (Field)element);
                continue;
            }
            if (!(element instanceof Group)) continue;
            Group group = (Group)element;
            this.precomputedFieldHeader(out, (Field)group.numberField().element());
        }
    }

    private void precomputedFieldHeader(Writer out, Field field) throws IOException {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        int length = this.string.putIntAscii(0, field.number());
        String bytes = IntStream.range(0, length).mapToObj(i -> String.valueOf(this.buffer[i])).collect(Collectors.joining(", ", "", ", (byte) '='"));
        out.append(String.format("    private static final int %sHeaderLength = %d;\n    private static final byte[] %1$sHeader = new byte[] {%s};\n\n", fieldName, length + 1, bytes));
    }

    @Override
    protected String stringToString(String fieldName) {
        return String.format("%1$s.getStringWithoutLengthAscii(%1$sOffset, %1$sLength)", fieldName);
    }

    @Override
    protected String componentToString(Component component) {
        String name = component.name();
        return String.format("                String.format(\"  \\\"%1$s\\\":  %%s\\n\", %2$s.toString().replace(\"\\n\", \"\\n  \"))", name, JavaUtil.formatPropertyName((String)name));
    }

    private void generateComponentField(String className, Component element, Writer out) throws IOException {
        out.append(String.format("    private final %1$s %2$s = new %1$s();\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n", className, JavaUtil.formatPropertyName((String)element.name())));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetByFlag(field.name());
    }

    @Override
    protected String toStringGroupParameters() {
        return "final int remainingEntries";
    }

    @Override
    protected String toStringGroupSuffix() {
        return "        if (remainingEntries > 1)\n        {\n            entries += \",\\n\" + next.toString(remainingEntries - 1);\n        }\n";
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        Field.Type type = field.type();
        return !entry.required() && !type.hasLengthField(false) || type.isFloatBased() || type.isIntBased();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        return entries.stream().filter(Entry::isComponent).map(this::callComponentReset).collect(Collectors.joining());
    }

    @Override
    protected String resetStringBasedData(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String groupEntryToString(Group element, String name) {
        Entry numberField = element.numberField();
        return String.format("                (%3$s > 0 ? String.format(\"  \\\"%1$s\\\": [\\n  %%s\\n  ]\\n\", %2$s.toString(%3$s).replace(\"\\n\", \"\\n  \")) : \"\")", name, JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField.name()));
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return field.type().hasLengthField(false) ? this.resetLength(name) : this.resetByFlag(name);
    }

    @Override
    protected boolean toStringChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field) || field.type().hasLengthField(false);
    }
}

